/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.rio.MessageCode;
import com.sas.rio.RB;
import java.sql.SQLException;
import java.text.MessageFormat;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class RIOException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int code = 0;

    public RIOException(int code, String reason) {
        super(reason);
        this.code = code;
    }

    public RIOException(String reason) {
        super(reason);
        this.code = -1;
    }

    public RIOException(MessageCode messageCode, Object ... arguments) {
        super(MessageFormat.format(RB.getStringResource(messageCode.getResourceKey()), arguments));
    }

    public int getErrorCode() {
        return this.code;
    }

    public SQLException toSQLException() {
        String msg = this.getMessage();
        return this.code >= 0 ? new SQLException(msg, null, this.code, this) : new SQLException(msg, this);
    }
}

