/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.transforms.TransformInputOutputInterface;
import java.awt.Font;
import java.util.StringTokenizer;

public class StringToFontTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = -7318910948915781602L;
    public static final StringToFontTransform defaultInstance = new StringToFontTransform();

    @Override
    public Object transform(Object input) {
        if (input != null) {
            String trimmedInput = ((String)input).trim();
            return this.createFont(trimmedInput);
        }
        return new Font("Serif", 0, 12);
    }

    private Font createFont(String text) {
        String name = text;
        int style = 0;
        int size = 12;
        StringTokenizer st = new StringTokenizer(text, ",\n");
        while (st.hasMoreElements()) {
            name = st.nextToken();
            name = name.trim();
            if (st.hasMoreElements()) {
                String stylestr = st.nextToken();
                if ((stylestr = stylestr.trim()).equals("Plain")) {
                    style = 0;
                } else if (stylestr.equals("Bold")) {
                    style = 1;
                } else if (stylestr.equals("Italic")) {
                    style = 2;
                } else if (stylestr.equals("BoldItalic")) {
                    style = 3;
                }
                if (!st.hasMoreElements()) continue;
                String sizestr = st.nextToken();
                sizestr = sizestr.trim();
                Integer szI = new Integer(sizestr);
                size = szI;
                continue;
            }
            style = 0;
            size = 12;
        }
        return new Font(name, style, size);
    }

    @Override
    public Class getInputClass() {
        return String.class;
    }

    @Override
    public Class getOutputClass() {
        return Font.class;
    }
}

