/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.PublicClonable;
import com.sas.codepolicy.SASScope;
import com.sas.util.LocalizableToStringInterface;
import com.sas.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

@SASScope
public class LocalizableString
implements Cloneable,
PublicClonable,
LocalizableToStringInterface {
    private Locale defaultLocale;
    private LinkedHashMap<Locale, String> localeToTextMap;

    public LocalizableString() {
    }

    public LocalizableString(String text, Locale defaultLocale) {
        this.setDefaultLocale(defaultLocale);
        this.setText(text, defaultLocale);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public String getText(Locale locale) {
        if (this.localeToTextMap != null) {
            Collection<String> values;
            Locale systemDefaultLocale;
            if (this.localeToTextMap.containsKey(locale)) {
                return this.localeToTextMap.get(locale);
            }
            if (null != locale) {
                Locale langLocale;
                boolean hasCountry = false;
                boolean hasLanguage = false;
                String language = "";
                if (null != locale.getCountry() && locale.getCountry().length() > 0) {
                    hasCountry = true;
                }
                if (null != locale.getLanguage() && locale.getLanguage().length() > 0) {
                    hasLanguage = true;
                    language = locale.getLanguage();
                }
                if (hasCountry && hasLanguage && this.localeToTextMap.containsKey(langLocale = new Locale(language))) {
                    return this.localeToTextMap.get(langLocale);
                }
                if (hasLanguage && null != this.defaultLocale && language.equals(this.defaultLocale.getLanguage()) && this.localeToTextMap.containsKey(this.defaultLocale)) {
                    return this.localeToTextMap.get(this.defaultLocale);
                }
            }
            if (this.defaultLocale != null) {
                if (!this.defaultLocale.equals(locale)) {
                    return this.getText(this.defaultLocale);
                }
            } else if (this.defaultLocale == null && !(systemDefaultLocale = Locale.getDefault()).equals(locale)) {
                return this.getText(systemDefaultLocale);
            }
            if ((values = this.localeToTextMap.values()) != null && values.size() > 0) {
                return values.iterator().next();
            }
        }
        return null;
    }

    public void setText(String text, Locale locale) {
        if (this.localeToTextMap == null) {
            this.localeToTextMap = new LinkedHashMap(1);
        }
        this.localeToTextMap.put(locale, text);
    }

    public List<Locale> getLocales() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (this.localeToTextMap != null) {
            Iterator<Locale> localesIterator = this.localeToTextMap.keySet().iterator();
            while (localesIterator.hasNext()) {
                locales.add(localesIterator.next());
            }
        }
        return locales;
    }

    public boolean isTextSet(Locale locale) {
        return this.localeToTextMap != null && this.localeToTextMap.containsKey(locale);
    }

    public void clearText(Locale locale) {
        if (this.localeToTextMap != null && this.localeToTextMap.containsKey(locale)) {
            this.localeToTextMap.remove(locale);
        }
    }

    public void clearAll() {
        this.localeToTextMap = null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LocalizableString clone = (LocalizableString)super.clone();
        if (this.localeToTextMap != null) {
            LinkedHashMap<Locale, String> newMap = new LinkedHashMap<Locale, String>(this.localeToTextMap.size());
            newMap.putAll(this.localeToTextMap);
            clone.localeToTextMap = newMap;
        }
        return clone;
    }

    @Override
    public String toString(Locale locale) {
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return this.getText(locale);
    }

    public String toString() {
        return this.toString(null);
    }

    public boolean equals(Object otherItem) {
        if (otherItem instanceof LocalizableString) {
            LocalizableString other = (LocalizableString)otherItem;
            if (!Util.equal(this.getDefaultLocale(), other.getDefaultLocale())) {
                return false;
            }
            return Util.equal(this.localeToTextMap, other.localeToTextMap);
        }
        return false;
    }
}

