/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.ChainedExceptionInterface;
import com.sas.util.Classes;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class ChainedException
extends Exception
implements ChainedExceptionInterface {
    static final long serialVersionUID = -5552882514700119725L;
    private Throwable chainedException;

    public ChainedException() {
    }

    public ChainedException(String message) {
        super(message);
    }

    public ChainedException(Throwable rootException, String message) {
        super(message == null && rootException == null ? null : (message == null ? rootException.getMessage() : message));
        this.chainedException = rootException;
    }

    @Override
    public Throwable getTargetException() {
        return this.chainedException;
    }

    public Throwable getRootException() {
        return ChainedException.getRootException(this);
    }

    @Override
    public String toString() {
        return ChainedException.toStringBuffer(this, new StringBuffer()).toString();
    }

    public static Throwable getTargetException(Throwable throwable) {
        Throwable cause = null;
        if (throwable instanceof ChainedExceptionInterface) {
            cause = ((ChainedExceptionInterface)((Object)throwable)).getTargetException();
        } else if (throwable instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)throwable).getTargetException();
        } else if (throwable instanceof UndeclaredThrowableException) {
            cause = ((UndeclaredThrowableException)throwable).getUndeclaredThrowable();
        } else if (throwable instanceof PrivilegedActionException) {
            cause = ((PrivilegedActionException)throwable).getException();
        } else if (throwable instanceof ClassNotFoundException) {
            cause = ((ClassNotFoundException)throwable).getException();
        } else if (throwable instanceof ExceptionInInitializerError) {
            cause = ((ExceptionInInitializerError)throwable).getException();
        } else if (throwable instanceof SQLException) {
            cause = ((SQLException)throwable).getNextException();
        } else if (throwable instanceof SQLWarning) {
            cause = ((SQLWarning)throwable).getNextWarning();
        }
        if (cause == null) {
            cause = throwable.getCause();
        }
        return cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Throwable throwable, PrintStream stream, boolean printChain) {
        if (throwable == null) {
            return;
        }
        if (stream == null) {
            stream = System.err;
        }
        PrintStream printStream = stream;
        synchronized (printStream) {
            if (printChain) {
                ChainedException.printStackTrace(ChainedException.getTargetException(throwable), stream, true);
            }
            throwable.printStackTrace(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Throwable throwable, PrintWriter writer, boolean printChain) {
        if (throwable == null) {
            return;
        }
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            if (printChain) {
                ChainedException.printStackTrace(ChainedException.getTargetException(throwable), writer, true);
            }
            throwable.printStackTrace(writer);
        }
    }

    public static StringBuffer printStackTrace(Throwable throwable, StringBuffer stringBuffer, boolean printChain) {
        if (throwable == null) {
            return stringBuffer;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(baos);
        ChainedException.printStackTrace(throwable, printWriter, printChain);
        printWriter.flush();
        String s = baos.toString();
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(s);
        } else {
            stringBuffer.append(s);
        }
        printWriter.close();
        return stringBuffer;
    }

    public static Throwable getRootException(Throwable throwable) {
        Throwable next = ChainedException.getTargetException(throwable);
        if (next != null) {
            return ChainedException.getRootException(next);
        }
        return throwable;
    }

    public static StringBuffer toStringBuffer(Throwable throwable, StringBuffer stringBuffer) {
        Throwable next;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        stringBuffer.append(throwable.getClass().getName());
        if (throwable.getMessage() != null) {
            stringBuffer.append(": ");
            stringBuffer.append(throwable.getMessage());
        }
        if ((next = ChainedException.getTargetException(throwable)) != null) {
            stringBuffer.append(" [ ");
            ChainedException.toStringBuffer(next, stringBuffer);
            stringBuffer.append(" ] ");
        }
        return stringBuffer;
    }

    public static boolean chainContains(Throwable throwable, Class throwableClass) {
        try {
            return Classes.extendsClass(throwable.getClass(), throwableClass) || ChainedException.chainContains(ChainedException.getTargetException(throwable), throwableClass);
        }
        catch (NullPointerException npe) {
            return false;
        }
    }
}

