/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.Info;
import com.sas.text.InvalidFormatException;
import com.sas.text.SASFormatEntry;
import java.util.Locale;

@SASScope
class SASFormatInfo
extends Info {
    private SASFormatEntry sfe;
    private String pattern;
    private int dValue;
    private static String BEST = "BEST";
    private static String NLBEST = "NLBEST";
    private Locale formatLocale;

    public SASFormatInfo(SASFormatEntry entry, String baseFormat, int width, int decimalWidth) throws InvalidFormatException {
        super(entry, baseFormat, width);
        this.dValue = decimalWidth;
        this.sfe = entry;
        if (width == -1) {
            this.pattern = this.sfe.getPattern(baseFormat);
            this.width = this.sfe.getDefaultWidth();
        } else {
            this.pattern = this.sfe.getPattern(baseFormat, width);
        }
        this.formatLocale = this.sfe.getFormatLocale();
    }

    public boolean isPattern() {
        return this.pattern != null;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setWidth(int width) {
        this.width = width;
        try {
            this.pattern = width == -1 ? this.sfe.getPattern(this.baseFormat) : this.sfe.getPattern(this.baseFormat, width);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    public boolean isDecimalWidthSupported() {
        boolean result = false;
        if (this.sfe.isDecimalWidthSupported()) {
            result = this.dValue != 0;
        }
        return result;
    }

    public int getDValue() {
        int result = 0;
        if (this.baseFormat.equals(BEST) || this.baseFormat.equals(NLBEST)) {
            result = this.width - 1;
        } else if (this.sfe.isDecimalWidthSupported()) {
            result = this.dValue;
        }
        return result;
    }

    public boolean setDValue(int dValue) {
        boolean result = false;
        if (this.sfe.isDecimalWidthSupported()) {
            this.dValue = dValue;
            result = true;
        }
        return result;
    }

    public Locale getFormatLocale() {
        return this.formatLocale;
    }
}

