/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.DateValue;
import com.sas.text.MultiEntry;
import com.sas.text.SASFormatEntry;
import com.sas.text.SingleEntry;
import com.sas.text.TableEntry;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Vector;

class Quarter
extends DateValue {
    private SimpleDateFormat sdfMonth;
    private static String[] fnames = new String[]{"QTRR", "YYQR", "YYQRN", "DTYYQC"};
    private static int QTRR = 0;
    private static int YYQR = 1;
    private static int YYQRN = 2;
    private static int DTYYQC = 3;
    private String[] romanNumerals = new String[]{"", "I", "II", "III", "IV"};
    private String longYear = "yyyy";
    private String shortYear = "yy";
    private SimpleDateFormat sdfYear = new SimpleDateFormat();
    private static Object[] quarterFormats;

    protected Quarter() {
        this.sdfMonth = new SimpleDateFormat("MM", Locale.US);
        this.sdfMonth.setLenient(false);
    }

    @Override
    public StringBuffer format(double dateValue) {
        StringBuffer result;
        this.sdfMonth.setTimeZone(this.getTimeZone());
        String formatName = this.info.getBaseFormat();
        long javaDate = 0L;
        javaDate = formatName.equals(fnames[DTYYQC]) ? this.SASDateTimeToJavaDate(dateValue, this.getTimeZone()) : this.SASDateToJavaDate(dateValue, this.getTimeZone());
        this.date.setTime(javaDate);
        Integer iMonth = Integer.valueOf(this.sdfMonth.format(this.date));
        int quarter = (int)(iMonth.doubleValue() / 3.0 + 0.67);
        if (formatName.equals(fnames[QTRR]) || formatName.regionMatches(0, fnames[YYQR], 0, 4)) {
            result = this.formatRomanQuarter(javaDate, quarter, formatName);
        } else if (formatName.equals("JDATEQRW") || formatName.equals("JDATEQTR")) {
            result = this.formatValue(javaDate, false);
            if (result.indexOf("Q") >= 0) {
                int pos = result.indexOf("Q");
                result.replace(pos, pos + 1, String.valueOf(quarter));
            }
        } else if (formatName.equals("JDATESEM") || formatName.equals("JDATESMW")) {
            result = this.formatValue(javaDate, false);
            if (quarter < 3) {
                result.append("\u5e74\u524d\u671f");
            } else {
                result.append("\u5e74\u5f8c\u671f");
            }
        } else {
            result = this.formatValue(javaDate, false);
            result.append(quarter);
        }
        this.insertLeadingBlanks(result);
        return result;
    }

    private StringBuffer formatRomanQuarter(long javaDate, int quarter, String formatName) {
        StringBuffer result;
        String romanNumeral;
        switch (quarter) {
            case 1: {
                romanNumeral = this.romanNumerals[1];
                break;
            }
            case 2: {
                romanNumeral = this.romanNumerals[2];
                break;
            }
            case 3: {
                romanNumeral = this.romanNumerals[3];
                break;
            }
            case 4: {
                romanNumeral = this.romanNumerals[4];
                break;
            }
            default: {
                romanNumeral = "";
            }
        }
        TableEntry te = this.info.getEntry();
        int width = this.info.getWidth();
        if (te instanceof MultiEntry) {
            char separator = ((MultiEntry)te).getSeparator();
            if (width - (1 + romanNumeral.length()) >= 4) {
                this.sdfYear.applyPattern(this.longYear);
            } else {
                this.sdfYear.applyPattern(this.shortYear);
            }
            result = new StringBuffer();
            this.sdfYear.format(this.date, result, this.position);
            result.append(separator);
        } else if (formatName.equals(fnames[YYQRN])) {
            if (width - romanNumeral.length() >= 4) {
                this.sdfYear.applyPattern(this.longYear);
            } else {
                this.sdfYear.applyPattern(this.shortYear);
            }
            result = new StringBuffer();
            this.sdfYear.format(this.date, result, this.position);
        } else {
            result = this.formatValue(javaDate, false);
        }
        result.append(romanNumeral);
        return result;
    }

    static Object[] getDefinedFormats() {
        if (quarterFormats == null) {
            Vector<SingleEntry> temp = new Vector<SingleEntry>(20, 5);
            String className = Quarter.class.getName();
            SingleEntry entry = new SingleEntry("QTRw", className);
            ((SASFormatEntry)entry).addPattern(1, 32, null, true);
            temp.addElement(entry);
            entry = new SingleEntry("QTRRw", className);
            ((SASFormatEntry)entry).addPattern(3, 32, null, true);
            temp.addElement(entry);
            entry = new MultiEntry("YYQxw", className, 'Q');
            ((SASFormatEntry)entry).addPattern(6, 32, "yyyy'Q'", true);
            ((SASFormatEntry)entry).addPattern(4, 5, "yy'Q'");
            temp.addElement(entry);
            entry = new SingleEntry("YYQNw", className);
            ((SASFormatEntry)entry).addPattern(5, 32, "yyyy", true);
            ((SASFormatEntry)entry).addPattern(3, 4, "yy");
            temp.addElement(entry);
            entry = new MultiEntry("YYQRxw", className, 'Q');
            ((SASFormatEntry)entry).addPattern(8, 32, "'Q'", true);
            ((SASFormatEntry)entry).addPattern(6, 7, " ");
            temp.addElement(entry);
            entry = new SingleEntry("YYQRNw", className);
            ((SASFormatEntry)entry).addPattern(7, 32, null, true);
            ((SASFormatEntry)entry).addPattern(5, 6, null);
            temp.addElement(entry);
            entry = new SingleEntry("DTYYQCw", className);
            ((SASFormatEntry)entry).addPattern(6, 6, "yyyy:", true);
            ((SASFormatEntry)entry).addPattern(4, 5, "yy:");
            temp.addElement(entry);
            entry = new SingleEntry("JDATEQRW", className);
            entry.setFormatLocale(Locale.JAPAN);
            ((SASFormatEntry)entry).addPattern(10, 200, "\u7b2c'Q'\u56db\u534a\u671f", true);
            temp.addElement(entry);
            entry = new SingleEntry("JDATEQTR", className);
            entry.setFormatLocale(Locale.JAPAN);
            ((SASFormatEntry)entry).addPattern(10, 200, "\u7b2c'Q'\u56db\u534a\u671f", true);
            temp.addElement(entry);
            entry = new SingleEntry("JDATESEM", className);
            entry.setFormatLocale(Locale.JAPAN);
            ((SASFormatEntry)entry).addPattern(8, 200, "yy", true);
            temp.addElement(entry);
            entry = new SingleEntry("JDATESMW", className);
            entry.setFormatLocale(Locale.JAPAN);
            ((SASFormatEntry)entry).addPattern(8, 200, "yy", true);
            temp.addElement(entry);
            quarterFormats = new Object[temp.size()];
            temp.copyInto(quarterFormats);
        }
        return quarterFormats;
    }
}

