/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.codepolicy.SASScope;
import java.io.ByteArrayOutputStream;

@SASScope
public class PatchableByteArrayOutputStream
extends ByteArrayOutputStream {
    private static final int defaultPatches = 8;
    private int[] patchList = null;
    private int patchLocationCounter = 0;
    private int patchWriteCounter = 0;

    public PatchableByteArrayOutputStream() {
        this.patchList = new int[8];
    }

    public PatchableByteArrayOutputStream(int size) {
        super(size);
        this.patchList = new int[8];
    }

    public PatchableByteArrayOutputStream(int size, int patches) {
        super(size);
        if (patches <= 0) {
            patches = 8;
        }
        this.patchList = new int[patches];
    }

    public void setPatchLocation() {
        this.patchList[this.patchLocationCounter++] = this.count;
    }

    public void skip(int n) {
        for (int i = 0; i < n; ++i) {
            this.write(0);
        }
    }

    public void patch(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.buf, this.patchList[this.patchWriteCounter++], len);
    }

    @Override
    public void reset() {
        this.patchLocationCounter = 0;
        this.patchWriteCounter = 0;
        super.reset();
    }
}

