/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.util.Strings;
import com.sas.util.ValueItem;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.List;
import java.util.Locale;

@SASScope
public class StoredProcessType
extends BaseDataType {
    public static final StoredProcessType DEFAULT_INSTANCE = new StoredProcessType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        block15: {
            if (inputValue instanceof List && ((List)inputValue).size() == 1) {
                inputValue = ((List)inputValue).get(0);
            }
            if (inputValue instanceof Integer) {
                return inputValue;
            }
            if (inputValue instanceof Number) {
                if (StoredProcessType.isInteger((Number)inputValue)) {
                    return new Integer(((Number)inputValue).intValue());
                }
            } else {
                if (inputValue instanceof ValueItem) {
                    return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
                }
                if (inputValue instanceof String) {
                    if (((String)inputValue).trim().length() == 0) {
                        return null;
                    }
                    try {
                        NumberFormat formatter = NumberFormat.getNumberInstance(inputLocale);
                        ParsePosition position = new ParsePosition(0);
                        String parsedString = ((String)inputValue).trim();
                        parsedString = Strings.replace(parsedString, 0, -1, "E+", "E");
                        parsedString = Strings.replace(parsedString, 0, -1, "e+", "e");
                        parsedString = BaseDataType.replaceBreakingSpace(formatter, parsedString);
                        Number number = formatter.parse(parsedString, position);
                        if (number == null || !StoredProcessType.isInteger(number) || position.getErrorIndex() != -1 || position.getIndex() != parsedString.length()) break block15;
                        boolean valid = true;
                        if (formatter instanceof DecimalFormat) {
                            valid = StoredProcessType.isGroupingValid((DecimalFormat)formatter, parsedString);
                        }
                        if (valid) {
                            return new Integer(number.intValue());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
                        return this.coerceValue(((String[])inputValue)[0], inputLocale);
                    }
                    if (inputValue == null) {
                        return null;
                    }
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("IntegerType.unableToConvert.fmt"), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            return null;
        }
        return value.toString();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        return this.coerceValue(input, Locale.US);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    public static boolean isInteger(Number value) {
        int intValue;
        double doubleValue = value.doubleValue();
        return doubleValue == (double)(intValue = value.intValue());
    }

    @Override
    public int getSQLType() {
        return 4;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        return this.coerceValue(value, inputLocale);
    }
}

