/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.models.SASLibraryLocation;
import com.sas.models.SASLibraryLocationInterface;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class SASLibraryLocationType
extends BaseDataType {
    public static final String RB_KEY = "SASLibraryLocationType.";
    public static final SASLibraryLocationType DEFAULT_INSTANCE = new SASLibraryLocationType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof SASLibraryLocationInterface) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            return this.createLibraryLocationFromString((String)inputValue, inputLocale);
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "libraryValueNotValid.ex.txt", inputLocale), inputValue));
    }

    private SASLibraryLocationInterface createLibraryLocationFromString(String text, Locale locale) throws IllegalArgumentException {
        String[] splitText = text.split(" :: ");
        if (splitText.length != 2) {
            throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "libraryValueNotValid.ex.txt", locale), (Object)text));
        }
        String linkLocation = splitText[0];
        String linkLabel = splitText[1];
        SASLibraryLocation library = new SASLibraryLocation(linkLocation, linkLabel);
        return library;
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        SASLibraryLocationInterface library = (SASLibraryLocationInterface)value;
        return library.getSASLibraryLocation() + " :: " + library.getLibref();
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return ((SASLibraryLocationInterface)value).getSASLibraryLocation();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) throws IllegalArgumentException {
        return null;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return null;
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public int getExpressionUsage() {
        return 1111;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (retVal != null && retVal instanceof SASLibraryLocationInterface && retVal == value) {
            SASLibraryLocationInterface library = (SASLibraryLocationInterface)retVal;
            SASLibraryLocation outPut = new SASLibraryLocation();
            outPut.setSASLibraryLocation(library.getSASLibraryLocation());
            outPut.setLibref(library.getLibref());
            return outPut;
        }
        return retVal;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        SASLibraryLocationInterface libloc = (SASLibraryLocationInterface)value;
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (libloc.getLibref() != null) {
            map.put(baseMacroVariableName, libloc.getLibref());
        }
        if (libloc.getSASLibraryLocation() != null) {
            map.put(baseMacroVariableName + "_path", libloc.getSASLibraryLocation());
        }
        return map;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(2);
        extensions.add("");
        extensions.add("_path");
        return extensions;
    }
}

