/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.RB;
import com.sas.text.Message;
import com.sas.text.NLFormats;
import com.sas.util.CalendarUtil;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.util.transforms.StringToMissingValuesTransform;
import java.sql.Time;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope
public class QuarterType
extends BaseDateType {
    public static final String RB_KEY = "QuarterType.";
    public static final QuarterType DEFAULT_INSTANCE = new QuarterType();
    public static final QuarterType DEFAULT_LOCAL_INSTANCE = new QuarterType(TimeZone.getDefault());
    private static final String LONG_QUARTER_PREFIX = "QQQ";
    private static final String ESCAPED_LONG_QUARTER_PREFIX = "'QQQ'";

    public QuarterType() {
    }

    public QuarterType(TimeZone timeZone) {
        super(timeZone);
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof DatePeriod) {
            DatePeriod dp = (DatePeriod)inputValue;
            if (dp.getPeriodType() == DateTypes.QUARTER && Util.equal(dp.getTimeZone(), this.getTimeZone())) {
                return dp;
            }
            return this.coerceValue(dp.toString(null, inputLocale), inputLocale);
        }
        if (inputValue instanceof Calendar) {
            DatePeriod datePeriod = new DatePeriod(((Calendar)inputValue).getTime(), DateTypes.QUARTER, this.getTimeZone(), inputLocale);
            return datePeriod;
        }
        if (inputValue instanceof Date) {
            if (!(inputValue instanceof Time)) {
                DatePeriod datePeriod = new DatePeriod((Date)inputValue, DateTypes.QUARTER, this.getTimeZone(), inputLocale);
                return datePeriod;
            }
        } else {
            if (inputValue instanceof ValueItem) {
                return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
            }
            if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
                return this.coerceValue(((String[])inputValue)[0], inputLocale);
            }
            if (inputValue instanceof String) {
                String value = (String)inputValue;
                if (value.trim().length() == 0) {
                    return null;
                }
                MissingValues missingValue = MissingValues.getNumericMissingValues((String)inputValue);
                if (missingValue != null) {
                    return missingValue;
                }
                SpecialValues specialValue = SpecialValues.valueOf((String)inputValue);
                if (specialValue != null) {
                    return specialValue;
                }
                try {
                    DateTypes[] dateTypes = new DateTypes[]{DateTypes.QUARTER};
                    DatePeriod dp = DatePeriod.parseDatePeriod(value, dateTypes, this.getTimeZone(), inputLocale);
                    if (dp != null) {
                        return dp;
                    }
                }
                catch (ParseException e) {
                    // empty catch block
                }
                Object transformObj = StringToMissingValuesTransform.defaultInstance.transform(value);
                if (transformObj.equals(MissingValues.Dot)) {
                    return MissingValues.Dot;
                }
            } else {
                if (inputValue instanceof MissingValues) {
                    return inputValue;
                }
                if (inputValue instanceof SpecialValues) {
                    return inputValue;
                }
                if (inputValue == null) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("QuarterType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object out = null;
        try {
            MessageFormat mf = new MessageFormat("Q{0}, {1}");
            ParsePosition position = new ParsePosition(0);
            Object[] quarterArray = mf.parse(input, position);
            if (position.getErrorIndex() == -1) {
                input = Message.format("'Q'{0}',' {1}", (Object)new Integer(Integer.valueOf((String)quarterArray[0]) * 3), quarterArray[1]);
            }
            out = new DatePeriod(CalendarUtil.parseDateString(input, "'Q'MM',' yyyy", this.timeZone), DateTypes.QUARTER, this.timeZone, Locale.US);
        }
        catch (ParseException e) {
            out = this.coerceValue(input, Locale.US);
        }
        return out;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        if (value instanceof DatePeriod) {
            Calendar cal = Calendar.getInstance(this.getTimeZone(), Locale.US);
            cal.setTime((Date)value);
            Integer quarter = new Integer(cal.get(2) / 3 + 1);
            String formatString = Message.format("''Q''{0}'','' yyyy", (Object)quarter);
            SimpleDateFormat sdf = new SimpleDateFormat(formatString, Locale.US);
            sdf.setLenient(false);
            this.setCalendarAndTimeZone(sdf);
            return ((DatePeriod)value).toString(sdf, Locale.US);
        }
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public DateFormat getDateFormatter(Object value, Locale locale) {
        String formatString = "";
        if (value instanceof Date) {
            formatString = QuarterType.getQuarterFormatString((Date)value, this.getTimeZone(), locale);
        } else {
            formatString = NLFormats.getPattern(this.getDefaultFormatName(), locale);
            formatString = formatString.replaceAll(LONG_QUARTER_PREFIX, ESCAPED_LONG_QUARTER_PREFIX);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formatString, locale);
        sdf.setLenient(false);
        return sdf;
    }

    public static String getQuarterFormatString(Date date, TimeZone timeZone, Locale locale) {
        String formatString = NLFormats.getPattern(DEFAULT_INSTANCE.getDefaultFormatName(), locale);
        Calendar cal = DataTypeUtil.getCalendar(timeZone, locale);
        formatString = NLFormats.fixQuarterPattern(formatString, date, locale, cal);
        return formatString;
    }

    @Override
    public DateTypes getDateType() {
        return DateTypes.QUARTER;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        return this.getMacroVariableValuesForDatePeriod(DateTypes.QUARTER, macroInfoSource, value, locale);
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object out = this.coerceValue(value, inputLocale);
        if (null != out && out == value && out instanceof DatePeriod) {
            out = ((DatePeriod)out).clone();
        }
        return out;
    }

    @Override
    public String getDefaultFormatName() {
        return "NLDATEYQ";
    }
}

