/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class BooleanType
extends BaseDataType {
    public static final String RB_KEY = "BooleanType.";
    public static final BooleanType DEFAULT_INSTANCE = new BooleanType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof Boolean) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            String stringValue = (String)inputValue;
            int stringLength = (stringValue = stringValue.toLowerCase().trim()).length();
            if (stringLength == 0) {
                return null;
            }
            try {
                boolean boolValue = Boolean.parseBoolean(stringValue);
                return boolValue ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "booleanValueNotValid.ex.txt"), inputValue));
            }
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
            return this.coerceValue(((String[])inputValue)[0], inputLocale);
        }
        if (inputValue instanceof Integer) {
            return (Integer)inputValue == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "booleanValueNotValid.ex.txt"), inputValue));
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        Boolean b = (Boolean)value;
        return b.toString();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object obj = this.coerceValue(input, Locale.US);
        return obj;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public int getSQLType() {
        return 16;
    }

    @Override
    public int getExpressionUsage() {
        return 16;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(baseMacroVariableName, this.getValueAsString(value, Locale.US));
        return map;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        return this.coerceValue(value, inputLocale);
    }
}

