from time import sleep
from pyaudio import PyAudio, paInt16
from struct import pack
from math import pi, sin


class Sound:
    
    __FORMAT = paInt16
    __CHANNELS = 2
    __RATE = 44100

    __p = PyAudio()

    @classmethod
    def __data_for_freq(cls, frequency: float, time: float = None):
        """get frames for a fixed Sound.frequency for a specified time or
        number of frames, if frame_count is specified, the specified
        time is ignored"""
        frame_count = int(cls.__RATE * time)

        wavedata = []

        for i in range(frame_count):
            nframes = cls.__RATE / frequency  # number of frames per wave
            wavepart = i / nframes
            # explanation for b
            # considering one wave, what part of the wave should this be
            # if we graph the sine wave in a
            # displacement vs i graph for the particle
            # where 0 is the beginning of the sine wave and
            # 1 the end of the sine wave
            # which part is "i" is denoted by b
            # for clarity you might use
            # though this is redundant since math.sin is a looping function
            # b = b - int(b)

            sine = wavepart * (2 * pi)
            # explanation for c
            # now we map b to between 0 and 2*math.PI
            # since 0 - 2*PI, 2*PI - 4*PI, ...
            # are the repeating domains of the sin wave (so the decimal values will
            # also be mapped accordingly,
            # and the integral values will be multiplied
            # by 2*PI and since sin(n*2*PI) is zero where n is an integer)
            adj = sin(sine) * 32767
            final = int(adj)
            wavedata.append(final)

        number_of_bytes = str(len(wavedata))
        wavedata = pack(number_of_bytes + 'h', *wavedata)

        return wavedata

    @classmethod
    def freq(cls, frequency: float, time: float):
        """
        play a Sound.frequency for a fixed time!
        """
        frames = cls.__data_for_freq(frequency, time)
        stream = cls.__p.open(format=cls.__FORMAT, channels=cls.__CHANNELS, rate=cls.__RATE, output=True)
        stream.write(frames)
        stream.stop_stream()
        stream.close()


def c(oitava=5, duracao=500):
    Sound.freq(264*pow(2, oitava-4), duracao/1000)


def d(oitava=5, duracao=500):
    Sound.freq(297*pow(2, oitava-4), duracao/1000)


def e(oitava=5, duracao=500):
    Sound.freq(330*pow(2, oitava-4), duracao/1000)


def f(oitava=5, duracao=500):
    Sound.freq(352*pow(2, oitava-4), duracao/1000)


def g(oitava=5, duracao=500):
    Sound.freq(396*pow(2, oitava-4), duracao/1000)


def a(oitava=5, duracao=500):
    Sound.freq(440*pow(2, oitava-4), duracao/1000)


def b(oitava=5, duracao=500):
    Sound.freq(495*pow(2, oitava-4), duracao/1000)


def csh(oitava=5, duracao=500):
    Sound.freq(280*pow(2, oitava-4), duracao/1000)


def dsh(oitava=5, duracao=500):
    Sound.freq(314*pow(2, oitava-4), duracao/1000)


def fsh(oitava=5, duracao=500):
    Sound.freq(373*pow(2, oitava-4), duracao/1000)


def gsh(oitava=5, duracao=500):
    Sound.freq(419*pow(2, oitava-4), duracao/1000)


def ash(oitava=5, duracao=500):
    Sound.freq(470*pow(2, oitava-4), duracao/1000)


dfl = csh
efl = dsh
gfl = fsh
afl = gsh
bfl = ash


def sil(mili=300):
    sleep(mili/1000)


def play(*args):
    for note in args:
        note()
