# Generated by Django 2.2.14 on 2020-08-04 04:05

import django.core.validators
from django.db import migrations, models

def from_tle_to_observation(apps, schema_editor):
    Observation = apps.get_model('base', 'Observation')
    observations = Observation.objects.filter(tle__isnull=False)
    for observation in observations:
        observation.tle_line_0 = observation.tle.tle0
        observation.tle_line_1 = observation.tle.tle1
        observation.tle_line_2 = observation.tle.tle2
        observation.tle_source = observation.tle.tle_source
        observation.tle_updated = observation.tle.updated
        observation.save()

def reverse_from_tle_to_observation(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('base', '0078_fix_waterfall_status'),
    ]

    operations = [
        migrations.AddField(
            model_name='observation',
            name='tle_line_0',
            field=models.CharField(blank=True, max_length=69, validators=[django.core.validators.MinLengthValidator(1), django.core.validators.MaxLengthValidator(69)]),
        ),
        migrations.AddField(
            model_name='observation',
            name='tle_line_1',
            field=models.CharField(blank=True, max_length=69, validators=[django.core.validators.MinLengthValidator(69), django.core.validators.MaxLengthValidator(69)]),
        ),
        migrations.AddField(
            model_name='observation',
            name='tle_line_2',
            field=models.CharField(blank=True, max_length=69, validators=[django.core.validators.MinLengthValidator(69), django.core.validators.MaxLengthValidator(69)]),
        ),
        migrations.AddField(
            model_name='observation',
            name='tle_source',
            field=models.CharField(blank=True, max_length=300),
        ),
        migrations.AddField(
            model_name='observation',
            name='tle_updated',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.RunPython(from_tle_to_observation, reverse_from_tle_to_observation),
    ]
