# Generated by Django 1.11.29 on 2020-04-06 08:37

from django.db import migrations


def migrate_data(apps, schema_editor):
    types = {
        'dipole': 'Dipole',
        'v-dipole': 'V-Dipole',
        'discone': 'Discone',
        'ground': 'Ground Plane',
        'yagi': 'Yagi',
        'cross-yagi': 'Cross Yagi',
        'helical': 'Helical',
        'parabolic': 'Parabolic',
        'vertical': 'Vertical',
        'turnstile': 'Turnstile',
        'quadrafilar': 'Quadrafilar',
        'eggbeater': 'Eggbeater',
        'lindenblad': 'Lindenblad',
        'paralindy': 'Parasitic Lindenblad',
        'patch': 'Patch',
    }
    Station = apps.get_model("base", "Station")
    AntennaType = apps.get_model("base", "AntennaType")
    StationAntenna = apps.get_model("base", "StationAntenna")
    FrequencyRange = apps.get_model("base", "FrequencyRange")
    for station in Station.objects.all():
        for antenna in station.antenna.all():
            station_antenna = StationAntenna()
            station_antenna.antenna_type = AntennaType.objects.get(
                name=types[antenna.antenna_type]
            )
            station_antenna.station = station
            station_antenna.name = types[antenna.antenna_type] + ' - ' + antenna.band
            station_antenna.save()
            freq_range = FrequencyRange()
            freq_range.antenna = station_antenna
            freq_range.min_frequency = antenna.frequency
            freq_range.max_frequency = antenna.frequency_max
            freq_range.save()


def revert_migrate_data(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0065_new_antenna_schema'),
    ]

    operations = [
        migrations.RunPython(migrate_data, revert_migrate_data),
    ]
