# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadbalancerArgs', 'Loadbalancer']

@pulumi.input_type
class LoadbalancerArgs:
    def __init__(__self__, *,
                 ip_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 release_ip: Optional[pulumi.Input[bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Loadbalancer resource.
        :param pulumi.Input[str] ip_id: The ID of the associated LB IP. See below.
        :param pulumi.Input[str] type: The type of the load-balancer. Please check the migration section to upgrade the type
        :param pulumi.Input[str] description: The description of the load-balancer.
        :param pulumi.Input[str] name: The name of the load-balancer.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]] private_networks: List of private network to connect with your load balancer
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the load-balancer is associated with.
        :param pulumi.Input[bool] release_ip: The release_ip allow release the ip address associated with the load-balancers.
        :param pulumi.Input[str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://developers.scaleway.com/en/products/lb/zoned_api/#ssl-compatibility-level-442f99).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the load-balancers.
        :param pulumi.Input[str] zone: `zone`) The zone in which the IP should be reserved.
        """
        pulumi.set(__self__, "ip_id", ip_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if release_ip is not None:
            warnings.warn("""The resource ip will be destroyed by it's own resource. Please set this to `false`""", DeprecationWarning)
            pulumi.log.warn("""release_ip is deprecated: The resource ip will be destroyed by it's own resource. Please set this to `false`""")
        if release_ip is not None:
            pulumi.set(__self__, "release_ip", release_ip)
        if ssl_compatibility_level is not None:
            pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> pulumi.Input[str]:
        """
        The ID of the associated LB IP. See below.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the load-balancer. Please check the migration section to upgrade the type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the load-balancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the load-balancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]]:
        """
        List of private network to connect with your load balancer
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the load-balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="releaseIp")
    def release_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        The release_ip allow release the ip address associated with the load-balancers.
        """
        return pulumi.get(self, "release_ip")

    @release_ip.setter
    def release_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "release_ip", value)

    @property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://developers.scaleway.com/en/products/lb/zoned_api/#ssl-compatibility-level-442f99).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @ssl_compatibility_level.setter
    def ssl_compatibility_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_compatibility_level", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the load-balancers.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the IP should be reserved.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _LoadbalancerState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 release_ip: Optional[pulumi.Input[bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Loadbalancer resources.
        :param pulumi.Input[str] description: The description of the load-balancer.
        :param pulumi.Input[str] ip_address: The load-balance public IP Address
        :param pulumi.Input[str] ip_id: The ID of the associated LB IP. See below.
        :param pulumi.Input[str] name: The name of the load-balancer.
        :param pulumi.Input[str] organization_id: The organization ID the load-balancer is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]] private_networks: List of private network to connect with your load balancer
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the load-balancer is associated with.
        :param pulumi.Input[str] region: The region of the resource
        :param pulumi.Input[bool] release_ip: The release_ip allow release the ip address associated with the load-balancers.
        :param pulumi.Input[str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://developers.scaleway.com/en/products/lb/zoned_api/#ssl-compatibility-level-442f99).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the load-balancers.
        :param pulumi.Input[str] type: The type of the load-balancer. Please check the migration section to upgrade the type
        :param pulumi.Input[str] zone: `zone`) The zone in which the IP should be reserved.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_id is not None:
            pulumi.set(__self__, "ip_id", ip_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if release_ip is not None:
            warnings.warn("""The resource ip will be destroyed by it's own resource. Please set this to `false`""", DeprecationWarning)
            pulumi.log.warn("""release_ip is deprecated: The resource ip will be destroyed by it's own resource. Please set this to `false`""")
        if release_ip is not None:
            pulumi.set(__self__, "release_ip", release_ip)
        if ssl_compatibility_level is not None:
            pulumi.set(__self__, "ssl_compatibility_level", ssl_compatibility_level)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the load-balancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The load-balance public IP Address
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the associated LB IP. See below.
        """
        return pulumi.get(self, "ip_id")

    @ip_id.setter
    def ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the load-balancer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the load-balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]]:
        """
        List of private network to connect with your load balancer
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadbalancerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the load-balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the resource
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="releaseIp")
    def release_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        The release_ip allow release the ip address associated with the load-balancers.
        """
        return pulumi.get(self, "release_ip")

    @release_ip.setter
    def release_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "release_ip", value)

    @property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> Optional[pulumi.Input[str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://developers.scaleway.com/en/products/lb/zoned_api/#ssl-compatibility-level-442f99).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @ssl_compatibility_level.setter
    def ssl_compatibility_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_compatibility_level", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the load-balancers.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the load-balancer. Please check the migration section to upgrade the type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the IP should be reserved.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class Loadbalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadbalancerPrivateNetworkArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 release_ip: Optional[pulumi.Input[bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Load-Balancers.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/lb/zoned_api).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main = scaleway.LoadbalancerIp("main", zone="fr-par-1")
        base = scaleway.Loadbalancer("base",
            ip_id=main.id,
            zone=main.zone,
            type="LB-S")
        ```

        ### IP for Public Gateway
        resource "scaleway_vpc_public_gateway_ip" "main" {
        }

        ### Scaleway Private Network
        resource scaleway_vpc_private_network main {
        }

        ### VPC Public Gateway Network
        resource "scaleway_vpc_public_gateway" "main" {
            name  = "tf-test-public-gw"
            type  = "VPC-GW-S"
            ip_id = scaleway_vpc_public_gateway_ip.main.id
        }

        ### VPC Public Gateway Network DHCP config
        resource "scaleway_vpc_public_gateway_dhcp" "main" {
            subnet = "10.0.0.0/24"
        }

        ### VPC Gateway Network
        resource "scaleway_vpc_gateway_network" "main" {
            gateway_id         = scaleway_vpc_public_gateway.main.id
            private_network_id = scaleway_vpc_private_network.main.id
            dhcp_id            = scaleway_vpc_public_gateway_dhcp.main.id
            cleanup_dhcp       = true
            enable_masquerade  = true
        }

        ### Scaleway Instance
        resource "scaleway_instance_server" "main" {
            name        = "Scaleway Terraform Provider"
            type        = "DEV1-S"
            image       = "debian_bullseye"
            enable_ipv6 = false

            private_network {
                pn_id = scaleway_vpc_private_network.main.id
            }
        }

        ### IP for LB IP
        resource scaleway_lb_ip main {
        }

        ### Scaleway Private Network
        resource scaleway_vpc_private_network "main" {
            name = "private network with static config"
        }

        ## Migration

        In order to migrate to other types you can check the migration up or down via our CLI `scw lb lb-types list`.
        this change will not recreate your Load Balancer.

        Please check our [documentation](https://developers.scaleway.com/en/products/lb/zoned_api/#post-355592) for further details

        ## IP ID

        Since v1.15.0, `ip_id` is a required field. This means that now a separate `LoadbalancerIp` is required.
        When importing, the IP needs to be imported as well as the LB.
        When upgrading to v1.15.0, you will need to create a new `LoadbalancerIp` resource and import it.

        For instance, if you had the following:

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main = scaleway.Loadbalancer("main",
            type="LB-S",
            zone="fr-par-1")
        ```

        You will need to update it to:

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main_loadbalancer_ip = scaleway.LoadbalancerIp("mainLoadbalancerIp")
        main_loadbalancer = scaleway.Loadbalancer("mainLoadbalancer",
            ip_id=main_loadbalancer_ip.id,
            zone="fr-par-1",
            type="LB-S",
            release_ip=False)
        ```

        ## Import

        Load-Balancer can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/loadbalancer:Loadbalancer main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

         Be aware that you will also need to import the `scaleway_lb_ip` resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the load-balancer.
        :param pulumi.Input[str] ip_id: The ID of the associated LB IP. See below.
        :param pulumi.Input[str] name: The name of the load-balancer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadbalancerPrivateNetworkArgs']]]] private_networks: List of private network to connect with your load balancer
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the load-balancer is associated with.
        :param pulumi.Input[bool] release_ip: The release_ip allow release the ip address associated with the load-balancers.
        :param pulumi.Input[str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://developers.scaleway.com/en/products/lb/zoned_api/#ssl-compatibility-level-442f99).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the load-balancers.
        :param pulumi.Input[str] type: The type of the load-balancer. Please check the migration section to upgrade the type
        :param pulumi.Input[str] zone: `zone`) The zone in which the IP should be reserved.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Load-Balancers.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/lb/zoned_api).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main = scaleway.LoadbalancerIp("main", zone="fr-par-1")
        base = scaleway.Loadbalancer("base",
            ip_id=main.id,
            zone=main.zone,
            type="LB-S")
        ```

        ### IP for Public Gateway
        resource "scaleway_vpc_public_gateway_ip" "main" {
        }

        ### Scaleway Private Network
        resource scaleway_vpc_private_network main {
        }

        ### VPC Public Gateway Network
        resource "scaleway_vpc_public_gateway" "main" {
            name  = "tf-test-public-gw"
            type  = "VPC-GW-S"
            ip_id = scaleway_vpc_public_gateway_ip.main.id
        }

        ### VPC Public Gateway Network DHCP config
        resource "scaleway_vpc_public_gateway_dhcp" "main" {
            subnet = "10.0.0.0/24"
        }

        ### VPC Gateway Network
        resource "scaleway_vpc_gateway_network" "main" {
            gateway_id         = scaleway_vpc_public_gateway.main.id
            private_network_id = scaleway_vpc_private_network.main.id
            dhcp_id            = scaleway_vpc_public_gateway_dhcp.main.id
            cleanup_dhcp       = true
            enable_masquerade  = true
        }

        ### Scaleway Instance
        resource "scaleway_instance_server" "main" {
            name        = "Scaleway Terraform Provider"
            type        = "DEV1-S"
            image       = "debian_bullseye"
            enable_ipv6 = false

            private_network {
                pn_id = scaleway_vpc_private_network.main.id
            }
        }

        ### IP for LB IP
        resource scaleway_lb_ip main {
        }

        ### Scaleway Private Network
        resource scaleway_vpc_private_network "main" {
            name = "private network with static config"
        }

        ## Migration

        In order to migrate to other types you can check the migration up or down via our CLI `scw lb lb-types list`.
        this change will not recreate your Load Balancer.

        Please check our [documentation](https://developers.scaleway.com/en/products/lb/zoned_api/#post-355592) for further details

        ## IP ID

        Since v1.15.0, `ip_id` is a required field. This means that now a separate `LoadbalancerIp` is required.
        When importing, the IP needs to be imported as well as the LB.
        When upgrading to v1.15.0, you will need to create a new `LoadbalancerIp` resource and import it.

        For instance, if you had the following:

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main = scaleway.Loadbalancer("main",
            type="LB-S",
            zone="fr-par-1")
        ```

        You will need to update it to:

        ```python
        import pulumi
        import lbrlabs_pulumi_scaleway as scaleway

        main_loadbalancer_ip = scaleway.LoadbalancerIp("mainLoadbalancerIp")
        main_loadbalancer = scaleway.Loadbalancer("mainLoadbalancer",
            ip_id=main_loadbalancer_ip.id,
            zone="fr-par-1",
            type="LB-S",
            release_ip=False)
        ```

        ## Import

        Load-Balancer can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/loadbalancer:Loadbalancer main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

         Be aware that you will also need to import the `scaleway_lb_ip` resource.

        :param str resource_name: The name of the resource.
        :param LoadbalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadbalancerPrivateNetworkArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 release_ip: Optional[pulumi.Input[bool]] = None,
                 ssl_compatibility_level: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerArgs.__new__(LoadbalancerArgs)

            __props__.__dict__["description"] = description
            if ip_id is None and not opts.urn:
                raise TypeError("Missing required property 'ip_id'")
            __props__.__dict__["ip_id"] = ip_id
            __props__.__dict__["name"] = name
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            if release_ip is not None and not opts.urn:
                warnings.warn("""The resource ip will be destroyed by it's own resource. Please set this to `false`""", DeprecationWarning)
                pulumi.log.warn("""release_ip is deprecated: The resource ip will be destroyed by it's own resource. Please set this to `false`""")
            __props__.__dict__["release_ip"] = release_ip
            __props__.__dict__["ssl_compatibility_level"] = ssl_compatibility_level
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["zone"] = zone
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["region"] = None
        super(Loadbalancer, __self__).__init__(
            'scaleway:index/loadbalancer:Loadbalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            ip_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadbalancerPrivateNetworkArgs']]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            release_ip: Optional[pulumi.Input[bool]] = None,
            ssl_compatibility_level: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'Loadbalancer':
        """
        Get an existing Loadbalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the load-balancer.
        :param pulumi.Input[str] ip_address: The load-balance public IP Address
        :param pulumi.Input[str] ip_id: The ID of the associated LB IP. See below.
        :param pulumi.Input[str] name: The name of the load-balancer.
        :param pulumi.Input[str] organization_id: The organization ID the load-balancer is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadbalancerPrivateNetworkArgs']]]] private_networks: List of private network to connect with your load balancer
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the load-balancer is associated with.
        :param pulumi.Input[str] region: The region of the resource
        :param pulumi.Input[bool] release_ip: The release_ip allow release the ip address associated with the load-balancers.
        :param pulumi.Input[str] ssl_compatibility_level: Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://developers.scaleway.com/en/products/lb/zoned_api/#ssl-compatibility-level-442f99).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the load-balancers.
        :param pulumi.Input[str] type: The type of the load-balancer. Please check the migration section to upgrade the type
        :param pulumi.Input[str] zone: `zone`) The zone in which the IP should be reserved.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerState.__new__(_LoadbalancerState)

        __props__.__dict__["description"] = description
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_id"] = ip_id
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["release_ip"] = release_ip
        __props__.__dict__["ssl_compatibility_level"] = ssl_compatibility_level
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["zone"] = zone
        return Loadbalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the load-balancer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The load-balance public IP Address
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> pulumi.Output[str]:
        """
        The ID of the associated LB IP. See below.
        """
        return pulumi.get(self, "ip_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the load-balancer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID the load-balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.LoadbalancerPrivateNetwork']]]:
        """
        List of private network to connect with your load balancer
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the load-balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region of the resource
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="releaseIp")
    def release_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        The release_ip allow release the ip address associated with the load-balancers.
        """
        return pulumi.get(self, "release_ip")

    @property
    @pulumi.getter(name="sslCompatibilityLevel")
    def ssl_compatibility_level(self) -> pulumi.Output[Optional[str]]:
        """
        Enforces minimal SSL version (in SSL/TLS offloading context). Please check [possible values](https://developers.scaleway.com/en/products/lb/zoned_api/#ssl-compatibility-level-442f99).
        """
        return pulumi.get(self, "ssl_compatibility_level")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags associated with the load-balancers.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the load-balancer. Please check the migration section to upgrade the type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        `zone`) The zone in which the IP should be reserved.
        """
        return pulumi.get(self, "zone")

