<!--
Document Author
Yuta Nakahara <yuta.nakahara@aoni.waseda.jp>
Shota Saito <shota.s@gunma-u.ac.jp>
-->
# How to contribute

We appreciate your consideration of contributing to BayesML and your visit to this page.
This page describes how to report bugs, correct and translate the documents, and contribute to the codes.

## History and philosophy of BayesML

First, we would like you to understand the release history and philosophy of BayesML. As described in README.md, the purpose of BayesML is to promote research, education, and application of machine learning based on Bayesian statistics and Bayesian decision theory. Through these activities, BayesML aims to widely contribute to society. BayesML originally attempted to unify the private implementation of code regarding Bayesian machine learning in our laboratory to improve the efficiency of educational activity. However, this attempt may be useful for other researchers, students, and data scientists working for a company. Therefore, we decided to release BayesML.

Because of this history, BayesML places great emphasis on the educational aspect. We hope all users and contributors deepen their understanding of Bayesian statistics and machine learning based on Bayesian decision theory through their interactions with BayesML. We also hope that they apply the deepened knowledge to academia, industry, and other areas of society. All the contributions to BayesML are reviewed under this philosophy. If your contribution is not accepted, it is a difference of opinion and does not negate the value of your contribution.

Also, please read this [code of conduct](./CODE_OF_CONDUCT.md).

## How to report a bug

If you find a bug, please create an issue in the following format.

* Execution environment
  * OS
  * Python and library versions
* Execution content
* Expected results
* Actual results

## How to correct and translate the documents

Regarding minor issues such as typos and grammatical errors, please create an issue in the following format.

* URL
* Incorrect description
* Correct description

If you can cooperate with major revisions or translations, please contact us through the creation of an issue in any format. In particular, because most of the documents for developers are written in Japanese, we welcome anyone who can translate these materials.

## How to contribute to the codes

We are sorry, but we do not accept contributions to the codes from people who are not acquaintances with developers. The main reasons are as follows.

* The implementation format of the variational Bayes algorithm to be implemented in the future is not unified.
* The documents for developers are not prepared.
* The developers are not familiar with the development of an OSS project.

When these issues are resolved, we would be happy to receive your contributions to the codes. In that case, we would like you to understand that it may be necessary to discuss your contribution based on the development philosophy of BayesML.
