"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2021 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class DateTime(google.protobuf.message.Message):
    """Represents civil time (or occasionally physical time).

    This type can represent a civil time in one of a few possible ways:

     * When utc_offset is set and time_zone is unset: a civil time on a calendar
       day with a particular offset from UTC.
     * When time_zone is set and utc_offset is unset: a civil time on a calendar
       day in a particular time zone.
     * When neither time_zone nor utc_offset is set: a civil time on a calendar
       day in local time.

    The date is relative to the Proleptic Gregorian Calendar.

    If year is 0, the DateTime is considered not to have a specific year. month
    and day must have valid, non-zero values.

    This type may also be used to represent a physical time if all the date and
    time fields are set and either case of the `time_offset` oneof is set.
    Consider using `Timestamp` message for physical time instead. If your use
    case also would like to store the user's timezone, that can be done in
    another field.

    This type is more flexible than some applications may want. Make sure to
    document and validate your application's limitations.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    YEAR_FIELD_NUMBER: builtins.int
    MONTH_FIELD_NUMBER: builtins.int
    DAY_FIELD_NUMBER: builtins.int
    HOURS_FIELD_NUMBER: builtins.int
    MINUTES_FIELD_NUMBER: builtins.int
    SECONDS_FIELD_NUMBER: builtins.int
    NANOS_FIELD_NUMBER: builtins.int
    UTC_OFFSET_FIELD_NUMBER: builtins.int
    TIME_ZONE_FIELD_NUMBER: builtins.int
    year: builtins.int
    """Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
    datetime without a year.
    """
    month: builtins.int
    """Required. Month of year. Must be from 1 to 12."""
    day: builtins.int
    """Required. Day of month. Must be from 1 to 31 and valid for the year and
    month.
    """
    hours: builtins.int
    """Required. Hours of day in 24 hour format. Should be from 0 to 23. An API
    may choose to allow the value "24:00:00" for scenarios like business
    closing time.
    """
    minutes: builtins.int
    """Required. Minutes of hour of day. Must be from 0 to 59."""
    seconds: builtins.int
    """Required. Seconds of minutes of the time. Must normally be from 0 to 59. An
    API may allow the value 60 if it allows leap-seconds.
    """
    nanos: builtins.int
    """Required. Fractions of seconds in nanoseconds. Must be from 0 to
    999,999,999.
    """
    @property
    def utc_offset(self) -> google.protobuf.duration_pb2.Duration:
        """UTC offset. Must be whole seconds, between -18 hours and +18 hours.
        For example, a UTC offset of -4:00 would be represented as
        { seconds: -14400 }.
        """
    @property
    def time_zone(self) -> global___TimeZone:
        """Time zone."""
    def __init__(
        self,
        *,
        year: builtins.int = ...,
        month: builtins.int = ...,
        day: builtins.int = ...,
        hours: builtins.int = ...,
        minutes: builtins.int = ...,
        seconds: builtins.int = ...,
        nanos: builtins.int = ...,
        utc_offset: google.protobuf.duration_pb2.Duration | None = ...,
        time_zone: global___TimeZone | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "time_offset",
            b"time_offset",
            "time_zone",
            b"time_zone",
            "utc_offset",
            b"utc_offset",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "day",
            b"day",
            "hours",
            b"hours",
            "minutes",
            b"minutes",
            "month",
            b"month",
            "nanos",
            b"nanos",
            "seconds",
            b"seconds",
            "time_offset",
            b"time_offset",
            "time_zone",
            b"time_zone",
            "utc_offset",
            b"utc_offset",
            "year",
            b"year",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["time_offset", b"time_offset"]
    ) -> typing_extensions.Literal["utc_offset", "time_zone"] | None: ...

global___DateTime = DateTime

@typing_extensions.final
class TimeZone(google.protobuf.message.Message):
    """Represents a time zone from the
    [IANA Time Zone Database](https://www.iana.org/time-zones).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """IANA Time Zone Database time zone, e.g. "America/New_York"."""
    version: builtins.str
    """Optional. IANA Time Zone Database version number, e.g. "2019a"."""
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["id", b"id", "version", b"version"]
    ) -> None: ...

global___TimeZone = TimeZone
