"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2021 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Date(google.protobuf.message.Message):
    """Represents a whole or partial calendar date, such as a birthday. The time of
    day and time zone are either specified elsewhere or are insignificant. The
    date is relative to the Gregorian Calendar. This can represent one of the
    following:

    * A full date, with non-zero year, month, and day values
    * A month and day value, with a zero year, such as an anniversary
    * A year on its own, with zero month and day values
    * A year and month value, with a zero day, such as a credit card expiration
    date

    Related types are [google.type.TimeOfDay][google.type.TimeOfDay] and
    `google.protobuf.Timestamp`.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    YEAR_FIELD_NUMBER: builtins.int
    MONTH_FIELD_NUMBER: builtins.int
    DAY_FIELD_NUMBER: builtins.int
    year: builtins.int
    """Year of the date. Must be from 1 to 9999, or 0 to specify a date without
    a year.
    """
    month: builtins.int
    """Month of a year. Must be from 1 to 12, or 0 to specify a year without a
    month and day.
    """
    day: builtins.int
    """Day of a month. Must be from 1 to 31 and valid for the year and month, or 0
    to specify a year by itself or a year and month where the day isn't
    significant.
    """
    def __init__(
        self,
        *,
        year: builtins.int = ...,
        month: builtins.int = ...,
        day: builtins.int = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "day", b"day", "month", b"month", "year", b"year"
        ],
    ) -> None: ...

global___Date = Date
