"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2021 Google LLC.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

This file contains custom annotations that are used by GAPIC generators to
handle Long Running Operation methods (LRO) that are NOT compliant with
https://google.aip.dev/151. These annotations are public for technical
reasons only. Please DO NOT USE them in your protos.
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.descriptor_pb2
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.internal.extension_dict
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _OperationResponseMapping:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _OperationResponseMappingEnumTypeWrapper(
    google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
        _OperationResponseMapping.ValueType
    ],
    builtins.type,
):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNDEFINED: _OperationResponseMapping.ValueType  # 0
    """Do not use."""
    NAME: _OperationResponseMapping.ValueType  # 1
    """A field in an API-specific (custom) Operation object which carries the same
    meaning as google.longrunning.Operation.name.
    """
    STATUS: _OperationResponseMapping.ValueType  # 2
    """A field in an API-specific (custom) Operation object which carries the same
    meaning as google.longrunning.Operation.done. If the annotated field is of
    an enum type, `annotated_field_name == EnumType.DONE` semantics should be
    equivalent to `Operation.done == true`. If the annotated field is of type
    boolean, then it should follow the same semantics as Operation.done.
    Otherwise, a non-empty value should be treated as `Operation.done == true`.
    """
    ERROR_CODE: _OperationResponseMapping.ValueType  # 3
    """A field in an API-specific (custom) Operation object which carries the same
    meaning as google.longrunning.Operation.error.code.
    """
    ERROR_MESSAGE: _OperationResponseMapping.ValueType  # 4
    """A field in an API-specific (custom) Operation object which carries the same
    meaning as google.longrunning.Operation.error.message.
    """

class OperationResponseMapping(
    _OperationResponseMapping, metaclass=_OperationResponseMappingEnumTypeWrapper
):
    """An enum to be used to mark the essential (for polling) fields in an
    API-specific Operation object. A custom Operation object may contain many
    different fields, but only few of them are essential to conduct a successful
    polling process.
    """

UNDEFINED: OperationResponseMapping.ValueType  # 0
"""Do not use."""
NAME: OperationResponseMapping.ValueType  # 1
"""A field in an API-specific (custom) Operation object which carries the same
meaning as google.longrunning.Operation.name.
"""
STATUS: OperationResponseMapping.ValueType  # 2
"""A field in an API-specific (custom) Operation object which carries the same
meaning as google.longrunning.Operation.done. If the annotated field is of
an enum type, `annotated_field_name == EnumType.DONE` semantics should be
equivalent to `Operation.done == true`. If the annotated field is of type
boolean, then it should follow the same semantics as Operation.done.
Otherwise, a non-empty value should be treated as `Operation.done == true`.
"""
ERROR_CODE: OperationResponseMapping.ValueType  # 3
"""A field in an API-specific (custom) Operation object which carries the same
meaning as google.longrunning.Operation.error.code.
"""
ERROR_MESSAGE: OperationResponseMapping.ValueType  # 4
"""A field in an API-specific (custom) Operation object which carries the same
meaning as google.longrunning.Operation.error.message.
"""
global___OperationResponseMapping = OperationResponseMapping

OPERATION_FIELD_FIELD_NUMBER: builtins.int
OPERATION_REQUEST_FIELD_FIELD_NUMBER: builtins.int
OPERATION_RESPONSE_FIELD_FIELD_NUMBER: builtins.int
OPERATION_SERVICE_FIELD_NUMBER: builtins.int
OPERATION_POLLING_METHOD_FIELD_NUMBER: builtins.int
operation_field: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.FieldOptions,
    global___OperationResponseMapping.ValueType,
]
"""A field annotation that maps fields in an API-specific Operation object to
their standard counterparts in google.longrunning.Operation. See
OperationResponseMapping enum definition.
"""
operation_request_field: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.FieldOptions, builtins.str
]
"""A field annotation that maps fields in the initial request message
(the one which started the LRO) to their counterparts in the polling
request message. For non-standard LRO, the polling response may be missing
some of the information needed to make a subsequent polling request. The
missing information (for example, project or region ID) is contained in the
fields of the initial request message that this annotation must be applied
to. The string value of the annotation corresponds to the name of the
counterpart field in the polling request message that the annotated field's
value will be copied to.
"""
operation_response_field: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.FieldOptions, builtins.str
]
"""A field annotation that maps fields in the polling request message to their
counterparts in the initial and/or polling response message. The initial
and the polling methods return an API-specific Operation object. Some of
the fields from that response object must be reused in the subsequent
request (like operation name/ID) to fully identify the polled operation.
This annotation must be applied to the fields in the polling request
message, the string value of the annotation must correspond to the name of
the counterpart field in the Operation response object whose value will be
copied to the annotated field.
"""
operation_service: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.MethodOptions, builtins.str
]
"""A method annotation that maps an LRO method (the one which starts an LRO)
to the service, which will be used to poll for the operation status. The
annotation must be applied to the method which starts an LRO, the string
value of the annotation must correspond to the name of the service used to
poll for the operation status.
"""
operation_polling_method: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.MethodOptions, builtins.bool
]
"""A method annotation that marks methods that can be used for polling
operation status (e.g. the MyPollingService.Get(MyPollingRequest) method).
"""
