"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2018 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.descriptor_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.internal.extension_dict
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class ResourceDescriptor(google.protobuf.message.Message):
    """A simple descriptor of a resource type.

    ResourceDescriptor annotates a resource message (either by means of a
    protobuf annotation or use in the service config), and associates the
    resource's schema, the resource type, and the pattern of the resource name.

    Example:

        message Topic {
          // Indicates this message defines a resource schema.
          // Declares the resource type in the format of {service}/{kind}.
          // For Kubernetes resources, the format is {api group}/{kind}.
          option (google.api.resource) = {
            type: "pubsub.googleapis.com/Topic"
            pattern: "projects/{project}/topics/{topic}"
          };
        }

    The ResourceDescriptor Yaml config will look like:

        resources:
        - type: "pubsub.googleapis.com/Topic"
          pattern: "projects/{project}/topics/{topic}"

    Sometimes, resources have multiple patterns, typically because they can
    live under multiple parents.

    Example:

        message LogEntry {
          option (google.api.resource) = {
            type: "logging.googleapis.com/LogEntry"
            pattern: "projects/{project}/logs/{log}"
            pattern: "folders/{folder}/logs/{log}"
            pattern: "organizations/{organization}/logs/{log}"
            pattern: "billingAccounts/{billing_account}/logs/{log}"
          };
        }

    The ResourceDescriptor Yaml config will look like:

        resources:
        - type: 'logging.googleapis.com/LogEntry'
          pattern: "projects/{project}/logs/{log}"
          pattern: "folders/{folder}/logs/{log}"
          pattern: "organizations/{organization}/logs/{log}"
          pattern: "billingAccounts/{billing_account}/logs/{log}"
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _History:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _HistoryEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            ResourceDescriptor._History.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        HISTORY_UNSPECIFIED: ResourceDescriptor._History.ValueType  # 0
        """The "unset" value."""
        ORIGINALLY_SINGLE_PATTERN: ResourceDescriptor._History.ValueType  # 1
        """The resource originally had one pattern and launched as such, and
        additional patterns were added later.
        """
        FUTURE_MULTI_PATTERN: ResourceDescriptor._History.ValueType  # 2
        """The resource has one pattern, but the API owner expects to add more
        later. (This is the inverse of ORIGINALLY_SINGLE_PATTERN, and prevents
        that from being necessary once there are multiple patterns.)
        """

    class History(_History, metaclass=_HistoryEnumTypeWrapper):
        """A description of the historical or future-looking state of the
        resource pattern.
        """

    HISTORY_UNSPECIFIED: ResourceDescriptor.History.ValueType  # 0
    """The "unset" value."""
    ORIGINALLY_SINGLE_PATTERN: ResourceDescriptor.History.ValueType  # 1
    """The resource originally had one pattern and launched as such, and
    additional patterns were added later.
    """
    FUTURE_MULTI_PATTERN: ResourceDescriptor.History.ValueType  # 2
    """The resource has one pattern, but the API owner expects to add more
    later. (This is the inverse of ORIGINALLY_SINGLE_PATTERN, and prevents
    that from being necessary once there are multiple patterns.)
    """

    class _Style:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StyleEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            ResourceDescriptor._Style.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        STYLE_UNSPECIFIED: ResourceDescriptor._Style.ValueType  # 0
        """The unspecified value. Do not use."""
        DECLARATIVE_FRIENDLY: ResourceDescriptor._Style.ValueType  # 1
        """This resource is intended to be "declarative-friendly".

        Declarative-friendly resources must be more strictly consistent, and
        setting this to true communicates to tools that this resource should
        adhere to declarative-friendly expectations.

        Note: This is used by the API linter (linter.aip.dev) to enable
        additional checks.
        """

    class Style(_Style, metaclass=_StyleEnumTypeWrapper):
        """A flag representing a specific style that a resource claims to conform to."""

    STYLE_UNSPECIFIED: ResourceDescriptor.Style.ValueType  # 0
    """The unspecified value. Do not use."""
    DECLARATIVE_FRIENDLY: ResourceDescriptor.Style.ValueType  # 1
    """This resource is intended to be "declarative-friendly".

    Declarative-friendly resources must be more strictly consistent, and
    setting this to true communicates to tools that this resource should
    adhere to declarative-friendly expectations.

    Note: This is used by the API linter (linter.aip.dev) to enable
    additional checks.
    """

    TYPE_FIELD_NUMBER: builtins.int
    PATTERN_FIELD_NUMBER: builtins.int
    NAME_FIELD_FIELD_NUMBER: builtins.int
    HISTORY_FIELD_NUMBER: builtins.int
    PLURAL_FIELD_NUMBER: builtins.int
    SINGULAR_FIELD_NUMBER: builtins.int
    STYLE_FIELD_NUMBER: builtins.int
    type: builtins.str
    """The resource type. It must be in the format of
    {service_name}/{resource_type_kind}. The `resource_type_kind` must be
    singular and must not include version numbers.

    Example: `storage.googleapis.com/Bucket`

    The value of the resource_type_kind must follow the regular expression
    /[A-Za-z][a-zA-Z0-9]+/. It should start with an upper case character and
    should use PascalCase (UpperCamelCase). The maximum number of
    characters allowed for the `resource_type_kind` is 100.
    """
    @property
    def pattern(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. The relative resource name pattern associated with this resource
        type. The DNS prefix of the full resource name shouldn't be specified here.

        The path pattern must follow the syntax, which aligns with HTTP binding
        syntax:

            Template = Segment { "/" Segment } ;
            Segment = LITERAL | Variable ;
            Variable = "{" LITERAL "}" ;

        Examples:

            - "projects/{project}/topics/{topic}"
            - "projects/{project}/knowledgeBases/{knowledge_base}"

        The components in braces correspond to the IDs for each resource in the
        hierarchy. It is expected that, if multiple patterns are provided,
        the same component name (e.g. "project") refers to IDs of the same
        type of resource.
        """
    name_field: builtins.str
    """Optional. The field on the resource that designates the resource name
    field. If omitted, this is assumed to be "name".
    """
    history: global___ResourceDescriptor.History.ValueType
    """Optional. The historical or future-looking state of the resource pattern.

    Example:

        // The InspectTemplate message originally only supported resource
        // names with organization, and project was added later.
        message InspectTemplate {
          option (google.api.resource) = {
            type: "dlp.googleapis.com/InspectTemplate"
            pattern:
            "organizations/{organization}/inspectTemplates/{inspect_template}"
            pattern: "projects/{project}/inspectTemplates/{inspect_template}"
            history: ORIGINALLY_SINGLE_PATTERN
          };
        }
    """
    plural: builtins.str
    """The plural name used in the resource name and permission names, such as
    'projects' for the resource name of 'projects/{project}' and the permission
    name of 'cloudresourcemanager.googleapis.com/projects.get'. It is the same
    concept of the `plural` field in k8s CRD spec
    https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/

    Note: The plural form is required even for singleton resources. See
    https://aip.dev/156
    """
    singular: builtins.str
    """The same concept of the `singular` field in k8s CRD spec
    https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions/
    Such as "project" for the `resourcemanager.googleapis.com/Project` type.
    """
    @property
    def style(
        self,
    ) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[
        global___ResourceDescriptor.Style.ValueType
    ]:
        """Style flag(s) for this resource.
        These indicate that a resource is expected to conform to a given
        style. See the specific style flags for additional information.
        """
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        pattern: collections.abc.Iterable[builtins.str] | None = ...,
        name_field: builtins.str = ...,
        history: global___ResourceDescriptor.History.ValueType = ...,
        plural: builtins.str = ...,
        singular: builtins.str = ...,
        style: collections.abc.Iterable[global___ResourceDescriptor.Style.ValueType]
        | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "history",
            b"history",
            "name_field",
            b"name_field",
            "pattern",
            b"pattern",
            "plural",
            b"plural",
            "singular",
            b"singular",
            "style",
            b"style",
            "type",
            b"type",
        ],
    ) -> None: ...

global___ResourceDescriptor = ResourceDescriptor

@typing_extensions.final
class ResourceReference(google.protobuf.message.Message):
    """Defines a proto annotation that describes a string field that refers to
    an API resource.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    CHILD_TYPE_FIELD_NUMBER: builtins.int
    type: builtins.str
    """The resource type that the annotated field references.

    Example:

        message Subscription {
          string topic = 2 [(google.api.resource_reference) = {
            type: "pubsub.googleapis.com/Topic"
          }];
        }

    Occasionally, a field may reference an arbitrary resource. In this case,
    APIs use the special value * in their resource reference.

    Example:

        message GetIamPolicyRequest {
          string resource = 2 [(google.api.resource_reference) = {
            type: "*"
          }];
        }
    """
    child_type: builtins.str
    """The resource type of a child collection that the annotated field
    references. This is useful for annotating the `parent` field that
    doesn't have a fixed resource type.

    Example:

        message ListLogEntriesRequest {
          string parent = 1 [(google.api.resource_reference) = {
            child_type: "logging.googleapis.com/LogEntry"
          };
        }
    """
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        child_type: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "child_type", b"child_type", "type", b"type"
        ],
    ) -> None: ...

global___ResourceReference = ResourceReference

RESOURCE_REFERENCE_FIELD_NUMBER: builtins.int
RESOURCE_DEFINITION_FIELD_NUMBER: builtins.int
RESOURCE_FIELD_NUMBER: builtins.int
resource_reference: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.FieldOptions, global___ResourceReference
]
"""An annotation that describes a resource reference, see
[ResourceReference][].
"""
resource_definition: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.FileOptions,
    google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___ResourceDescriptor
    ],
]
"""An annotation that describes a resource definition without a corresponding
message; see [ResourceDescriptor][].
"""
resource: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[
    google.protobuf.descriptor_pb2.MessageOptions, global___ResourceDescriptor
]
"""An annotation that describes a resource definition, see
[ResourceDescriptor][].
"""
