"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Quota(google.protobuf.message.Message):
    """Quota configuration helps to achieve fairness and budgeting in service
    usage.

    The metric based quota configuration works this way:
    - The service configuration defines a set of metrics.
    - For API calls, the quota.metric_rules maps methods to metrics with
      corresponding costs.
    - The quota.limits defines limits on the metrics, which will be used for
      quota checks at runtime.

    An example quota configuration in yaml format:

       quota:
         limits:

         - name: apiWriteQpsPerProject
           metric: library.googleapis.com/write_calls
           unit: "1/min/{project}"  # rate limit for consumer projects
           values:
             STANDARD: 10000


         # The metric rules bind all methods to the read_calls metric,
         # except for the UpdateBook and DeleteBook methods. These two methods
         # are mapped to the write_calls metric, with the UpdateBook method
         # consuming at twice rate as the DeleteBook method.
         metric_rules:
         - selector: "*"
           metric_costs:
             library.googleapis.com/read_calls: 1
         - selector: google.example.library.v1.LibraryService.UpdateBook
           metric_costs:
             library.googleapis.com/write_calls: 2
         - selector: google.example.library.v1.LibraryService.DeleteBook
           metric_costs:
             library.googleapis.com/write_calls: 1

     Corresponding Metric definition:

         metrics:
         - name: library.googleapis.com/read_calls
           display_name: Read requests
           metric_kind: DELTA
           value_type: INT64

         - name: library.googleapis.com/write_calls
           display_name: Write requests
           metric_kind: DELTA
           value_type: INT64
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LIMITS_FIELD_NUMBER: builtins.int
    METRIC_RULES_FIELD_NUMBER: builtins.int
    @property
    def limits(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___QuotaLimit
    ]:
        """List of `QuotaLimit` definitions for the service."""
    @property
    def metric_rules(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___MetricRule
    ]:
        """List of `MetricRule` definitions, each one mapping a selected method to one
        or more metrics.
        """
    def __init__(
        self,
        *,
        limits: collections.abc.Iterable[global___QuotaLimit] | None = ...,
        metric_rules: collections.abc.Iterable[global___MetricRule] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "limits", b"limits", "metric_rules", b"metric_rules"
        ],
    ) -> None: ...

global___Quota = Quota

@typing_extensions.final
class MetricRule(google.protobuf.message.Message):
    """Bind API methods to metrics. Binding a method to a metric causes that
    metric's configured quota behaviors to apply to the method call.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    @typing_extensions.final
    class MetricCostsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...
    SELECTOR_FIELD_NUMBER: builtins.int
    METRIC_COSTS_FIELD_NUMBER: builtins.int
    selector: builtins.str
    """Selects the methods to which this rule applies.

    Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
    """
    @property
    def metric_costs(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]:
        """Metrics to update when the selected methods are called, and the associated
        cost applied to each metric.

        The key of the map is the metric name, and the values are the amount
        increased for the metric against which the quota limits are defined.
        The value must not be negative.
        """
    def __init__(
        self,
        *,
        selector: builtins.str = ...,
        metric_costs: collections.abc.Mapping[builtins.str, builtins.int] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "metric_costs", b"metric_costs", "selector", b"selector"
        ],
    ) -> None: ...

global___MetricRule = MetricRule

@typing_extensions.final
class QuotaLimit(google.protobuf.message.Message):
    """`QuotaLimit` defines a specific limit that applies over a specified duration
    for a limit type. There can be at most one limit for a duration and limit
    type combination defined within a `QuotaGroup`.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    @typing_extensions.final
    class ValuesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.int
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.int = ...,
        ) -> None: ...
        def ClearField(
            self,
            field_name: typing_extensions.Literal["key", b"key", "value", b"value"],
        ) -> None: ...
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    DEFAULT_LIMIT_FIELD_NUMBER: builtins.int
    MAX_LIMIT_FIELD_NUMBER: builtins.int
    FREE_TIER_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    METRIC_FIELD_NUMBER: builtins.int
    UNIT_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of the quota limit.

    The name must be provided, and it must be unique within the service. The
    name can only include alphanumeric characters as well as '-'.

    The maximum length of the limit name is 64 characters.
    """
    description: builtins.str
    """Optional. User-visible, extended description for this quota limit.
    Should be used only when more context is needed to understand this limit
    than provided by the limit's display name (see: `display_name`).
    """
    default_limit: builtins.int
    """Default number of tokens that can be consumed during the specified
    duration. This is the number of tokens assigned when a client
    application developer activates the service for his/her project.

    Specifying a value of 0 will block all requests. This can be used if you
    are provisioning quota to selected consumers and blocking others.
    Similarly, a value of -1 will indicate an unlimited quota. No other
    negative values are allowed.

    Used by group-based quotas only.
    """
    max_limit: builtins.int
    """Maximum number of tokens that can be consumed during the specified
    duration. Client application developers can override the default limit up
    to this maximum. If specified, this value cannot be set to a value less
    than the default limit. If not specified, it is set to the default limit.

    To allow clients to apply overrides with no upper bound, set this to -1,
    indicating unlimited maximum quota.

    Used by group-based quotas only.
    """
    free_tier: builtins.int
    """Free tier value displayed in the Developers Console for this limit.
    The free tier is the number of tokens that will be subtracted from the
    billed amount when billing is enabled.
    This field can only be set on a limit with duration "1d", in a billable
    group; it is invalid on any other limit. If this field is not set, it
    defaults to 0, indicating that there is no free tier for this service.

    Used by group-based quotas only.
    """
    duration: builtins.str
    """Duration of this limit in textual notation. Must be "100s" or "1d".

    Used by group-based quotas only.
    """
    metric: builtins.str
    """The name of the metric this quota limit applies to. The quota limits with
    the same metric will be checked together during runtime. The metric must be
    defined within the service config.
    """
    unit: builtins.str
    """Specify the unit of the quota limit. It uses the same syntax as
    [Metric.unit][]. The supported unit kinds are determined by the quota
    backend system.

    Here are some examples:
    * "1/min/{project}" for quota per minute per project.

    Note: the order of unit components is insignificant.
    The "1" at the beginning is required to follow the metric unit syntax.
    """
    @property
    def values(
        self,
    ) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.int]:
        """Tiered limit values. You must specify this as a key:value pair, with an
        integer value that is the maximum number of requests allowed for the
        specified unit. Currently only STANDARD is supported.
        """
    display_name: builtins.str
    """User-visible display name for this limit.
    Optional. If not set, the UI will provide a default display name based on
    the quota configuration. This field can be used to override the default
    display name generated from the configuration.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str = ...,
        default_limit: builtins.int = ...,
        max_limit: builtins.int = ...,
        free_tier: builtins.int = ...,
        duration: builtins.str = ...,
        metric: builtins.str = ...,
        unit: builtins.str = ...,
        values: collections.abc.Mapping[builtins.str, builtins.int] | None = ...,
        display_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "default_limit",
            b"default_limit",
            "description",
            b"description",
            "display_name",
            b"display_name",
            "duration",
            b"duration",
            "free_tier",
            b"free_tier",
            "max_limit",
            b"max_limit",
            "metric",
            b"metric",
            "name",
            b"name",
            "unit",
            b"unit",
            "values",
            b"values",
        ],
    ) -> None: ...

global___QuotaLimit = QuotaLimit
