"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Backend(google.protobuf.message.Message):
    """`Backend` defines the backend configuration for a service."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    @property
    def rules(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___BackendRule
    ]:
        """A list of API backend rules that apply to individual API methods.

        **NOTE:** All service configuration rules follow "last one wins" order.
        """
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___BackendRule] | None = ...,
    ) -> None: ...
    def ClearField(
        self, field_name: typing_extensions.Literal["rules", b"rules"]
    ) -> None: ...

global___Backend = Backend

@typing_extensions.final
class BackendRule(google.protobuf.message.Message):
    """A backend rule provides configuration for an individual API element."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _PathTranslation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PathTranslationEnumTypeWrapper(
        google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[
            BackendRule._PathTranslation.ValueType
        ],
        builtins.type,
    ):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PATH_TRANSLATION_UNSPECIFIED: BackendRule._PathTranslation.ValueType  # 0
        CONSTANT_ADDRESS: BackendRule._PathTranslation.ValueType  # 1
        """Use the backend address as-is, with no modification to the path. If the
        URL pattern contains variables, the variable names and values will be
        appended to the query string. If a query string parameter and a URL
        pattern variable have the same name, this may result in duplicate keys in
        the query string.

        # Examples

        Given the following operation config:

            Method path:        /api/company/{cid}/user/{uid}
            Backend address:    https://example.cloudfunctions.net/getUser

        Requests to the following request paths will call the backend at the
        translated path:

            Request path: /api/company/widgetworks/user/johndoe
            Translated:
            https://example.cloudfunctions.net/getUser?cid=widgetworks&uid=johndoe

            Request path: /api/company/widgetworks/user/johndoe?timezone=EST
            Translated:
            https://example.cloudfunctions.net/getUser?timezone=EST&cid=widgetworks&uid=johndoe
        """
        APPEND_PATH_TO_ADDRESS: BackendRule._PathTranslation.ValueType  # 2
        """The request path will be appended to the backend address.

        # Examples

        Given the following operation config:

            Method path:        /api/company/{cid}/user/{uid}
            Backend address:    https://example.appspot.com

        Requests to the following request paths will call the backend at the
        translated path:

            Request path: /api/company/widgetworks/user/johndoe
            Translated:
            https://example.appspot.com/api/company/widgetworks/user/johndoe

            Request path: /api/company/widgetworks/user/johndoe?timezone=EST
            Translated:
            https://example.appspot.com/api/company/widgetworks/user/johndoe?timezone=EST
        """

    class PathTranslation(_PathTranslation, metaclass=_PathTranslationEnumTypeWrapper):
        """Path Translation specifies how to combine the backend address with the
        request path in order to produce the appropriate forwarding URL for the
        request.

        Path Translation is applicable only to HTTP-based backends. Backends which
        do not accept requests over HTTP/HTTPS should leave `path_translation`
        unspecified.
        """

    PATH_TRANSLATION_UNSPECIFIED: BackendRule.PathTranslation.ValueType  # 0
    CONSTANT_ADDRESS: BackendRule.PathTranslation.ValueType  # 1
    """Use the backend address as-is, with no modification to the path. If the
    URL pattern contains variables, the variable names and values will be
    appended to the query string. If a query string parameter and a URL
    pattern variable have the same name, this may result in duplicate keys in
    the query string.

    # Examples

    Given the following operation config:

        Method path:        /api/company/{cid}/user/{uid}
        Backend address:    https://example.cloudfunctions.net/getUser

    Requests to the following request paths will call the backend at the
    translated path:

        Request path: /api/company/widgetworks/user/johndoe
        Translated:
        https://example.cloudfunctions.net/getUser?cid=widgetworks&uid=johndoe

        Request path: /api/company/widgetworks/user/johndoe?timezone=EST
        Translated:
        https://example.cloudfunctions.net/getUser?timezone=EST&cid=widgetworks&uid=johndoe
    """
    APPEND_PATH_TO_ADDRESS: BackendRule.PathTranslation.ValueType  # 2
    """The request path will be appended to the backend address.

    # Examples

    Given the following operation config:

        Method path:        /api/company/{cid}/user/{uid}
        Backend address:    https://example.appspot.com

    Requests to the following request paths will call the backend at the
    translated path:

        Request path: /api/company/widgetworks/user/johndoe
        Translated:
        https://example.appspot.com/api/company/widgetworks/user/johndoe

        Request path: /api/company/widgetworks/user/johndoe?timezone=EST
        Translated:
        https://example.appspot.com/api/company/widgetworks/user/johndoe?timezone=EST
    """

    SELECTOR_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    DEADLINE_FIELD_NUMBER: builtins.int
    MIN_DEADLINE_FIELD_NUMBER: builtins.int
    OPERATION_DEADLINE_FIELD_NUMBER: builtins.int
    PATH_TRANSLATION_FIELD_NUMBER: builtins.int
    JWT_AUDIENCE_FIELD_NUMBER: builtins.int
    DISABLE_AUTH_FIELD_NUMBER: builtins.int
    PROTOCOL_FIELD_NUMBER: builtins.int
    selector: builtins.str
    """Selects the methods to which this rule applies.

    Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
    """
    address: builtins.str
    """The address of the API backend.

    The scheme is used to determine the backend protocol and security.
    The following schemes are accepted:

       SCHEME        PROTOCOL    SECURITY
       http://       HTTP        None
       https://      HTTP        TLS
       grpc://       gRPC        None
       grpcs://      gRPC        TLS

    It is recommended to explicitly include a scheme. Leaving out the scheme
    may cause constrasting behaviors across platforms.

    If the port is unspecified, the default is:
    - 80 for schemes without TLS
    - 443 for schemes with TLS

    For HTTP backends, use [protocol][google.api.BackendRule.protocol]
    to specify the protocol version.
    """
    deadline: builtins.float
    """The number of seconds to wait for a response from a request. The default
    varies based on the request protocol and deployment environment.
    """
    min_deadline: builtins.float
    """Minimum deadline in seconds needed for this method. Calls having deadline
    value lower than this will be rejected.
    """
    operation_deadline: builtins.float
    """The number of seconds to wait for the completion of a long running
    operation. The default is no deadline.
    """
    path_translation: global___BackendRule.PathTranslation.ValueType
    jwt_audience: builtins.str
    """The JWT audience is used when generating a JWT ID token for the backend.
    This ID token will be added in the HTTP "authorization" header, and sent
    to the backend.
    """
    disable_auth: builtins.bool
    """When disable_auth is true, a JWT ID token won't be generated and the
    original "Authorization" HTTP header will be preserved. If the header is
    used to carry the original token and is expected by the backend, this
    field must be set to true to preserve the header.
    """
    protocol: builtins.str
    """The protocol used for sending a request to the backend.
    The supported values are "http/1.1" and "h2".

    The default value is inferred from the scheme in the
    [address][google.api.BackendRule.address] field:

       SCHEME        PROTOCOL
       http://       http/1.1
       https://      http/1.1
       grpc://       h2
       grpcs://      h2

    For secure HTTP backends (https://) that support HTTP/2, set this field
    to "h2" for improved performance.

    Configuring this field to non-default values is only supported for secure
    HTTP backends. This field will be ignored for all other backends.

    See
    https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
    for more details on the supported values.
    """
    def __init__(
        self,
        *,
        selector: builtins.str = ...,
        address: builtins.str = ...,
        deadline: builtins.float = ...,
        min_deadline: builtins.float = ...,
        operation_deadline: builtins.float = ...,
        path_translation: global___BackendRule.PathTranslation.ValueType = ...,
        jwt_audience: builtins.str = ...,
        disable_auth: builtins.bool = ...,
        protocol: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "authentication",
            b"authentication",
            "disable_auth",
            b"disable_auth",
            "jwt_audience",
            b"jwt_audience",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "address",
            b"address",
            "authentication",
            b"authentication",
            "deadline",
            b"deadline",
            "disable_auth",
            b"disable_auth",
            "jwt_audience",
            b"jwt_audience",
            "min_deadline",
            b"min_deadline",
            "operation_deadline",
            b"operation_deadline",
            "path_translation",
            b"path_translation",
            "protocol",
            b"protocol",
            "selector",
            b"selector",
        ],
    ) -> None: ...
    def WhichOneof(
        self,
        oneof_group: typing_extensions.Literal["authentication", b"authentication"],
    ) -> typing_extensions.Literal["jwt_audience", "disable_auth"] | None: ...

global___BackendRule = BackendRule
