"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2015 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Authentication(google.protobuf.message.Message):
    """`Authentication` defines the authentication configuration for API methods
    provided by an API service.

    Example:

        name: calendar.googleapis.com
        authentication:
          providers:
          - id: google_calendar_auth
            jwks_uri: https://www.googleapis.com/oauth2/v1/certs
            issuer: https://securetoken.google.com
          rules:
          - selector: "*"
            requirements:
              provider_id: google_calendar_auth
          - selector: google.calendar.Delegate
            oauth:
              canonical_scopes: https://www.googleapis.com/auth/calendar.read
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    PROVIDERS_FIELD_NUMBER: builtins.int
    @property
    def rules(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___AuthenticationRule
    ]:
        """A list of authentication rules that apply to individual API methods.

        **NOTE:** All service configuration rules follow "last one wins" order.
        """
    @property
    def providers(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___AuthProvider
    ]:
        """Defines a set of authentication providers that a service supports."""
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[global___AuthenticationRule] | None = ...,
        providers: collections.abc.Iterable[global___AuthProvider] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "providers", b"providers", "rules", b"rules"
        ],
    ) -> None: ...

global___Authentication = Authentication

@typing_extensions.final
class AuthenticationRule(google.protobuf.message.Message):
    """Authentication rules for the service.

    By default, if a method has any authentication requirements, every request
    must include a valid credential matching one of the requirements.
    It's an error to include more than one kind of credential in a single
    request.

    If a method doesn't have any auth requirements, request credentials will be
    ignored.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SELECTOR_FIELD_NUMBER: builtins.int
    OAUTH_FIELD_NUMBER: builtins.int
    ALLOW_WITHOUT_CREDENTIAL_FIELD_NUMBER: builtins.int
    REQUIREMENTS_FIELD_NUMBER: builtins.int
    selector: builtins.str
    """Selects the methods to which this rule applies.

    Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
    """
    @property
    def oauth(self) -> global___OAuthRequirements:
        """The requirements for OAuth credentials."""
    allow_without_credential: builtins.bool
    """If true, the service accepts API keys without any other credential.
    This flag only applies to HTTP and gRPC requests.
    """
    @property
    def requirements(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___AuthRequirement
    ]:
        """Requirements for additional authentication providers."""
    def __init__(
        self,
        *,
        selector: builtins.str = ...,
        oauth: global___OAuthRequirements | None = ...,
        allow_without_credential: builtins.bool = ...,
        requirements: collections.abc.Iterable[global___AuthRequirement] | None = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["oauth", b"oauth"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "allow_without_credential",
            b"allow_without_credential",
            "oauth",
            b"oauth",
            "requirements",
            b"requirements",
            "selector",
            b"selector",
        ],
    ) -> None: ...

global___AuthenticationRule = AuthenticationRule

@typing_extensions.final
class JwtLocation(google.protobuf.message.Message):
    """Specifies a location to extract JWT from an API request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEADER_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    VALUE_PREFIX_FIELD_NUMBER: builtins.int
    header: builtins.str
    """Specifies HTTP header name to extract JWT token."""
    query: builtins.str
    """Specifies URL query parameter name to extract JWT token."""
    value_prefix: builtins.str
    """The value prefix. The value format is "value_prefix{token}"
    Only applies to "in" header type. Must be empty for "in" query type.
    If not empty, the header value has to match (case sensitive) this prefix.
    If not matched, JWT will not be extracted. If matched, JWT will be
    extracted after the prefix is removed.

    For example, for "Authorization: Bearer {JWT}",
    value_prefix="Bearer " with a space at the end.
    """
    def __init__(
        self,
        *,
        header: builtins.str = ...,
        query: builtins.str = ...,
        value_prefix: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "header", b"header", "in", b"in", "query", b"query"
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "header",
            b"header",
            "in",
            b"in",
            "query",
            b"query",
            "value_prefix",
            b"value_prefix",
        ],
    ) -> None: ...
    def WhichOneof(
        self, oneof_group: typing_extensions.Literal["in", b"in"]
    ) -> typing_extensions.Literal["header", "query"] | None: ...

global___JwtLocation = JwtLocation

@typing_extensions.final
class AuthProvider(google.protobuf.message.Message):
    """Configuration for an authentication provider, including support for
    [JSON Web Token
    (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    ISSUER_FIELD_NUMBER: builtins.int
    JWKS_URI_FIELD_NUMBER: builtins.int
    AUDIENCES_FIELD_NUMBER: builtins.int
    AUTHORIZATION_URL_FIELD_NUMBER: builtins.int
    JWT_LOCATIONS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """The unique identifier of the auth provider. It will be referred to by
    `AuthRequirement.provider_id`.

    Example: "bookstore_auth".
    """
    issuer: builtins.str
    """Identifies the principal that issued the JWT. See
    https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
    Usually a URL or an email address.

    Example: https://securetoken.google.com
    Example: 1234567-compute@developer.gserviceaccount.com
    """
    jwks_uri: builtins.str
    """URL of the provider's public key set to validate signature of the JWT. See
    [OpenID
    Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
    Optional if the key set document:
     - can be retrieved from
       [OpenID
       Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html)
       of the issuer.
     - can be inferred from the email domain of the issuer (e.g. a Google
     service account).

    Example: https://www.googleapis.com/oauth2/v1/certs
    """
    audiences: builtins.str
    """The list of JWT
    [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
    that are allowed to access. A JWT containing any of these audiences will
    be accepted. When this setting is absent, JWTs with audiences:
      - "https://[service.name]/[google.protobuf.Api.name]"
      - "https://[service.name]/"
    will be accepted.
    For example, if no audiences are in the setting, LibraryService API will
    accept JWTs with the following audiences:
      -
      https://library-example.googleapis.com/google.example.library.v1.LibraryService
      - https://library-example.googleapis.com/

    Example:

        audiences: bookstore_android.apps.googleusercontent.com,
                   bookstore_web.apps.googleusercontent.com
    """
    authorization_url: builtins.str
    """Redirect URL if JWT token is required but not present or is expired.
    Implement authorizationUrl of securityDefinitions in OpenAPI spec.
    """
    @property
    def jwt_locations(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___JwtLocation
    ]:
        """Defines the locations to extract the JWT.

        JWT locations can be either from HTTP headers or URL query parameters.
        The rule is that the first match wins. The checking order is: checking
        all headers first, then URL query parameters.

        If not specified,  default to use following 3 locations:
           1) Authorization: Bearer
           2) x-goog-iap-jwt-assertion
           3) access_token query parameter

        Default locations can be specified as followings:
           jwt_locations:
           - header: Authorization
             value_prefix: "Bearer "
           - header: x-goog-iap-jwt-assertion
           - query: access_token
        """
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        issuer: builtins.str = ...,
        jwks_uri: builtins.str = ...,
        audiences: builtins.str = ...,
        authorization_url: builtins.str = ...,
        jwt_locations: collections.abc.Iterable[global___JwtLocation] | None = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "audiences",
            b"audiences",
            "authorization_url",
            b"authorization_url",
            "id",
            b"id",
            "issuer",
            b"issuer",
            "jwks_uri",
            b"jwks_uri",
            "jwt_locations",
            b"jwt_locations",
        ],
    ) -> None: ...

global___AuthProvider = AuthProvider

@typing_extensions.final
class OAuthRequirements(google.protobuf.message.Message):
    """OAuth scopes are a way to define data and permissions on data. For example,
    there are scopes defined for "Read-only access to Google Calendar" and
    "Access to Cloud Platform". Users can consent to a scope for an application,
    giving it permission to access that data on their behalf.

    OAuth scope specifications should be fairly coarse grained; a user will need
    to see and understand the text description of what your scope means.

    In most cases: use one or at most two OAuth scopes for an entire family of
    products. If your product has multiple APIs, you should probably be sharing
    the OAuth scope across all of those APIs.

    When you need finer grained OAuth consent screens: talk with your product
    management about how developers will use them in practice.

    Please note that even though each of the canonical scopes is enough for a
    request to be accepted and passed to the backend, a request can still fail
    due to the backend requiring additional scopes or permissions.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CANONICAL_SCOPES_FIELD_NUMBER: builtins.int
    canonical_scopes: builtins.str
    """The list of publicly documented OAuth scopes that are allowed access. An
    OAuth token containing any of these scopes will be accepted.

    Example:

         canonical_scopes: https://www.googleapis.com/auth/calendar,
                           https://www.googleapis.com/auth/calendar.read
    """
    def __init__(
        self,
        *,
        canonical_scopes: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal["canonical_scopes", b"canonical_scopes"],
    ) -> None: ...

global___OAuthRequirements = OAuthRequirements

@typing_extensions.final
class AuthRequirement(google.protobuf.message.Message):
    """User-defined authentication requirements, including support for
    [JSON Web Token
    (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_ID_FIELD_NUMBER: builtins.int
    AUDIENCES_FIELD_NUMBER: builtins.int
    provider_id: builtins.str
    """[id][google.api.AuthProvider.id] from authentication provider.

    Example:

        provider_id: bookstore_auth
    """
    audiences: builtins.str
    """NOTE: This will be deprecated soon, once AuthProvider.audiences is
    implemented and accepted in all the runtime components.

    The list of JWT
    [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
    that are allowed to access. A JWT containing any of these audiences will
    be accepted. When this setting is absent, only JWTs with audience
    "https://[Service_name][google.api.Service.name]/[API_name][google.protobuf.Api.name]"
    will be accepted. For example, if no audiences are in the setting,
    LibraryService API will only accept JWTs with the following audience
    "https://library-example.googleapis.com/google.example.library.v1.LibraryService".

    Example:

        audiences: bookstore_android.apps.googleusercontent.com,
                   bookstore_web.apps.googleusercontent.com
    """
    def __init__(
        self,
        *,
        provider_id: builtins.str = ...,
        audiences: builtins.str = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "audiences", b"audiences", "provider_id", b"provider_id"
        ],
    ) -> None: ...

global___AuthRequirement = AuthRequirement
