# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from fabric_cm.credmgr.swagger_server.models.base_model_ import Model
from fabric_cm.credmgr.swagger_server.models.status200_ok_single import Status200OkSingle  # noqa: F401,E501
from fabric_cm.credmgr.swagger_server.models.version_data import VersionData  # noqa: F401,E501
from fabric_cm.credmgr.swagger_server import util


class Version(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, size: int=1, status: int=200, type: str=None, data: List[VersionData]=None):  # noqa: E501
        """Version - a model defined in Swagger

        :param size: The size of this Version.  # noqa: E501
        :type size: int
        :param status: The status of this Version.  # noqa: E501
        :type status: int
        :param type: The type of this Version.  # noqa: E501
        :type type: str
        :param data: The data of this Version.  # noqa: E501
        :type data: List[VersionData]
        """
        self.swagger_types = {
            'size': int,
            'status': int,
            'type': str,
            'data': List[VersionData]
        }

        self.attribute_map = {
            'size': 'size',
            'status': 'status',
            'type': 'type',
            'data': 'data'
        }
        self._size = size
        self._status = status
        self._type = type
        self._data = data

    @classmethod
    def from_dict(cls, dikt) -> 'Version':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The version of this Version.  # noqa: E501
        :rtype: Version
        """
        return util.deserialize_model(dikt, cls)

    @property
    def size(self) -> int:
        """Gets the size of this Version.


        :return: The size of this Version.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size: int):
        """Sets the size of this Version.


        :param size: The size of this Version.
        :type size: int
        """

        self._size = size

    @property
    def status(self) -> int:
        """Gets the status of this Version.


        :return: The status of this Version.
        :rtype: int
        """
        return self._status

    @status.setter
    def status(self, status: int):
        """Sets the status of this Version.


        :param status: The status of this Version.
        :type status: int
        """

        self._status = status

    @property
    def type(self) -> str:
        """Gets the type of this Version.


        :return: The type of this Version.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str):
        """Sets the type of this Version.


        :param type: The type of this Version.
        :type type: str
        """

        self._type = type

    @property
    def data(self) -> List[VersionData]:
        """Gets the data of this Version.


        :return: The data of this Version.
        :rtype: List[VersionData]
        """
        return self._data

    @data.setter
    def data(self, data: List[VersionData]):
        """Sets the data of this Version.


        :param data: The data of this Version.
        :type data: List[VersionData]
        """

        self._data = data
