from . import api as api
from . import distribution as distribution
from . import extrapolation as extrapolation
from . import flux as flux
from . import graph as graph
from . import measure as measure
from . import periodicity as periodicity
from . import policy as policy
from . import projection as projection
from . import span as span
from . import segmentation as segmentation
from . import space as space

from . import dynamics as dynamics

from . import models as models

# Helper Methods:
import functools


def update_class(
        main_class=None, exclude=("__module__", "__name__", "__dict__", "__weakref__")
        ):
    """Class decorator. Adds all methods and members from the wrapped class to main_class

    Args:
    - main_class: class to which to append members. Defaults to the class with the same name as the wrapped class
    - exclude: black-list of members which should not be copied
    """

    def decorates(main_class, exclude, appended_class):
        if main_class is None:
            main_class = locals()[appended_class.__name__]
        for k, v in appended_class.__dict__.items():
            if k not in exclude:
                setattr(main_class, k, v)
        return main_class

    return functools.partial(decorates, main_class, exclude)
