import sys
import time
from functools import wraps

import numpy as np

__NO_ERR__ = False

def TimeCosts(runTimes:int = 1):
    """
    inner is func(times, *args, **kwargs)
    @TimeCosts(9)
    def f(idx, s):
        return s+idx
    print(f(8))\n
    print(f(s = 8))\n
    """
    def ret_wrapper( func ):
        def core_wrapper(*args, **kwargs):
            t0, ret = time.time(), []
            for times in range(runTimes):
                t1 = time.time()
                ret.append(func(times, *args, **kwargs))
                print(f'{times:2d} | {func.__name__:s} used {time.time()-t1:10.3f}s')
            print(f'{func.__name__:s} used {time.time()-t0:10.3f}s in total, {(time.time()-t0)/runTimes:10.3f}s by mean')
            return ret
        return core_wrapper
    return ret_wrapper

def rand_choose_times(choices_range:list[int] = [0,10], times:int = 100):
    randSeq = np.random.randint(low = choices_range[0], high = choices_range[1]+1, size = [times])
    count = [ np.sum(np.equal(randSeq,i)) for i in range(choices_range[0],choices_range[1]+1) ]
    return np.argmax(np.array(count))

def put_err(info:str, ret = None):
    if not __NO_ERR__:
        print(f'\nERR : {sys._getframe().f_code.co_name:s} : {info:s}\n')
    return ret
def put_log(info:str, head = "log", ret = None):
    print(f'\n{head:s} : {sys._getframe().f_code.co_name:s} : {info:s}\n')
    return ret

class MyArgs():
    def __init__(self, args:dict) -> None:
        self.args = dict()
        args = self.get_args(args)
    def get_args(self, args:dict, force_update = True, del_origin = False):
        for arg_name in list(args.keys()):
            if arg_name in self.args and not force_update:
                pass
            else:
                setattr(self, arg_name, args[arg_name])
            if del_origin:
                del args[arg_name]
        return self
    def add_arg(self, arg_name:str, arg_value, force_update = True):
        setattr(self, arg_name, arg_value)

def get_wanted_args(defalut_args:dict, kwargs:dict, del_kwargs = True):
    """
    wanted_args:dict with default value
    localVar = locals()
    """
    return MyArgs(defalut_args).get_args(kwargs, True, del_kwargs)
            