import { Test } from 'nodeunit';
declare const _default: {
    'a default cluster spans all subnets'(test: Test): void;
    'if "vpc" is not specified, vpc with default configuration will be created'(test: Test): void;
    'default capacity': {
        'x2 m5.large by default'(test: Test): void;
        'quantity and type can be customized'(test: Test): void;
        'defaultCapacity=0 will not allocate at all'(test: Test): void;
    };
    'creating a cluster tags the private VPC subnets'(test: Test): void;
    'creating a cluster tags the public VPC subnets'(test: Test): void;
    'adding capacity creates an ASG with tags'(test: Test): void;
    'create nodegroup with existing role'(test: Test): void;
    'adding bottlerocket capacity creates an ASG with tags'(test: Test): void;
    'adding bottlerocket capacity with bootstrapOptions throws error'(test: Test): void;
    'exercise export/import'(test: Test): void;
    'disabled features when kubectl is disabled'(test: Test): void;
    'addCapacity will *not* map the IAM role if mapRole is false'(test: Test): void;
    'addCapacity will *not* map the IAM role if kubectl is disabled'(test: Test): void;
    outputs: {
        'aws eks update-kubeconfig is the only output synthesized by default'(test: Test): void;
        'if `outputConfigCommand=false` will disabled the output'(test: Test): void;
        '`outputClusterName` can be used to synthesize an output with the cluster name'(test: Test): void;
        'boostrap user-data': {
            'rendered by default for ASGs'(test: Test): void;
            'not rendered if bootstrap is disabled'(test: Test): void;
            'bootstrap options'(test: Test): void;
            'spot instances': {
                'nodes labeled an tainted accordingly'(test: Test): void;
                'if kubectl is disabled, interrupt handler is not added'(test: Test): void;
            };
        };
        'if bootstrap is disabled cannot specify options'(test: Test): void;
        'EksOptimizedImage() with no nodeType always uses STANDARD with LATEST_KUBERNETES_VERSION'(test: Test): void;
        'EksOptimizedImage() with specific kubernetesVersion return correct AMI'(test: Test): void;
        'EKS-Optimized AMI with GPU support when addCapacity'(test: Test): void;
    };
};
export = _default;
