"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resources = void 0;
exports.resources = [
    {
        apiVersion: 'v1',
        kind: 'Service',
        metadata: { name: 'hello-kubernetes' },
        spec: {
            type: 'LoadBalancer',
            ports: [{ port: 80, targetPort: 8080 }],
            selector: { app: 'hello-kubernetes' },
        },
    },
    {
        apiVersion: 'apps/v1',
        kind: 'Deployment',
        metadata: { name: 'hello-kubernetes' },
        spec: {
            replicas: 1,
            selector: { matchLabels: { app: 'hello-kubernetes' } },
            template: {
                metadata: {
                    labels: { app: 'hello-kubernetes' },
                },
                spec: {
                    containers: [
                        {
                            name: 'hello-kubernetes',
                            image: 'paulbouwer/hello-kubernetes:1.5',
                            ports: [{ containerPort: 8080 }],
                        },
                    ],
                },
            },
        },
    },
];
//# sourceMappingURL=data:application/json;base64,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