"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeTsconfigOptions = exports.TypeScriptLibraryProject = exports.TypeScriptAppProject = exports.TypeScriptProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const common_1 = require("./common");
const component_1 = require("./component");
const eslint_1 = require("./eslint");
const node_project_1 = require("./node-project");
const sample_file_1 = require("./sample-file");
const tasks_1 = require("./tasks");
const textfile_1 = require("./textfile");
const typescript_config_1 = require("./typescript-config");
const typescript_typedoc_1 = require("./typescript-typedoc");
const projenrc_1 = require("./typescript/projenrc");
/**
 * (experimental) TypeScript project.
 *
 * @experimental
 * @pjid typescript
 */
class TypeScriptProject extends node_project_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3;
        super({
            ...options,
            // disable .projenrc.js if typescript is enabled
            projenrcJs: options.projenrcTs ? false : options.projenrcJs,
            jestOptions: {
                ...options.jestOptions,
                jestConfig: {
                    ...(_d = options.jestOptions) === null || _d === void 0 ? void 0 : _d.jestConfig,
                    testMatch: [],
                },
            },
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        this.libdir = (_f = options.libdir) !== null && _f !== void 0 ? _f : 'lib';
        this.docgen = options.docgen;
        this.docsDirectory = (_g = options.docsDirectory) !== null && _g !== void 0 ? _g : 'docs/';
        this.compileTask.exec('tsc');
        this.watchTask = this.addTask('watch', {
            description: 'Watch & compile in the background',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'tsc -w',
        });
        this.testdir = (_h = options.testdir) !== null && _h !== void 0 ? _h : 'test';
        this.gitignore.include(`/${this.testdir}`);
        (_j = this.npmignore) === null || _j === void 0 ? void 0 : _j.exclude(`/${this.testdir}`);
        // if the test directory is under `src/`, then we will run our tests against
        // the javascript files and not let jest compile it for us.
        const compiledTests = this.testdir.startsWith(this.srcdir + path.posix.sep);
        // by default, we first run tests (jest compiles the typescript in the background) and only then we compile.
        const compileBeforeTest = (_k = options.compileBeforeTest) !== null && _k !== void 0 ? _k : compiledTests;
        if (compileBeforeTest) {
            this.buildTask.spawn(this.compileTask);
            this.buildTask.spawn(this.testTask);
        }
        else {
            this.buildTask.spawn(this.testTask);
            this.buildTask.spawn(this.compileTask);
        }
        if ((_l = options.package) !== null && _l !== void 0 ? _l : true) {
            this.packageTask = this.addTask('package', {
                description: 'Create an npm tarball',
                category: tasks_1.TaskCategory.RELEASE,
            });
            this.packageTask.exec('rm -fr dist');
            this.packageTask.exec('mkdir -p dist/js');
            this.packageTask.exec(`${this.package.packageManager} pack`);
            this.packageTask.exec('mv *.tgz dist/js/');
            this.buildTask.spawn(this.packageTask);
        }
        if (options.entrypointTypes || this.entrypoint !== '') {
            const entrypointTypes = (_m = options.entrypointTypes) !== null && _m !== void 0 ? _m : `${path.join(path.dirname(this.entrypoint), path.basename(this.entrypoint, '.js')).replace(/\\/g, '/')}.d.ts`;
            this.package.addField('types', entrypointTypes);
        }
        const compilerOptionDefaults = {
            alwaysStrict: true,
            declaration: true,
            experimentalDecorators: true,
            inlineSourceMap: true,
            inlineSources: true,
            lib: ['es2018'],
            module: 'CommonJS',
            noEmitOnError: false,
            noFallthroughCasesInSwitch: true,
            noImplicitAny: true,
            noImplicitReturns: true,
            noImplicitThis: true,
            noUnusedLocals: true,
            noUnusedParameters: true,
            resolveJsonModule: true,
            strict: true,
            strictNullChecks: true,
            strictPropertyInitialization: true,
            stripInternal: true,
            target: 'ES2018',
        };
        if (!options.disableTsconfig) {
            const baseTsconfig = {
                include: [`${this.srcdir}/**/*.ts`],
                exclude: [
                    'node_modules',
                    this.libdir,
                ],
                compilerOptions: {
                    rootDir: this.srcdir,
                    outDir: this.libdir,
                    ...compilerOptionDefaults,
                },
            };
            this.tsconfig = new typescript_config_1.TypescriptConfig(this, mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
        }
        this.gitignore.exclude(`/${this.libdir}`);
        (_o = this.npmignore) === null || _o === void 0 ? void 0 : _o.include(`/${this.libdir}`);
        this.gitignore.include(`/${this.srcdir}`);
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.exclude(`/${this.srcdir}`);
        (_q = this.npmignore) === null || _q === void 0 ? void 0 : _q.include(`/${this.libdir}/**/*.js`);
        (_r = this.npmignore) === null || _r === void 0 ? void 0 : _r.include(`/${this.libdir}/**/*.d.ts`);
        this.gitignore.exclude('/dist');
        (_s = this.npmignore) === null || _s === void 0 ? void 0 : _s.exclude('dist'); // jsii-pacmak expects this to be "dist" and not "/dist". otherwise it will tamper with it
        (_t = this.npmignore) === null || _t === void 0 ? void 0 : _t.exclude('/tsconfig.json');
        (_u = this.npmignore) === null || _u === void 0 ? void 0 : _u.exclude('/.github');
        (_v = this.npmignore) === null || _v === void 0 ? void 0 : _v.exclude('/.vscode');
        (_w = this.npmignore) === null || _w === void 0 ? void 0 : _w.exclude('/.idea');
        (_x = this.npmignore) === null || _x === void 0 ? void 0 : _x.exclude('/.projenrc.js');
        (_y = this.npmignore) === null || _y === void 0 ? void 0 : _y.exclude('tsconfig.tsbuildinfo');
        // tests are compiled to `lib/TESTDIR`, so we don't need jest to compile them for us.
        // just run them directly from javascript.
        if (this.jest && compiledTests) {
            this.addDevDeps('@types/jest');
            const testout = path.posix.relative(this.srcdir, this.testdir);
            const libtest = path.posix.join(this.libdir, testout);
            const srctest = this.testdir;
            (_z = this.npmignore) === null || _z === void 0 ? void 0 : _z.addPatterns(`/${libtest}`);
            this.jest.addTestMatch(`**/${libtest}/**/?(*.)+(spec|test).js?(x)`);
            this.jest.addWatchIgnorePattern(`/${this.srcdir}/`);
            const resolveSnapshotPath = (test, ext) => {
                const fullpath = test.replace(libtest, srctest);
                return path.join(path.dirname(fullpath), '__snapshots__', path.basename(fullpath, '.js') + '.ts' + ext);
            };
            const resolveTestPath = (snap, ext) => {
                const filename = path.basename(snap, '.ts' + ext) + '.js';
                const dir = path.dirname(path.dirname(snap)).replace(srctest, libtest);
                return path.join(dir, filename);
            };
            const resolver = new textfile_1.TextFile(this, path.posix.join(common_1.PROJEN_DIR, 'jest-snapshot-resolver.js'));
            resolver.addLine('const path = require("path");');
            resolver.addLine(`const libtest = "${libtest}";`);
            resolver.addLine(`const srctest= "${srctest}";`);
            resolver.addLine('module.exports = {');
            resolver.addLine(`  resolveSnapshotPath: ${resolveSnapshotPath.toString()},`);
            resolver.addLine(`  resolveTestPath: ${resolveTestPath.toString()},`);
            resolver.addLine('  testPathForConsistencyCheck: path.join(\'some\', \'__tests__\', \'example.test.js\')');
            resolver.addLine('};');
            this.jest.addSnapshotResolver(`./${resolver.path}`);
        }
        if (this.jest && !compiledTests) {
            this.jest.addTestMatch('**\/__tests__/**\/*.ts?(x)');
            this.jest.addTestMatch('**\/?(*.)+(spec|test).ts?(x)');
            const baseTsconfig = {
                fileName: 'tsconfig.jest.json',
                include: [
                    common_1.PROJEN_RC,
                    `${this.srcdir}/**/*.ts`,
                    `${this.testdir}/**/*.ts`,
                ],
                exclude: [
                    'node_modules',
                ],
                compilerOptions: compilerOptionDefaults,
            };
            // create a tsconfig for jest that does NOT include outDir and rootDir and
            // includes both "src" and "test" as inputs.
            const tsconfig = this.jest.generateTypescriptConfig(mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
            // if we test before compilation, remove the lib/ directory before running
            // tests so that we get a clean slate for testing.
            if (!compileBeforeTest) {
                // make sure to delete "lib" *before* running tests to ensure that
                // test code does not take a dependency on "lib" and instead on "src".
                this.testTask.prependExec(`rm -fr ${this.libdir}/`);
            }
            // compile test code
            this.testCompileTask.exec(`tsc --noEmit --project ${tsconfig.fileName}`);
        }
        if ((_0 = options.eslint) !== null && _0 !== void 0 ? _0 : true) {
            this.eslint = new eslint_1.Eslint(this, {
                tsconfigPath: './tsconfig.eslint.json',
                dirs: [this.srcdir],
                devdirs: [this.testdir, 'build-tools'],
                fileExtensions: ['.ts', '.tsx'],
                ...options.eslintOptions,
            });
            const baseTsconfig = {
                fileName: 'tsconfig.eslint.json',
                include: [
                    common_1.PROJEN_RC,
                    `${this.srcdir}/**/*.ts`,
                    `${this.testdir}/**/*.ts`,
                ],
                exclude: [
                    'node_modules',
                ],
                compilerOptions: compilerOptionDefaults,
            };
            this.tsconfigEslint = new typescript_config_1.TypescriptConfig(this, mergeTsconfigOptions([baseTsconfig, options.tsconfig]));
        }
        const tsver = options.typescriptVersion ? `@${options.typescriptVersion}` : '';
        this.addDevDeps(`typescript${tsver}`, `@types/node@^${(_1 = this.package.minNodeVersion) !== null && _1 !== void 0 ? _1 : '10.17.0'}`);
        // generate sample code in `src` and `lib` if these directories are empty or non-existent.
        if ((_2 = options.sampleCode) !== null && _2 !== void 0 ? _2 : true) {
            new SampleCode(this);
        }
        if (this.docgen) {
            new typescript_typedoc_1.TypedocDocgen(this);
        }
        const projenrcTypeScript = (_3 = options.projenrcTs) !== null && _3 !== void 0 ? _3 : false;
        if (projenrcTypeScript) {
            new projenrc_1.Projenrc(this, options.projenrcTsOptions);
        }
    }
}
exports.TypeScriptProject = TypeScriptProject;
_a = JSII_RTTI_SYMBOL_1;
TypeScriptProject[_a] = { fqn: "projen.TypeScriptProject", version: "0.17.84" };
class SampleCode extends component_1.Component {
    constructor(project) {
        super(project);
        const srcCode = [
            'export class Hello {',
            '  public sayHello() {',
            '    return \'hello, world!\';',
            '  }',
            '}',
        ].join('\n');
        const testCode = [
            "import { Hello } from '../src';",
            '',
            "test('hello', () => {",
            "  expect(new Hello().sayHello()).toBe('hello, world!');",
            '});',
        ].join('\n');
        new sample_file_1.SampleDir(project, project.srcdir, {
            files: {
                'index.ts': srcCode,
            },
        });
        new sample_file_1.SampleDir(project, project.testdir, {
            files: {
                'hello.test.ts': testCode,
            },
        });
    }
}
/**
 * (experimental) TypeScript app.
 *
 * @experimental
 * @pjid typescript-app
 */
class TypeScriptAppProject extends TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        super({
            allowLibraryDependencies: false,
            releaseWorkflow: false,
            entrypoint: '',
            package: false,
            ...options,
        });
    }
}
exports.TypeScriptAppProject = TypeScriptAppProject;
_b = JSII_RTTI_SYMBOL_1;
TypeScriptAppProject[_b] = { fqn: "projen.TypeScriptAppProject", version: "0.17.84" };
/**
 * @deprecated use `TypeScriptProject`
 */
class TypeScriptLibraryProject extends TypeScriptProject {
}
exports.TypeScriptLibraryProject = TypeScriptLibraryProject;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptLibraryProject[_c] = { fqn: "projen.TypeScriptLibraryProject", version: "0.17.84" };
;
/**
 * @internal
 */
function mergeTsconfigOptions(options) {
    const definedOptions = options.filter(Boolean);
    return definedOptions.reduce((previous, current) => {
        var _d, _e, _f, _g;
        return ({
            ...previous,
            ...current,
            include: [
                ...(_d = previous.include) !== null && _d !== void 0 ? _d : [],
                ...(_e = current.include) !== null && _e !== void 0 ? _e : [],
            ],
            exclude: [
                ...(_f = previous.exclude) !== null && _f !== void 0 ? _f : [],
                ...(_g = current.exclude) !== null && _g !== void 0 ? _g : [],
            ],
            compilerOptions: {
                ...previous.compilerOptions,
                ...current.compilerOptions,
            },
        });
    }, { compilerOptions: {} });
}
exports.mergeTsconfigOptions = mergeTsconfigOptions;
//# sourceMappingURL=data:application/json;base64,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