"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeProject = exports.AutoRelease = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("./common");
const auto_merge_1 = require("./github/auto-merge");
const ignore_file_1 = require("./ignore-file");
const projenrc_1 = require("./javascript/projenrc");
const jest_1 = require("./jest");
const license_1 = require("./license");
const node_package_1 = require("./node-package");
const project_1 = require("./project");
const projen_upgrade_1 = require("./projen-upgrade");
const publisher_1 = require("./publisher");
const tasks_1 = require("./tasks");
const version_1 = require("./version");
const PROJEN_SCRIPT = 'projen';
/**
 * (experimental) Automatic bump modes.
 *
 * @experimental
 */
var AutoRelease;
(function (AutoRelease) {
    AutoRelease[AutoRelease["EVERY_COMMIT"] = 0] = "EVERY_COMMIT";
    AutoRelease[AutoRelease["DAILY"] = 1] = "DAILY";
})(AutoRelease = exports.AutoRelease || (exports.AutoRelease = {}));
/**
 * (experimental) Node.js project.
 *
 * @experimental
 */
class NodeProject extends project_1.Project {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8;
        super(options);
        this.package = new node_package_1.NodePackage(this, options);
        this.runScriptCommand = (() => {
            switch (this.packageManager) {
                case node_package_1.NodePackageManager.NPM: return 'npm run';
                case node_package_1.NodePackageManager.YARN: return 'yarn run';
                case node_package_1.NodePackageManager.PNPM: return 'pnpm run';
                default: throw new Error(`unexpected package manager ${this.packageManager}`);
            }
        })();
        this.nodeVersion = (_b = options.workflowNodeVersion) !== null && _b !== void 0 ? _b : this.package.minNodeVersion;
        this._version = new version_1.Version(this);
        // add PATH for all tasks which includes the project's npm .bin list
        this.tasks.addEnvironment('PATH', '$(npx -c "node -e \\\"console.log(process.env.PATH)\\\"")');
        this.compileTask = this.addTask('compile', {
            description: 'Only compile',
            category: tasks_1.TaskCategory.BUILD,
        });
        this.testCompileTask = this.addTask('test:compile', {
            description: 'compiles the test code',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask = this.addTask('test', {
            description: 'Run tests',
            category: tasks_1.TaskCategory.TEST,
        });
        this.testTask.spawn(this.testCompileTask);
        this.buildTask = this.addTask('build', {
            description: 'Full release build (test+compile)',
            category: tasks_1.TaskCategory.BUILD,
        });
        // first, execute projen as the first thing during build
        if ((_c = options.projenDuringBuild) !== null && _c !== void 0 ? _c : true) {
            // skip for sub-projects (i.e. "parent" is defined) since synthing the
            // root project will include the subprojects.
            if (!this.parent) {
                this.buildTask.exec(this.projenCommand);
            }
        }
        this.addLicense(options);
        this.npmDistTag = this.package.npmDistTag;
        this.npmRegistry = this.package.npmRegistry;
        if ((_d = options.npmignoreEnabled) !== null && _d !== void 0 ? _d : true) {
            this.npmignore = new ignore_file_1.IgnoreFile(this, '.npmignore');
        }
        this.addDefaultGitIgnore();
        if ((_e = options.gitignore) === null || _e === void 0 ? void 0 : _e.length) {
            for (const i of options.gitignore) {
                this.gitignore.exclude(i);
            }
        }
        if ((_f = options.npmignore) === null || _f === void 0 ? void 0 : _f.length) {
            if (!this.npmignore) {
                throw new Error('.npmignore is not defined for an APP project type. Add "npmIgnore: true" to override this');
            }
            for (const i of options.npmignore) {
                this.npmignore.exclude(i);
            }
        }
        this.setScript(PROJEN_SCRIPT, this.package.projenCommand);
        this.setScript('start', `${this.package.projenCommand} start`);
        (_g = this.npmignore) === null || _g === void 0 ? void 0 : _g.exclude(`/${common_1.PROJEN_RC}`);
        (_h = this.npmignore) === null || _h === void 0 ? void 0 : _h.exclude(`/${common_1.PROJEN_DIR}`);
        this.gitignore.include(`/${common_1.PROJEN_RC}`);
        const projen = (_j = options.projenDevDependency) !== null && _j !== void 0 ? _j : true;
        if (projen) {
            const projenVersion = (_k = options.projenVersion) !== null && _k !== void 0 ? _k : `^${common_1.PROJEN_VERSION}`;
            this.addDevDeps(`projen@${projenVersion}`);
        }
        if (!options.defaultReleaseBranch) {
            throw new Error('"defaultReleaseBranch" is temporarily a required option while we migrate its default value from "master" to "main"');
        }
        const buildEnabled = (_l = options.buildWorkflow) !== null && _l !== void 0 ? _l : (this.parent ? false : true);
        const mutableBuilds = (_m = options.mutableBuild) !== null && _m !== void 0 ? _m : true;
        // indicate if we have anti-tamper configured in our workflows. used by e.g. Jest
        // to decide if we can always run with --updateSnapshot
        this.antitamper = buildEnabled && ((_o = options.antitamper) !== null && _o !== void 0 ? _o : true);
        // configure jest if enabled
        // must be before the build/release workflows
        if ((_p = options.jest) !== null && _p !== void 0 ? _p : true) {
            this.jest = new jest_1.Jest(this, options.jestOptions);
        }
        if ((_q = options.buildWorkflow) !== null && _q !== void 0 ? _q : (this.parent ? false : true)) {
            const branch = '${{ github.event.pull_request.head.ref }}';
            const repo = '${{ github.event.pull_request.head.repo.full_name }}';
            const buildJobId = 'build';
            const updateRepo = new Array();
            const gitDiffStepId = 'git_diff';
            const hasChangesCondName = 'has_changes';
            const hasChanges = `steps.${gitDiffStepId}.outputs.${hasChangesCondName}`;
            const repoFullName = 'github.event.pull_request.head.repo.full_name';
            // use "git diff --exit code" to check if there were changes in the repo
            // and create a step output that will be used in subsequent steps.
            updateRepo.push({
                name: 'Check for changes',
                id: gitDiffStepId,
                run: `git diff --exit-code || echo "::set-output name=${hasChangesCondName}::true"`,
            });
            // only if we had changes, commit them and push to the repo note that for
            // forks, this will fail (because the workflow doesn't have permissions.
            // this indicates to users that they need to update their branch manually.
            updateRepo.push({
                if: hasChanges,
                name: 'Commit and push changes (if changed)',
                run: `git add . && git commit -m "chore: self mutation" && git push origin HEAD:${branch}`,
            });
            // if we pushed changes, we need to manually update the status check so
            // that the PR will be green (we won't get here for forks with updates
            // because the push would have failed).
            updateRepo.push({
                if: hasChanges,
                name: 'Update status check (if changed)',
                run: [
                    'gh api',
                    '-X POST',
                    `/repos/\${{ ${repoFullName} }}/check-runs`,
                    `-F name="${buildJobId}"`,
                    '-F head_sha="$(git rev-parse HEAD)"',
                    '-F status="completed"',
                    '-F conclusion="success"',
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            const workflow = this.createBuildWorkflow('Build', {
                jobId: buildJobId,
                trigger: {
                    pull_request: {},
                },
                checkoutWith: mutableBuilds ? {
                    ref: branch,
                    repository: repo,
                } : undefined,
                postSteps: updateRepo,
                antitamperDisabled: mutableBuilds,
                image: options.workflowContainerImage,
                codeCov: (_r = options.codeCov) !== null && _r !== void 0 ? _r : false,
                codeCovTokenSecret: options.codeCovTokenSecret,
            });
            this.buildWorkflow = workflow;
            this.buildWorkflowJobId = buildJobId;
        }
        if ((_s = options.releaseWorkflow) !== null && _s !== void 0 ? _s : (this.parent ? false : true)) {
            const defaultReleaseBranch = (_t = options.defaultReleaseBranch) !== null && _t !== void 0 ? _t : 'main';
            const releaseBranches = (_u = options.releaseBranches) !== null && _u !== void 0 ? _u : [defaultReleaseBranch];
            const trigger = {};
            if ((_v = options.releaseEveryCommit) !== null && _v !== void 0 ? _v : true) {
                trigger.push = { branches: releaseBranches };
            }
            if (options.releaseSchedule) {
                trigger.schedule = { cron: options.releaseSchedule };
            }
            const artifactDirectory = (_w = options.artifactsDirectory) !== null && _w !== void 0 ? _w : 'dist';
            const getVersion = 'v$(node -p \"require(\'./package.json\').version\")';
            const jobId = 'release';
            const releaseSteps = [];
            // to avoid race conditions between two commits trying to release the same
            // version, we check if the head sha is identical to the remote sha. if
            // not, we will skip the release and just finish the build.
            const gitRemoteStep = 'git_remote';
            const latestCommitOutput = 'latest_commit';
            const noNewCommits = `\${{ steps.${gitRemoteStep}.outputs.${latestCommitOutput} == github.sha }}`;
            releaseSteps.push({
                name: 'Check for new commits',
                id: gitRemoteStep,
                run: `echo ::set-output name=${latestCommitOutput}::"$(git ls-remote origin -h \${{ github.ref }} | cut -f1)"`,
            });
            releaseSteps.push({
                name: 'Create release',
                if: noNewCommits,
                run: [
                    `gh release create ${getVersion}`,
                    `-F ${this._version.changelogFile}`,
                    `-t ${getVersion}`,
                ].join(' '),
                env: {
                    GITHUB_TOKEN: '${{ secrets.GITHUB_TOKEN }}',
                },
            });
            releaseSteps.push({
                name: 'Unbump',
                run: this.runTaskCommand(this._version.unbumpTask),
            });
            releaseSteps.push({
                name: 'Upload artifact',
                if: noNewCommits,
                uses: 'actions/upload-artifact@v2.1.1',
                with: {
                    name: artifactDirectory,
                    path: artifactDirectory,
                },
            });
            const workflow = this.createBuildWorkflow('Release', {
                jobId: jobId,
                trigger,
                env: {
                    RELEASE: 'true',
                },
                preBuildSteps: [
                    {
                        name: 'Bump to next version',
                        run: this.runTaskCommand(this._version.bumpTask),
                    },
                    ...(_x = options.releaseWorkflowSetupSteps) !== null && _x !== void 0 ? _x : [],
                ],
                postSteps: releaseSteps,
                image: options.workflowContainerImage,
                codeCov: false,
                checkoutWith: {
                    // we must use 'fetch-depth=0' in order to fetch all tags
                    // otherwise tags are not checked out
                    'fetch-depth': 0,
                },
            });
            this.releaseWorkflow = workflow;
            this.publisher = new publisher_1.Publisher(this, {
                workflow: this.releaseWorkflow,
                artifactName: artifactDirectory,
                buildJobId: jobId,
                jsiiReleaseVersion: options.jsiiReleaseVersion,
            });
            if ((_y = options.releaseToNpm) !== null && _y !== void 0 ? _y : false) {
                this.publisher.publishToNpm({
                    distTag: this.package.npmDistTag,
                    registry: this.package.npmRegistry,
                    npmTokenSecret: this.package.npmTokenSecret,
                });
            }
        }
        else {
            // validate that no release options are selected if the release workflow is disabled.
            if (options.releaseToNpm) {
                throw new Error('"releaseToNpm" is not supported for APP projects');
            }
            if (options.releaseBranches) {
                throw new Error('"releaseBranches" is not supported for APP projects');
            }
            if (options.releaseEveryCommit) {
                throw new Error('"releaseEveryCommit" is not supported for APP projects');
            }
            if (options.releaseSchedule) {
                throw new Error('"releaseSchedule" is not supported for APP projects');
            }
        }
        if ((_z = this.github) === null || _z === void 0 ? void 0 : _z.mergify) {
            this.autoMerge = new auto_merge_1.AutoMerge(this, {
                autoMergeLabel: options.mergifyAutoMergeLabel,
                buildJob: this.buildWorkflowJobId,
            });
            (_0 = this.npmignore) === null || _0 === void 0 ? void 0 : _0.exclude('/.mergify.yml');
        }
        if ((_1 = options.dependabot) !== null && _1 !== void 0 ? _1 : true) {
            (_2 = this.github) === null || _2 === void 0 ? void 0 : _2.addDependabot(options.dependabotOptions);
        }
        const projenAutoMerge = (_3 = options.projenUpgradeAutoMerge) !== null && _3 !== void 0 ? _3 : true;
        new projen_upgrade_1.ProjenUpgrade(this, {
            autoUpgradeSecret: options.projenUpgradeSecret,
            autoUpgradeSchedule: options.projenUpgradeSchedule,
            labels: (projenAutoMerge && ((_4 = this.autoMerge) === null || _4 === void 0 ? void 0 : _4.autoMergeLabel))
                ? [this.autoMerge.autoMergeLabel]
                : [],
        });
        if ((_5 = options.pullRequestTemplate) !== null && _5 !== void 0 ? _5 : true) {
            (_6 = this.github) === null || _6 === void 0 ? void 0 : _6.addPullRequestTemplate(...(_7 = options.pullRequestTemplateContents) !== null && _7 !== void 0 ? _7 : []);
        }
        const projenrcJs = (_8 = options.projenrcJs) !== null && _8 !== void 0 ? _8 : true;
        if (projenrcJs) {
            new projenrc_1.Projenrc(this, options.projenrcJsOptions);
        }
    }
    /**
     * @deprecated use `package.allowLibraryDependencies`
     */
    get allowLibraryDependencies() { return this.package.allowLibraryDependencies; }
    /**
     * @deprecated use `package.entrypoint`
     */
    get entrypoint() { return this.package.entrypoint; }
    /**
     * (experimental) Minimum node.js version required by this package.
     *
     * @experimental
     */
    get minNodeVersion() { return this.package.minNodeVersion; }
    /**
     * (experimental) Maximum node version required by this pacakge.
     *
     * @experimental
     */
    get maxNodeVersion() { return this.package.maxNodeVersion; }
    /**
     * (deprecated) The package manager to use.
     *
     * @deprecated use `package.packageManager`
     */
    get packageManager() { return this.package.packageManager; }
    /**
     * (deprecated) Determines how tasks are executed when invoked as npm scripts (yarn/npm run xyz).
     *
     * @deprecated use `package.npmTaskExecution`
     */
    get npmTaskExecution() { return this.package.npmTaskExecution; }
    /**
     * (experimental) The command to use in order to run the projen CLI.
     *
     * @experimental
     */
    get projenCommand() { return this.package.projenCommand; }
    /**
     * @deprecated use `package.addField(x, y)`
     */
    get manifest() {
        return this.package.manifest;
    }
    /**
     * @experimental
     */
    addBins(bins) {
        this.package.addBin(bins);
    }
    /**
     * (experimental) Replaces the contents of an npm package.json script.
     *
     * @param name The script name.
     * @param command The command to execute.
     * @experimental
     */
    setScript(name, command) {
        this.package.setScript(name, command);
    }
    /**
     * (experimental) Removes the npm script (always successful).
     *
     * @param name The name of the script.
     * @experimental
     */
    removeScript(name) {
        this.package.removeScript(name);
    }
    /**
     * (experimental) Indicates if a script by the name name is defined.
     *
     * @param name The name of the script.
     * @experimental
     */
    hasScript(name) {
        return this.package.hasScript(name);
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.compileTask.exec()`
     */
    addCompileCommand(...commands) {
        for (const c of commands) {
            this.compileTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.testTask.exec()`
     */
    addTestCommand(...commands) {
        for (const c of commands) {
            this.testTask.exec(c);
        }
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use `project.buildTask.exec()`
     */
    addBuildCommand(...commands) {
        for (const c of commands) {
            this.buildTask.exec(c);
        }
    }
    /**
     * (experimental) Directly set fields in `package.json`.
     *
     * @param fields The fields to set.
     * @experimental
     */
    addFields(fields) {
        for (const [name, value] of Object.entries(fields)) {
            this.package.addField(name, value);
        }
    }
    /**
     * (experimental) Adds keywords to package.json (deduplicated).
     *
     * @param keywords The keywords to add.
     * @experimental
     */
    addKeywords(...keywords) {
        this.package.addKeywords(...keywords);
    }
    /**
     * @experimental
     */
    get installWorkflowSteps() {
        const install = new Array();
        if (this.nodeVersion) {
            install.push({
                name: 'Setup Node.js',
                uses: 'actions/setup-node@v1',
                with: { 'node-version': this.nodeVersion },
            });
        }
        install.push({
            name: 'Install dependencies',
            run: this.package.installCommand,
        });
        return install;
    }
    /**
     * (experimental) Defines normal dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDeps(...deps) {
        return this.package.addDeps(...deps);
    }
    /**
     * (experimental) Defines development/test dependencies.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addDevDeps(...deps) {
        return this.package.addDevDeps(...deps);
    }
    /**
     * (experimental) Defines peer dependencies.
     *
     * When adding peer dependencies, a devDependency will also be added on the
     * pinned version of the declared peer. This will ensure that you are testing
     * your code against the minimum version required from your consumers.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addPeerDeps(...deps) {
        return this.package.addPeerDeps(...deps);
    }
    /**
     * (experimental) Defines bundled dependencies.
     *
     * Bundled dependencies will be added as normal dependencies as well as to the
     * `bundledDependencies` section of your `package.json`.
     *
     * @param deps Names modules to install.
     * @experimental
     */
    addBundledDeps(...deps) {
        return this.package.addBundledDeps(...deps);
    }
    addLicense(options) {
        var _b;
        if (this.package.license) {
            new license_1.License(this, this.package.license, {
                copyrightOwner: (_b = options.copyrightOwner) !== null && _b !== void 0 ? _b : options.authorName,
                copyrightPeriod: options.copyrightPeriod,
            });
        }
    }
    addDefaultGitIgnore() {
        this.gitignore.exclude('# Logs', 'logs', '*.log', 'npm-debug.log*', 'yarn-debug.log*', 'yarn-error.log*', 'lerna-debug.log*', '# Diagnostic reports (https://nodejs.org/api/report.html)', 'report.[0-9]*.[0-9]*.[0-9]*.[0-9]*.json', '# Runtime data', 'pids', '*.pid', '*.seed', '*.pid.lock', '# Directory for instrumented libs generated by jscoverage/JSCover', 'lib-cov', '# Coverage directory used by tools like istanbul', 'coverage', '*.lcov', '# nyc test coverage', '.nyc_output', '# Compiled binary addons (https://nodejs.org/api/addons.html)', 'build/Release', '# Dependency directories', 'node_modules/', 'jspm_packages/', '# TypeScript cache', '*.tsbuildinfo', '# Optional eslint cache', '.eslintcache', '# Output of \'npm pack\'', '*.tgz', '# Yarn Integrity file', '.yarn-integrity', '# parcel-bundler cache (https://parceljs.org/)', '.cache');
    }
    createBuildWorkflow(name, options) {
        var _b, _c, _d, _e, _f;
        const buildJobId = options.jobId;
        const github = this.github;
        if (!github) {
            throw new Error('no github support');
        }
        const workflow = github.addWorkflow(name);
        if (options.trigger) {
            if (options.trigger.issue_comment) {
                throw new Error('"issue_comment" should not be used as a trigger due to a security issue');
            }
            workflow.on(options.trigger);
        }
        workflow.on({
            workflow_dispatch: {},
        });
        const condition = options.condition ? { if: options.condition } : {};
        const preBuildSteps = (_b = options.preBuildSteps) !== null && _b !== void 0 ? _b : [];
        const preCheckoutSteps = (_c = options.preCheckoutSteps) !== null && _c !== void 0 ? _c : [];
        const checkoutWith = options.checkoutWith ? { with: options.checkoutWith } : {};
        const postSteps = (_d = options.postSteps) !== null && _d !== void 0 ? _d : [];
        const antitamperSteps = (options.antitamperDisabled || !this.antitamper) ? [] : [{
                name: 'Anti-tamper check',
                run: 'git diff --ignore-space-at-eol --exit-code',
            }];
        const job = {
            'runs-on': 'ubuntu-latest',
            'env': {
                CI: 'true',
                ...(_e = options.env) !== null && _e !== void 0 ? _e : {},
            },
            ...condition,
            'steps': [
                ...preCheckoutSteps,
                // check out sources.
                {
                    name: 'Checkout',
                    uses: 'actions/checkout@v2',
                    ...checkoutWith,
                },
                // install dependencies
                ...this.installWorkflowSteps,
                // perform an anti-tamper check immediately after we run projen.
                ...antitamperSteps,
                // sets git identity so we can push later
                {
                    name: 'Set git identity',
                    run: [
                        'git config user.name "Automation"',
                        'git config user.email "github-actions@github.com"',
                    ].join('\n'),
                },
                // if there are changes, creates a bump commit
                ...preBuildSteps,
                // build (compile + test)
                {
                    name: 'Build',
                    run: this.runTaskCommand(this.buildTask),
                },
                // run codecov if enabled or a secret token name is passed in
                // AND jest must be configured
                ...(options.codeCov || options.codeCovTokenSecret) && ((_f = this.jest) === null || _f === void 0 ? void 0 : _f.config) ? [{
                        name: 'Upload coverage to Codecov',
                        uses: 'codecov/codecov-action@v1',
                        with: options.codeCovTokenSecret ? {
                            token: `\${{ secrets.${options.codeCovTokenSecret} }}`,
                            directory: this.jest.config.coverageDirectory,
                        } : {
                            directory: this.jest.config.coverageDirectory,
                        },
                    }] : [],
                ...postSteps,
                // anti-tamper check (fails if there were changes to committed files)
                // this will identify any non-committed files generated during build (e.g. test snapshots)
                ...antitamperSteps,
            ],
        };
        if (options.image) {
            job.container = { image: options.image };
        }
        workflow.addJobs({ [buildJobId]: job });
        return workflow;
    }
    /**
     * (experimental) Returns the shell command to execute in order to run a task.
     *
     * If
     * npmTaskExecution is set to PROJEN, the command will be `npx projen TASK`.
     * If it is set to SHELL, the command will be `yarn run TASK` (or `npm run
     * TASK`).
     *
     * @param task The task for which the command is required.
     * @experimental
     */
    runTaskCommand(task) {
        switch (this.package.npmTaskExecution) {
            case node_package_1.NpmTaskExecution.PROJEN: return `${this.package.projenCommand} ${task.name}`;
            case node_package_1.NpmTaskExecution.SHELL: return `${this.runScriptCommand} ${task.name}`;
            default:
                throw new Error(`invalid npmTaskExecution mode: ${this.package.npmTaskExecution}`);
        }
    }
}
exports.NodeProject = NodeProject;
_a = JSII_RTTI_SYMBOL_1;
NodeProject[_a] = { fqn: "projen.NodeProject", version: "0.17.84" };
//# sourceMappingURL=data:application/json;base64,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