"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiProject = exports.Stability = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const jsii_docgen_1 = require("./jsii-docgen");
const tasks_1 = require("./tasks");
const typescript_1 = require("./typescript");
const DEFAULT_JSII_IMAGE = 'jsii/superchain';
const EMAIL_REGEX = /(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])/;
const URL_REGEX = /((([A-Za-z]{3,9}:(?:\/\/)?)(?:[\-;:&=\+\$,\w]+@)?[A-Za-z0-9\.\-]+|(?:www\.|[\-;:&=\+\$,\w]+@)[A-Za-z0-9\.\-]+)((?:\/[\+~%\/\.\w\-_]*)?\??(?:[\-\+=&;%@\.\w_]*)#?(?:[\.\!\/\\\w]*))?)/;
/**
 * @experimental
 */
var Stability;
(function (Stability) {
    Stability["EXPERIMENTAL"] = "experimental";
    Stability["STABLE"] = "stable";
    Stability["DEPRECATED"] = "deprecated";
})(Stability = exports.Stability || (exports.Stability = {}));
/**
 * (experimental) Multi-language jsii library project.
 *
 * @experimental
 */
class JsiiProject extends typescript_1.TypeScriptProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
        const { authorEmail, authorUrl } = parseAuthorAddress(options);
        super({
            ...options,
            workflowContainerImage: (_b = options.workflowContainerImage) !== null && _b !== void 0 ? _b : DEFAULT_JSII_IMAGE,
            // this is needed temporarily because our release workflows use the 'gh'
            // cli and its not yet available in jsii/superchain
            releaseWorkflowSetupSteps: options.releaseWorkflowSetupSteps,
            releaseToNpm: false,
            repository: options.repositoryUrl,
            authorName: options.author,
            ...options,
            disableTsconfig: true,
            authorEmail,
            authorUrl,
        });
        const srcdir = this.srcdir;
        const libdir = this.libdir;
        this.addFields({ types: `${libdir}/index.d.ts` });
        // this is an unhelpful warning
        const jsiiFlags = [
            '--silence-warnings=reserved-word',
            '--no-fix-peer-dependencies',
        ].join(' ');
        const compatIgnore = (_c = options.compatIgnore) !== null && _c !== void 0 ? _c : '.compatignore';
        this.addFields({ stability: (_d = options.stability) !== null && _d !== void 0 ? _d : Stability.STABLE });
        if (options.stability === Stability.DEPRECATED) {
            this.addFields({ deprecated: true });
        }
        const compatTask = this.addTask('compat', {
            description: 'Perform API compatibility check against latest version',
            category: tasks_1.TaskCategory.RELEASE,
            exec: `jsii-diff npm:$(node -p "require(\'./package.json\').name") -k --ignore-file ${compatIgnore} || (echo "\nUNEXPECTED BREAKING CHANGES: add keys such as \'removed:constructs.Node.of\' to ${compatIgnore} to skip.\n" && exit 1)`,
        });
        const compat = (_e = options.compat) !== null && _e !== void 0 ? _e : false;
        if (compat) {
            this.compileTask.spawn(compatTask);
        }
        this.compileTask.reset(`jsii ${jsiiFlags}`);
        this.watchTask.reset(`jsii -w ${jsiiFlags}`);
        (_f = this.packageTask) === null || _f === void 0 ? void 0 : _f.reset('jsii-pacmak');
        const targets = {};
        const jsii = {
            outdir: 'dist',
            targets,
            tsc: {
                outDir: libdir,
                rootDir: srcdir,
            },
        };
        if (options.excludeTypescript) {
            jsii.excludeTypescript = options.excludeTypescript;
        }
        this.addFields({ jsii });
        (_g = this.publisher) === null || _g === void 0 ? void 0 : _g.publishToNpm({
            distTag: this.package.npmDistTag,
            registry: this.package.npmRegistry,
            npmTokenSecret: this.package.npmTokenSecret,
        });
        // we cannot call an option `java` because the java code generated by jsii
        // does not compile due to a conflict between this option name and the `java`
        // package (e.g. when `java.util.Objects` is referenced).
        if ('java' in options) {
            throw new Error('the "java" option is now called "publishToMaven"');
        }
        if (options.publishToMaven) {
            targets.java = {
                package: options.publishToMaven.javaPackage,
                maven: {
                    groupId: options.publishToMaven.mavenGroupId,
                    artifactId: options.publishToMaven.mavenArtifactId,
                },
            };
            (_h = this.publisher) === null || _h === void 0 ? void 0 : _h.publishToMaven(options.publishToMaven);
        }
        const pypi = (_j = options.publishToPypi) !== null && _j !== void 0 ? _j : options.python;
        if (pypi) {
            targets.python = {
                distName: pypi.distName,
                module: pypi.module,
            };
            (_k = this.publisher) === null || _k === void 0 ? void 0 : _k.publishToPyPi(pypi);
        }
        const nuget = (_l = options.publishToNuget) !== null && _l !== void 0 ? _l : options.dotnet;
        if (nuget) {
            targets.dotnet = {
                namespace: nuget.dotNetNamespace,
                packageId: nuget.packageId,
            };
            (_m = this.publisher) === null || _m === void 0 ? void 0 : _m.publishToNuget(nuget);
        }
        const golang = options.publishToGo;
        if (golang) {
            targets.go = {
                moduleName: golang.moduleName,
            };
            (_o = this.publisher) === null || _o === void 0 ? void 0 : _o.publishToGo(golang);
        }
        this.addDevDeps('jsii', 'jsii-diff', 'jsii-pacmak');
        this.gitignore.exclude('.jsii', 'tsconfig.json');
        (_p = this.npmignore) === null || _p === void 0 ? void 0 : _p.include('.jsii');
        if ((_q = options.docgen) !== null && _q !== void 0 ? _q : true) {
            new jsii_docgen_1.JsiiDocgen(this);
        }
        // jsii updates .npmignore, so we make it writable
        if (this.npmignore) {
            this.npmignore.readonly = false;
        }
    }
}
exports.JsiiProject = JsiiProject;
_a = JSII_RTTI_SYMBOL_1;
JsiiProject[_a] = { fqn: "projen.JsiiProject", version: "0.17.84" };
function parseAuthorAddress(options) {
    let authorEmail = options.authorEmail;
    let authorUrl = options.authorUrl;
    if (options.authorAddress) {
        if (options.authorEmail && options.authorEmail !== options.authorAddress) {
            throw new Error('authorEmail is deprecated and cannot be used in conjunction with authorAddress');
        }
        if (options.authorUrl && options.authorUrl !== options.authorAddress) {
            throw new Error('authorUrl is deprecated and cannot be used in conjunction with authorAddress.');
        }
        if (EMAIL_REGEX.test(options.authorAddress)) {
            authorEmail = options.authorAddress;
        }
        else if (URL_REGEX.test(options.authorAddress)) {
            authorUrl = options.authorAddress;
        }
        else {
            throw new Error(`authorAddress must be either an email address or a URL: ${options.authorAddress}`);
        }
    }
    return { authorEmail, authorUrl };
}
//# sourceMappingURL=data:application/json;base64,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