"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoMerge = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * (experimental) Sets up mergify to merging approved pull requests.
 *
 * If `buildJob` is specified, the specified GitHub workflow job ID is required
 * to succeed in order for the PR to be merged.
 *
 * `approvedReviews` specified the number of code review approvals required for
 * the PR to be merged.
 *
 * @experimental
 */
class AutoMerge extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options = {}) {
        var _b, _c, _d, _e, _f, _g;
        super(project);
        const successfulBuild = options.buildJob
            ? [`status-success=${options.buildJob}`]
            : [];
        const mergeAction = {
            merge: {
                // squash all commits into a single commit when merging
                method: 'squash',
                // use PR title+body as the commit message
                commit_message: 'title+body',
                // update PR branch so it's up-to-date before merging
                strict: 'smart',
                strict_method: 'merge',
            },
            delete_head_branch: {},
        };
        const approvedReviews = (_b = options.approvedReviews) !== null && _b !== void 0 ? _b : 1;
        (_d = (_c = project.github) === null || _c === void 0 ? void 0 : _c.mergify) === null || _d === void 0 ? void 0 : _d.addRule({
            name: 'Automatic merge on approval and successful build',
            actions: mergeAction,
            conditions: [
                `#approved-reviews-by>=${approvedReviews}`,
                ...successfulBuild,
            ],
        });
        // empty string means disabled.
        const autoMergeLabel = (_e = options.autoMergeLabel) !== null && _e !== void 0 ? _e : 'auto-merge';
        ;
        this.autoMergeLabel = autoMergeLabel;
        if (this.autoMergeLabel) {
            (_g = (_f = project.github) === null || _f === void 0 ? void 0 : _f.mergify) === null || _g === void 0 ? void 0 : _g.addRule({
                name: `Automatic merge PRs with ${autoMergeLabel} label upon successful build`,
                actions: mergeAction,
                conditions: [
                    `label=${autoMergeLabel}`,
                    ...successfulBuild,
                ],
            });
        }
    }
}
exports.AutoMerge = AutoMerge;
_a = JSII_RTTI_SYMBOL_1;
AutoMerge[_a] = { fqn: "projen.github.AutoMerge", version: "0.17.84" };
//# sourceMappingURL=data:application/json;base64,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