"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
const aws_apigateway_sagemakerendpoint_1 = require("@aws-solutions-constructs/aws-apigateway-sagemakerendpoint");
const app = new core_1.App();
// Empty arguments
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
const gatewayToSageMakerEndpoint = new aws_apigateway_sagemakerendpoint_1.ApiGatewayToSageMakerEndpoint(stack, 'api-gateway-sagemakerendpoint', {
    endpointName: 'my-endpoint',
    resourcePath: '{my_param}',
    requestMappingTemplate: 'my-request-vtl-template'
});
new lib_1.WafwebaclToApiGateway(stack, 'test-wafwebacl-apigateway-SageMakerEndpoint', {
    existingApiGatewayInterface: gatewayToSageMakerEndpoint.apiGateway
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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