# Generated by Django 3.0.13 on 2022-05-25 19:16

import categories.models
from django.db import migrations, models
import django.db.models.deletion
import exchange.models
import manufacturers.models
import product_barcode.models
import tecdoc.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('categories', '0001_initial'),
        ('manufacturers', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price_retail', models.FloatField(verbose_name='Retail price')),
                ('price_wholesale', models.FloatField(default=0, verbose_name='Wholesale price')),
                ('price_usd', models.FloatField(default=0)),
                ('price_eur', models.FloatField(default=0)),
                ('price_uah', models.FloatField(default=0)),
                ('initial_currency', exchange.models.CurrencyField(choices=[(980, 'UAH'), (840, 'USD'), (978, 'EUR')], default=980, verbose_name='Currency')),
                ('stock', models.FloatField(default=0, verbose_name='Stock')),
                ('min_stock', models.FloatField(default=0, verbose_name='Minimum stock')),
                ('unit_type', models.CharField(choices=[('pcs', 'pcs.'), ('l', 'l'), ('ml', 'ml'), ('g', 'g'), ('kg', 'kg'), ('pgs', 'pgs')], default='pcs', max_length=100, verbose_name='Unit type')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is active')),
                ('name', models.CharField(blank=True, db_index=True, max_length=255, verbose_name='Product name')),
                ('code', models.CharField(blank=True, max_length=255, verbose_name='Code')),
                ('clean_code', models.CharField(db_index=True, max_length=255)),
                ('bar_code', product_barcode.models.BarCodeField(blank=True, db_index=True, max_length=255, null=True, verbose_name='Bar code')),
                ('additional_codes', tecdoc.models.AdditionalCodesField(blank=True, db_index=True, max_length=2700, verbose_name='Additional codes')),
                ('warehouse', models.CharField(blank=True, max_length=255, verbose_name='Warehouse location')),
                ('created', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Creation date')),
                ('category', categories.models.CategoryField(on_delete=django.db.models.deletion.CASCADE, related_name='products', to='categories.Category', verbose_name='Category')),
                ('manufacturer', manufacturers.models.ManufacturerField(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='products', to='manufacturers.Manufacturer', verbose_name='Manufacturer')),
            ],
            options={
                'verbose_name': 'Product',
                'verbose_name_plural': 'Products',
                'ordering': ['-id'],
            },
        ),
    ]
