# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
# See LICENSE for more details.
#
# Copyright: Red Hat Inc. 2016
# Authors: Cleber Rosa <crosa@redhat.com>

"""Result Archive Plugin"""

from avocado.core.plugin_interfaces import CLI, Result
from avocado.core.settings import settings
from avocado.utils import archive


class Archive(Result):

    name = "zip_archive"
    description = "Result archive (ZIP) support"

    def render(self, result, job):
        if job.config.get("run.results.archive"):
            archive.compress(f"{job.logdir}.zip", job.logdir)


class ArchiveCLI(CLI):

    name = "zip_archive"
    description = "Result archive (ZIP) support to run command"

    def configure(self, parser):
        run_subcommand_parser = parser.subcommands.choices.get("run", None)
        if run_subcommand_parser is None:
            return

        help_msg = "Archive (ZIP) files generated by tests"
        settings.register_option(
            section="run.results",
            key="archive",
            default=False,
            help_msg=help_msg,
            key_type=bool,
            parser=run_subcommand_parser,
            short_arg="-z",
            long_arg="--archive",
        )

    def run(self, config):
        pass
