"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedPolicyAttachment = void 0;
class ManagedPolicyAttachment {
    constructor(identityArn, managedPolicyArn) {
        this.identityArn = identityArn;
        this.managedPolicyArn = managedPolicyArn;
    }
    static parseManagedPolicies(identityArn, arns) {
        return typeof arns === 'string'
            ? [new ManagedPolicyAttachment(identityArn, arns)]
            : arns.map((arn) => new ManagedPolicyAttachment(identityArn, arn));
    }
    equal(other) {
        return this.identityArn === other.identityArn
            && this.managedPolicyArn === other.managedPolicyArn;
    }
    /**
     * Return a machine-readable version of the changes.
     * This is only used in tests.
     *
     * @internal
     */
    _toJson() {
        return { identityArn: this.identityArn, managedPolicyArn: this.managedPolicyArn };
    }
}
exports.ManagedPolicyAttachment = ManagedPolicyAttachment;
//# sourceMappingURL=data:application/json;base64,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