"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TemplateAssertions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const match_1 = require("./match");
const matcher_1 = require("./matcher");
const resource_1 = require("./private/resource");
const assert = require("./vendored/assert");
/**
 * (experimental) Suite of assertions that can be run on a CDK stack.
 *
 * Typically used, as part of unit tests, to validate that the rendered
 * CloudFormation template has expected resources and properties.
 *
 * @experimental
 */
class TemplateAssertions {
    constructor(template) {
        this.inspector = new assert.StackInspector(template);
    }
    /**
     * (experimental) Base your assertions on the CloudFormation template synthesized by a CDK `Stack`.
     *
     * @param stack the CDK Stack to run assertions on.
     * @experimental
     */
    static fromStack(stack) {
        return new TemplateAssertions(toTemplate(stack));
    }
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as a nested set of records.
     *
     * @param template the CloudFormation template formatted as a nested set of records.
     * @experimental
     */
    static fromTemplate(template) {
        return new TemplateAssertions(template);
    }
    /**
     * (experimental) Base your assertions from an existing CloudFormation template formatted as a string.
     *
     * @param template the CloudFormation template in.
     * @experimental
     */
    static fromString(template) {
        return new TemplateAssertions(JSON.parse(template));
    }
    /**
     * (experimental) Assert that the given number of resources of the given type exist in the template.
     *
     * @param type the resource type;
     * @param count number of expected instances.
     * @experimental
     */
    resourceCountIs(type, count) {
        const assertion = assert.countResources(type, count);
        assertion.assertOrThrow(this.inspector);
    }
    /**
     * (experimental) Assert that a resource of the given type and properties exists in the CloudFormation template.
     *
     * By default, performs partial matching on the `Properties` key of the resource, via the
     * `Match.objectLike()`. To configure different behavour, use other matchers in the `Match` class.
     *
     * @param type the resource type;
     * @param props the 'Properties' section of the resource as should be expected in the template.
     * @experimental
     */
    hasResourceProperties(type, props) {
        this.hasResource(type, match_1.Match.objectLike({
            Properties: matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props),
        }));
    }
    /**
     * (experimental) Assert that a resource of the given type and given definition exists in the CloudFormation template.
     *
     * By default, performs partial matching on the resource, via the `Match.objectLike()`.
     * To configure different behavour, use other matchers in the `Match` class.
     *
     * @param type the resource type;
     * @param props the entire defintion of the resource as should be expected in the template.
     * @experimental
     */
    hasResource(type, props) {
        const matchError = resource_1.hasResource(this.inspector, type, props);
        if (matchError) {
            throw new Error(matchError);
        }
    }
    /**
     * (experimental) Get the set of matching resources of a given type and properties in the CloudFormation template.
     *
     * @param type the type to match in the CloudFormation template.
     * @param props by default, matches all resources with the given type.
     * @experimental
     */
    findResources(type, props = {}) {
        return resource_1.findResources(this.inspector, type, props);
    }
    /**
     * (experimental) Assert that the CloudFormation template matches the given value.
     *
     * @param expected the expected CloudFormation template as key-value pairs.
     * @experimental
     */
    templateMatches(expected) {
        const assertion = assert.matchTemplate(expected);
        assertion.assertOrThrow(this.inspector);
    }
}
exports.TemplateAssertions = TemplateAssertions;
_a = JSII_RTTI_SYMBOL_1;
TemplateAssertions[_a] = { fqn: "@aws-cdk/assertions.TemplateAssertions", version: "1.116.0" };
function toTemplate(stack) {
    const root = stack.node.root;
    if (!core_1.Stage.isStage(root)) {
        throw new Error('unexpected: all stacks must be part of a Stage or an App');
    }
    const assembly = root.synth();
    return assembly.getStackArtifact(stack.artifactId).template;
}
//# sourceMappingURL=data:application/json;base64,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