# This file was auto-generated by Fern from our API Definition.

from ....core.client_wrapper import SyncClientWrapper
import datetime as dt
import typing
from ....types.timezone import Timezone
from ....types.units import Units
from ....core.request_options import RequestOptions
from ....types.daily_weather_response import DailyWeatherResponse
from ....core.datetime_utils import serialize_datetime
from ....core.pydantic_utilities import parse_obj_as
from ....errors.unprocessable_entity_error import UnprocessableEntityError
from ....types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ....core.api_error import ApiError
from ....types.hourly_weather_response import HourlyWeatherResponse
from ....core.client_wrapper import AsyncClientWrapper


class ForecastClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def daily(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DailyWeatherResponse:
        """
        Get daily weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DailyWeatherResponse
            Successful Response

        Examples
        --------
        import datetime

        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.weather.past.forecast.daily(
            latitude=47.6061,
            longitude=-122.3328,
            time=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "past/forecast/daily",
            method="GET",
            params={
                "latitude": latitude,
                "longitude": longitude,
                "time": serialize_datetime(time),
                "timezone": timezone,
                "units": units,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DailyWeatherResponse,
                    parse_obj_as(
                        type_=DailyWeatherResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def hourly(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HourlyWeatherResponse:
        """
        Get hourly weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HourlyWeatherResponse
            Successful Response

        Examples
        --------
        import datetime

        from silurian import Earth

        client = Earth(
            api_key="YOUR_API_KEY",
        )
        client.weather.past.forecast.hourly(
            latitude=47.6061,
            longitude=-122.3328,
            time=datetime.datetime.fromisoformat(
                "2024-01-01 00:00:00+00:00",
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "past/forecast/hourly",
            method="GET",
            params={
                "latitude": latitude,
                "longitude": longitude,
                "time": serialize_datetime(time),
                "timezone": timezone,
                "units": units,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    HourlyWeatherResponse,
                    parse_obj_as(
                        type_=HourlyWeatherResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncForecastClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def daily(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DailyWeatherResponse:
        """
        Get daily weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DailyWeatherResponse
            Successful Response

        Examples
        --------
        import asyncio
        import datetime

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.weather.past.forecast.daily(
                latitude=47.6061,
                longitude=-122.3328,
                time=datetime.datetime.fromisoformat(
                    "2024-01-01 00:00:00+00:00",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "past/forecast/daily",
            method="GET",
            params={
                "latitude": latitude,
                "longitude": longitude,
                "time": serialize_datetime(time),
                "timezone": timezone,
                "units": units,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DailyWeatherResponse,
                    parse_obj_as(
                        type_=DailyWeatherResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def hourly(
        self,
        *,
        latitude: float,
        longitude: float,
        time: dt.datetime,
        timezone: typing.Optional[Timezone] = None,
        units: typing.Optional[Units] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HourlyWeatherResponse:
        """
        Get hourly weather forecast for a specific location and time

        Parameters
        ----------
        latitude : float

        longitude : float

        time : dt.datetime

        timezone : typing.Optional[Timezone]

        units : typing.Optional[Units]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HourlyWeatherResponse
            Successful Response

        Examples
        --------
        import asyncio
        import datetime

        from silurian import AsyncEarth

        client = AsyncEarth(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.weather.past.forecast.hourly(
                latitude=47.6061,
                longitude=-122.3328,
                time=datetime.datetime.fromisoformat(
                    "2024-01-01 00:00:00+00:00",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "past/forecast/hourly",
            method="GET",
            params={
                "latitude": latitude,
                "longitude": longitude,
                "time": serialize_datetime(time),
                "timezone": timezone,
                "units": units,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    HourlyWeatherResponse,
                    parse_obj_as(
                        type_=HourlyWeatherResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
