# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import typing
from .precipitation_type import PrecipitationType
import typing_extensions
from ..core.serialization import FieldMetadata
from .weather_code import WeatherCode
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic


class DailyConditions(UniversalBaseModel):
    timestamp: str
    temperature: typing.Optional[float] = None
    precipitation_accumulation: typing.Optional[float] = None
    precipitation_probability: typing.Optional[int] = None
    precipitation_type: typing.Optional[PrecipitationType] = None
    snowfall_accumulation: typing.Optional[float] = None
    cloud_cover: typing.Optional[int] = None
    humidity: typing.Optional[int] = None
    wind_speed: typing.Optional[float] = None
    wind_direction: typing.Optional[float] = None
    dewpoint_temperature: typing.Optional[float] = None
    pressure: typing.Optional[float] = None
    downward_solar_radiation: typing.Optional[float] = None
    wind_speed_100_m: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="wind_speed_100m")] = None
    wind_direction_100_m: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="wind_direction_100m")
    ] = None
    feels_like_temperature: typing.Optional[float] = None
    weather_code: typing.Optional[WeatherCode] = None
    global_horizontal_irradiation: typing.Optional[float] = None
    direct_normal_irradiation: typing.Optional[float] = None
    diffuse_horizontal_irradiation: typing.Optional[float] = None
    max_temperature: typing.Optional[float] = None
    min_temperature: typing.Optional[float] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
