"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReactTypeDef = exports.ReactComponent = exports.ReactTypeScriptProject = exports.ReactProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const file_1 = require("../file");
const node_project_1 = require("../node-project");
const sample_file_1 = require("../sample-file");
const tasks_1 = require("../tasks");
const typescript_1 = require("../typescript");
const typescript_config_1 = require("../typescript-config");
const util_1 = require("../util");
/**
 * (experimental) React project without TypeScript.
 *
 * @experimental
 * @pjid react
 */
class ReactProject extends node_project_1.NodeProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f;
        super({
            jest: false,
            ...options,
        });
        this.srcdir = (_e = options.srcdir) !== null && _e !== void 0 ? _e : 'src';
        new ReactComponent(this, { typescript: false });
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if ((_f = options.sampleCode) !== null && _f !== void 0 ? _f : true) {
            new ReactSampleCode(this, {
                fileExt: 'jsx',
                srcdir: this.srcdir,
            });
        }
    }
}
exports.ReactProject = ReactProject;
_a = JSII_RTTI_SYMBOL_1;
ReactProject[_a] = { fqn: "projen.web.ReactProject", version: "0.17.91" };
/**
 * (experimental) React project with TypeScript.
 *
 * @experimental
 * @pjid react-ts
 */
class ReactTypeScriptProject extends typescript_1.TypeScriptAppProject {
    /**
     * @experimental
     */
    constructor(options) {
        var _e, _f, _g;
        const defaultOptions = {
            srcdir: 'src',
            eslint: false,
            jest: false,
            tsconfig: {
                include: ['src'],
                compilerOptions: {
                    target: 'es5',
                    lib: [
                        'dom',
                        'dom.iterable',
                        'esnext',
                    ],
                    allowJs: true,
                    skipLibCheck: true,
                    esModuleInterop: true,
                    allowSyntheticDefaultImports: true,
                    strict: true,
                    forceConsistentCasingInFileNames: true,
                    noFallthroughCasesInSwitch: true,
                    module: 'esnext',
                    moduleResolution: typescript_config_1.TypeScriptModuleResolution.NODE,
                    resolveJsonModule: true,
                    isolatedModules: true,
                    noEmit: true,
                    jsx: typescript_config_1.TypeScriptJsxMode.REACT_JSX,
                },
            },
            typescriptVersion: (_e = options.typescriptVersion) !== null && _e !== void 0 ? _e : '^4.0.3',
        };
        // never generate default TypeScript sample code, since this class provides its own
        super(util_1.deepMerge([defaultOptions, options, { sampleCode: false }]));
        this.srcdir = (_f = options.srcdir) !== null && _f !== void 0 ? _f : 'src';
        new ReactComponent(this, { typescript: true });
        this.reactTypeDef = new ReactTypeDef(this, 'react-app-env.d.ts');
        // generate sample code in `src` and `public` if these directories are empty or non-existent.
        if ((_g = options.sampleCode) !== null && _g !== void 0 ? _g : true) {
            new ReactSampleCode(this, {
                fileExt: 'tsx',
                srcdir: this.srcdir,
            });
        }
    }
}
exports.ReactTypeScriptProject = ReactTypeScriptProject;
_b = JSII_RTTI_SYMBOL_1;
ReactTypeScriptProject[_b] = { fqn: "projen.web.ReactTypeScriptProject", version: "0.17.91" };
/**
 * @experimental
 */
class ReactComponent extends component_1.Component {
    /**
     * @experimental
     */
    constructor(project, options) {
        var _e, _f;
        super(project);
        this.typescript = (_e = options.typescript) !== null && _e !== void 0 ? _e : false;
        // No compile for react app
        project.compileTask.reset();
        project.addDeps('react', 'react-dom', 'react-scripts@^4.0.0', 'web-vitals');
        project.addDevDeps('@testing-library/jest-dom', '@testing-library/react', '@testing-library/user-event');
        if (this.typescript) {
            project.addDevDeps('@types/jest', '@types/node', '@types/react', '@types/react-dom');
        }
        // Create React App CLI commands, see: https://create-react-app.dev/docs/available-scripts/
        project.addTask('dev', {
            description: 'Starts the react application',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'react-scripts start',
        });
        project.addTask('build', {
            description: 'Creates an optimized production build of your React application',
            category: tasks_1.TaskCategory.BUILD,
            exec: 'react-scripts build',
        });
        project.addTask('eject', {
            description: 'Ejects your React application from react-scripts',
            category: tasks_1.TaskCategory.MISC,
            exec: 'react-scripts eject',
        });
        project.addTask('test', {
            description: 'Runs tests',
            category: tasks_1.TaskCategory.TEST,
            exec: 'react-scripts test',
        });
        (_f = project.npmignore) === null || _f === void 0 ? void 0 : _f.exclude('# Build', '/build');
        project.gitignore.exclude('# Build', '/build');
        project.package.addField('eslintConfig', {
            extends: [
                'react-app',
                'react-app/jest',
            ],
        });
        project.package.addField('browserslist', {
            production: [
                '>0.2%',
                'not dead',
                'not op_mini all',
            ],
            development: [
                'last 1 chrome version',
                'last 1 firefox version',
                'last 1 safari version',
            ],
        });
    }
}
exports.ReactComponent = ReactComponent;
_c = JSII_RTTI_SYMBOL_1;
ReactComponent[_c] = { fqn: "projen.web.ReactComponent", version: "0.17.91" };
class ReactSampleCode extends component_1.Component {
    constructor(project, options) {
        var _e;
        super(project);
        this.fileExt = (_e = options.fileExt) !== null && _e !== void 0 ? _e : 'jsx';
        this.srcdir = options.srcdir;
        const logoSvg = [
            '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3">',
            '    <g fill="#61DAFB">',
            '        <path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/>',
            '        <circle cx="420.9" cy="296.5" r="45.7"/>',
            '        <path d="M520.5 78.1z"/>',
            '    </g>',
            '</svg>',
            '',
        ];
        const appJsx = [
            "import logo from './logo.svg';",
            "import './App.css'",
            '',
            'function App() {',
            '  return (',
            '   <div className="App">',
            '      <header className="App-header">',
            '        <img src={logo} className="App-logo" alt="logo" />',
            '        <p>',
            `          Edit <code>src/App.${this.fileExt}</code> and save to reload.`,
            '        </p>',
            '        <a className="App-link"',
            '          href="https://reactjs.org"',
            '          target="_blank"',
            '          rel="noopener noreferrer"',
            '        >',
            '          Learn React',
            '        </a>',
            '      </header>',
            '    </div>',
            '  );',
            '}',
            '',
            'export default App;',
            '',
        ];
        const appCss = [
            '.App {',
            '  text-align: center;',
            '}',
            '',
            '.App-logo {',
            '  height: 40vmin;',
            '  pointer-events: none;',
            '}',
            '',
            '@media (prefers-reduced-motion: no-preference) {',
            '  .App-logo {',
            '    animation: App-logo-spin infinite 20s linear;',
            '  }',
            '}',
            '',
            '.App-header {',
            '  background-color: #282c34;',
            '  min-height: 100vh;',
            '  display: flex;',
            '  flex-direction: column;',
            '  align-items: center;',
            '  justify-content: center;',
            '  font-size: calc(10px + 2vmin);',
            '  color: white;',
            '}',
            '',
            '.App-link {',
            '  color: #61dafb;',
            '}',
            '',
            '@keyframes App-logo-spin {',
            '  from {',
            '    transform: rotate(0deg);',
            '  }',
            '  to {',
            '    transform: rotate(360deg);',
            '  }',
            '}',
            '',
        ];
        const appTestJsx = [
            "import React from 'react';",
            "import { render, screen } from '@testing-library/react';",
            "import App from './App';",
            '',
            "test('renders learn react link', () => {",
            '  render(<App />);',
            '  const linkElement = screen.getByText(/learn react/i);',
            '  expect(linkElement).toBeInTheDocument();',
            '});',
            '',
        ];
        const indexJsx = [
            "import React from 'react';",
            "import ReactDOM from 'react-dom';",
            "import './index.css';",
            "import App from './App';",
            "import reportWebVitals from './reportWebVitals';",
            '',
            'ReactDOM.render(',
            '  <React.StrictMode>',
            '    <App />',
            '  </React.StrictMode>,',
            "  document.getElementById('root')",
            ');',
            '',
            '// If you want to start measuring performance in your app, pass a function',
            '// to log results (for example: reportWebVitals(console.log))',
            '// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals',
            'reportWebVitals();',
            '',
        ];
        const indexCss = [
            'body {',
            '  margin: 0;',
            "  font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Oxygen',",
            "    'Ubuntu', 'Cantarell', 'Fira Sans', 'Droid Sans', 'Helvetica Neue',",
            '    sans-serif;',
            '  -webkit-font-smoothing: antialiased;',
            '  -moz-osx-font-smoothing: grayscale;',
            '}',
            '',
            'code {',
            "  font-family: source-code-pro, Menlo, Monaco, Consolas, 'Courier New',",
            '    monospace;',
            '}',
            '',
        ];
        const reportWebVitalsJs = [
            "import { ReportHandler } from 'web-vitals';",
            '',
            'const reportWebVitals = (onPerfEntry?: ReportHandler) => {',
            '  if (onPerfEntry && onPerfEntry instanceof Function) {',
            "    import('web-vitals').then(({ getCLS, getFID, getFCP, getLCP, getTTFB }) => {",
            '      getCLS(onPerfEntry);',
            '      getFID(onPerfEntry);',
            '      getFCP(onPerfEntry);',
            '      getLCP(onPerfEntry);',
            '      getTTFB(onPerfEntry);',
            '    });',
            '  }',
            '}',
            '',
            'export default reportWebVitals;',
        ];
        const setupTestsJs = [
            '// jest-dom adds custom jest matchers for asserting on DOM nodes.',
            '// allows you to do things like:',
            '// expect(element).toHaveTextContent(/react/i)',
            '// learn more: https://github.com/testing-library/jest-dom',
            "import '@testing-library/jest-dom';",
            '',
        ];
        // js/ts not jsx/tsx
        const fileExtWithoutX = this.fileExt.replace('x', '');
        new sample_file_1.SampleDir(project, this.srcdir, {
            files: {
                'logo.svg': logoSvg.join('\n'),
                ['App.' + this.fileExt]: appJsx.join('\n'),
                ['App.test.' + this.fileExt]: appTestJsx.join('\n'),
                'App.css': appCss.join('\n'),
                ['index.' + this.fileExt]: indexJsx.join('\n'),
                'index.css': indexCss.join('\n'),
                ['reportWebVitals.' + fileExtWithoutX]: reportWebVitalsJs.join('\n'),
                ['setupTests.' + fileExtWithoutX]: setupTestsJs.join('\n'),
            },
        });
        const indexHtml = [
            '<!DOCTYPE html>',
            '<html lang="en">',
            '  <head>',
            '    <meta charset="utf-8" />',
            '    <link rel="icon" href="%PUBLIC_URL%/favicon.ico" />',
            '    <meta name = "viewport" content = "width=device-width, initial-scale=1" />',
            '    <meta name="theme-color" content = "#000000" />',
            '    <meta name="description" content = "Web site created using create-react-app" />',
            '    <link rel="apple-touch-icon" href = "%PUBLIC_URL%/logo192.png" />',
            '    <!--',
            '      manifest.json provides metadata used when your web app is installed on a',
            "      user's mobile device or desktop. See https://developers.google.com/web/fundamentals/web-app-manifest/",
            '    -->',
            '    <link rel="manifest" href = "%PUBLIC_URL%/manifest.json" />',
            '    <!--',
            '      Notice the use of % PUBLIC_URL % in the tags above.',
            '      It will be replaced with the URL of the`public` folder during the build.',
            '      Only files inside the`public` folder can be referenced from the HTML.',
            '',
            '      Unlike "/favicon.ico" or "favicon.ico", "%PUBLIC_URL%/favicon.ico" will',
            '      work correctly both with client - side routing and a non - root public URL.',
            '      Learn how to configure a non-root public URL by running`npm run build`.',
            '    -->',
            '    <title>React App </title>',
            '  </head>',
            '  <body>',
            '    <noscript>You need to enable JavaScript to run this app.</noscript>',
            '    <div id="root"> </div>',
            '    <!--',
            '      This HTML file is a template.',
            '      If you open it directly in the browser, you will see an empty page.',
            '      You can add webfonts, meta tags, or analytics to this file.',
            '      The build step will place the bundled scripts into the <body> tag.',
            '',
            '      To begin the development, run `npm start` or `yarn start`.',
            '      To create a production bundle, use `npm run build` or `yarn build`.',
            '    -->',
            '  </body>',
            '</html>',
        ];
        const publicManifest = {
            short_name: 'React App',
            name: 'Create React App Sample',
            icons: [],
            start_url: '.',
            display: 'standalone',
            theme_color: '#000000',
            background_color: '#ffffff',
        };
        const robotTxt = [
            '# https://www.robotstxt.org/robotstxt.html',
            'User-agent: *',
            'Disallow:',
        ];
        new sample_file_1.SampleDir(project, 'public', {
            files: {
                'index.html': indexHtml.join('\n'),
                'manifest.json': JSON.stringify(publicManifest, undefined, 2),
                'robots.txt': robotTxt.join('\n'),
            },
        });
    }
}
/**
 * @experimental
 */
class ReactTypeDef extends file_1.FileBase {
    /**
     * @experimental
     */
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
    }
    /**
     * (experimental) Implemented by derived classes and returns the contents of the file to emit.
     *
     * @experimental
     */
    synthesizeContent(_) {
        return [
            '/// <reference types="react-scripts" />',
        ].join('\n');
    }
}
exports.ReactTypeDef = ReactTypeDef;
_d = JSII_RTTI_SYMBOL_1;
ReactTypeDef[_d] = { fqn: "projen.web.ReactTypeDef", version: "0.17.91" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVhY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvd2ViL3JlYWN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNENBQXlDO0FBQ3pDLGtDQUErRDtBQUMvRCxrREFBa0U7QUFDbEUsZ0RBQTJDO0FBQzNDLG9DQUF3QztBQUN4Qyw4Q0FBK0U7QUFDL0UsNERBQXFGO0FBQ3JGLGtDQUFvQzs7Ozs7OztBQXVCcEMsTUFBYSxZQUFhLFNBQVEsMEJBQVc7Ozs7SUFPM0MsWUFBWSxPQUE0Qjs7UUFDdEMsS0FBSyxDQUFDO1lBQ0osSUFBSSxFQUFFLEtBQUs7WUFDWCxHQUFHLE9BQU87U0FDWCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsTUFBTSxTQUFHLE9BQU8sQ0FBQyxNQUFNLG1DQUFJLEtBQUssQ0FBQztRQUV0QyxJQUFJLGNBQWMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUVoRCw2RkFBNkY7UUFDN0YsVUFBSSxPQUFPLENBQUMsVUFBVSxtQ0FBSSxJQUFJLEVBQUU7WUFDOUIsSUFBSSxlQUFlLENBQUMsSUFBSSxFQUFFO2dCQUN4QixPQUFPLEVBQUUsS0FBSztnQkFDZCxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07YUFDcEIsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDOztBQXhCSCxvQ0F5QkM7Ozs7Ozs7OztBQU9ELE1BQWEsc0JBQXVCLFNBQVEsaUNBQW9COzs7O0lBYTlELFlBQVksT0FBc0M7O1FBQ2hELE1BQU0sY0FBYyxHQUFHO1lBQ3JCLE1BQU0sRUFBRSxLQUFLO1lBQ2IsTUFBTSxFQUFFLEtBQUs7WUFDYixJQUFJLEVBQUUsS0FBSztZQUNYLFFBQVEsRUFBRTtnQkFDUixPQUFPLEVBQUUsQ0FBQyxLQUFLLENBQUM7Z0JBQ2hCLGVBQWUsRUFBRTtvQkFDZixNQUFNLEVBQUUsS0FBSztvQkFDYixHQUFHLEVBQUU7d0JBQ0gsS0FBSzt3QkFDTCxjQUFjO3dCQUNkLFFBQVE7cUJBQ1Q7b0JBQ0QsT0FBTyxFQUFFLElBQUk7b0JBQ2IsWUFBWSxFQUFFLElBQUk7b0JBQ2xCLGVBQWUsRUFBRSxJQUFJO29CQUNyQiw0QkFBNEIsRUFBRSxJQUFJO29CQUNsQyxNQUFNLEVBQUUsSUFBSTtvQkFDWixnQ0FBZ0MsRUFBRSxJQUFJO29CQUN0QywwQkFBMEIsRUFBRSxJQUFJO29CQUNoQyxNQUFNLEVBQUUsUUFBUTtvQkFDaEIsZ0JBQWdCLEVBQUUsOENBQTBCLENBQUMsSUFBSTtvQkFDakQsaUJBQWlCLEVBQUUsSUFBSTtvQkFDdkIsZUFBZSxFQUFFLElBQUk7b0JBQ3JCLE1BQU0sRUFBRSxJQUFJO29CQUNaLEdBQUcsRUFBRSxxQ0FBaUIsQ0FBQyxTQUFTO2lCQUNqQzthQUNGO1lBQ0QsaUJBQWlCLFFBQUUsT0FBTyxDQUFDLGlCQUFpQixtQ0FBSSxRQUFRO1NBQ3pELENBQUM7UUFFRixtRkFBbUY7UUFDbkYsS0FBSyxDQUFDLGdCQUFTLENBQUMsQ0FBQyxjQUFjLEVBQUUsT0FBTyxFQUFFLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQTZCLENBQUMsQ0FBQztRQUUvRixJQUFJLENBQUMsTUFBTSxTQUFHLE9BQU8sQ0FBQyxNQUFNLG1DQUFJLEtBQUssQ0FBQztRQUV0QyxJQUFJLGNBQWMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxVQUFVLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztRQUUvQyxJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksWUFBWSxDQUFDLElBQUksRUFBRSxvQkFBb0IsQ0FBQyxDQUFDO1FBRWpFLDZGQUE2RjtRQUM3RixVQUFJLE9BQU8sQ0FBQyxVQUFVLG1DQUFJLElBQUksRUFBRTtZQUM5QixJQUFJLGVBQWUsQ0FBQyxJQUFJLEVBQUU7Z0JBQ3hCLE9BQU8sRUFBRSxLQUFLO2dCQUNkLE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTTthQUNwQixDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7O0FBN0RILHdEQThEQzs7Ozs7O0FBV0QsTUFBYSxjQUFlLFNBQVEscUJBQVM7Ozs7SUFHM0MsWUFBWSxPQUFvQixFQUFFLE9BQThCOztRQUM5RCxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFFZixJQUFJLENBQUMsVUFBVSxTQUFHLE9BQU8sQ0FBQyxVQUFVLG1DQUFJLEtBQUssQ0FBQztRQUU5QywyQkFBMkI7UUFDM0IsT0FBTyxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUU1QixPQUFPLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxXQUFXLEVBQUUsc0JBQXNCLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFDNUUsT0FBTyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsRUFBRSx3QkFBd0IsRUFBRSw2QkFBNkIsQ0FBQyxDQUFDO1FBQ3pHLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUNuQixPQUFPLENBQUMsVUFBVSxDQUFDLGFBQWEsRUFBRSxhQUFhLEVBQUUsY0FBYyxFQUFFLGtCQUFrQixDQUFDLENBQUM7U0FDdEY7UUFFRCwyRkFBMkY7UUFDM0YsT0FBTyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUU7WUFDckIsV0FBVyxFQUFFLDhCQUE4QjtZQUMzQyxRQUFRLEVBQUUsb0JBQVksQ0FBQyxLQUFLO1lBQzVCLElBQUksRUFBRSxxQkFBcUI7U0FDNUIsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUU7WUFDdkIsV0FBVyxFQUFFLGlFQUFpRTtZQUM5RSxRQUFRLEVBQUUsb0JBQVksQ0FBQyxLQUFLO1lBQzVCLElBQUksRUFBRSxxQkFBcUI7U0FDNUIsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUU7WUFDdkIsV0FBVyxFQUFFLGtEQUFrRDtZQUMvRCxRQUFRLEVBQUUsb0JBQVksQ0FBQyxJQUFJO1lBQzNCLElBQUksRUFBRSxxQkFBcUI7U0FDNUIsQ0FBQyxDQUFDO1FBRUgsT0FBTyxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUU7WUFDdEIsV0FBVyxFQUFFLFlBQVk7WUFDekIsUUFBUSxFQUFFLG9CQUFZLENBQUMsSUFBSTtZQUMzQixJQUFJLEVBQUUsb0JBQW9CO1NBQzNCLENBQUMsQ0FBQztRQUVILE1BQUEsT0FBTyxDQUFDLFNBQVMsMENBQUUsT0FBTyxDQUFDLFNBQVMsRUFBRSxRQUFRLEVBQUU7UUFDaEQsT0FBTyxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsU0FBUyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBRS9DLE9BQU8sQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLGNBQWMsRUFBRTtZQUN2QyxPQUFPLEVBQUU7Z0JBQ1AsV0FBVztnQkFDWCxnQkFBZ0I7YUFDakI7U0FDRixDQUFDLENBQUM7UUFFSCxPQUFPLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxjQUFjLEVBQUU7WUFDdkMsVUFBVSxFQUFFO2dCQUNWLE9BQU87Z0JBQ1AsVUFBVTtnQkFDVixpQkFBaUI7YUFDbEI7WUFDRCxXQUFXLEVBQUU7Z0JBQ1gsdUJBQXVCO2dCQUN2Qix3QkFBd0I7Z0JBQ3hCLHVCQUF1QjthQUN4QjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBaEVILHdDQWlFQzs7O0FBZ0JELE1BQU0sZUFBZ0IsU0FBUSxxQkFBUztJQUlyQyxZQUFZLE9BQW9CLEVBQUUsT0FBK0I7O1FBQy9ELEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUVmLElBQUksQ0FBQyxPQUFPLFNBQUcsT0FBTyxDQUFDLE9BQU8sbUNBQUksS0FBSyxDQUFDO1FBQ3hDLElBQUksQ0FBQyxNQUFNLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQztRQUU3QixNQUFNLE9BQU8sR0FBRztZQUNkLG9FQUFvRTtZQUNwRSx3QkFBd0I7WUFDeEIsbzdFQUFvN0U7WUFDcDdFLGtEQUFrRDtZQUNsRCxrQ0FBa0M7WUFDbEMsVUFBVTtZQUNWLFFBQVE7WUFDUixFQUFFO1NBQ0gsQ0FBQztRQUVGLE1BQU0sTUFBTSxHQUFHO1lBQ2IsZ0NBQWdDO1lBQ2hDLG9CQUFvQjtZQUNwQixFQUFFO1lBQ0Ysa0JBQWtCO1lBQ2xCLFlBQVk7WUFDWiwwQkFBMEI7WUFDMUIsdUNBQXVDO1lBQ3ZDLDREQUE0RDtZQUM1RCxhQUFhO1lBQ2IsZ0NBQWdDLElBQUksQ0FBQyxPQUFPLDZCQUE2QjtZQUN6RSxjQUFjO1lBQ2QsaUNBQWlDO1lBQ2pDLHNDQUFzQztZQUN0QywyQkFBMkI7WUFDM0IscUNBQXFDO1lBQ3JDLFdBQVc7WUFDWCx1QkFBdUI7WUFDdkIsY0FBYztZQUNkLGlCQUFpQjtZQUNqQixZQUFZO1lBQ1osTUFBTTtZQUNOLEdBQUc7WUFDSCxFQUFFO1lBQ0YscUJBQXFCO1lBQ3JCLEVBQUU7U0FDSCxDQUFDO1FBRUYsTUFBTSxNQUFNLEdBQUc7WUFDYixRQUFRO1lBQ1IsdUJBQXVCO1lBQ3ZCLEdBQUc7WUFDSCxFQUFFO1lBQ0YsYUFBYTtZQUNiLG1CQUFtQjtZQUNuQix5QkFBeUI7WUFDekIsR0FBRztZQUNILEVBQUU7WUFDRixrREFBa0Q7WUFDbEQsZUFBZTtZQUNmLG1EQUFtRDtZQUNuRCxLQUFLO1lBQ0wsR0FBRztZQUNILEVBQUU7WUFDRixlQUFlO1lBQ2YsOEJBQThCO1lBQzlCLHNCQUFzQjtZQUN0QixrQkFBa0I7WUFDbEIsMkJBQTJCO1lBQzNCLHdCQUF3QjtZQUN4Qiw0QkFBNEI7WUFDNUIsa0NBQWtDO1lBQ2xDLGlCQUFpQjtZQUNqQixHQUFHO1lBQ0gsRUFBRTtZQUNGLGFBQWE7WUFDYixtQkFBbUI7WUFDbkIsR0FBRztZQUNILEVBQUU7WUFDRiw0QkFBNEI7WUFDNUIsVUFBVTtZQUNWLDhCQUE4QjtZQUM5QixLQUFLO1lBQ0wsUUFBUTtZQUNSLGdDQUFnQztZQUNoQyxLQUFLO1lBQ0wsR0FBRztZQUNILEVBQUU7U0FDSCxDQUFDO1FBRUYsTUFBTSxVQUFVLEdBQUc7WUFDakIsNEJBQTRCO1lBQzVCLDBEQUEwRDtZQUMxRCwwQkFBMEI7WUFDMUIsRUFBRTtZQUNGLDBDQUEwQztZQUMxQyxvQkFBb0I7WUFDcEIseURBQXlEO1lBQ3pELDRDQUE0QztZQUM1QyxLQUFLO1lBQ0wsRUFBRTtTQUNILENBQUM7UUFFRixNQUFNLFFBQVEsR0FBRztZQUNmLDRCQUE0QjtZQUM1QixtQ0FBbUM7WUFDbkMsdUJBQXVCO1lBQ3ZCLDBCQUEwQjtZQUMxQixrREFBa0Q7WUFDbEQsRUFBRTtZQUNGLGtCQUFrQjtZQUNsQixzQkFBc0I7WUFDdEIsYUFBYTtZQUNiLHdCQUF3QjtZQUN4QixtQ0FBbUM7WUFDbkMsSUFBSTtZQUNKLEVBQUU7WUFDRiw0RUFBNEU7WUFDNUUsK0RBQStEO1lBQy9ELDRFQUE0RTtZQUM1RSxvQkFBb0I7WUFDcEIsRUFBRTtTQUNILENBQUM7UUFFRixNQUFNLFFBQVEsR0FBRztZQUNmLFFBQVE7WUFDUixjQUFjO1lBQ2QsbUZBQW1GO1lBQ25GLHlFQUF5RTtZQUN6RSxpQkFBaUI7WUFDakIsd0NBQXdDO1lBQ3hDLHVDQUF1QztZQUN2QyxHQUFHO1lBQ0gsRUFBRTtZQUNGLFFBQVE7WUFDUix5RUFBeUU7WUFDekUsZ0JBQWdCO1lBQ2hCLEdBQUc7WUFDSCxFQUFFO1NBQ0gsQ0FBQztRQUVGLE1BQU0saUJBQWlCLEdBQUc7WUFDeEIsNkNBQTZDO1lBQzdDLEVBQUU7WUFDRiw0REFBNEQ7WUFDNUQseURBQXlEO1lBQ3pELGtGQUFrRjtZQUNsRiw0QkFBNEI7WUFDNUIsNEJBQTRCO1lBQzVCLDRCQUE0QjtZQUM1Qiw0QkFBNEI7WUFDNUIsNkJBQTZCO1lBQzdCLFNBQVM7WUFDVCxLQUFLO1lBQ0wsR0FBRztZQUNILEVBQUU7WUFDRixpQ0FBaUM7U0FDbEMsQ0FBQztRQUVGLE1BQU0sWUFBWSxHQUFHO1lBQ25CLG1FQUFtRTtZQUNuRSxrQ0FBa0M7WUFDbEMsZ0RBQWdEO1lBQ2hELDREQUE0RDtZQUM1RCxxQ0FBcUM7WUFDckMsRUFBRTtTQUNILENBQUM7UUFFRixvQkFBb0I7UUFDcEIsTUFBTSxlQUFlLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRXRELElBQUksdUJBQVMsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLE1BQU0sRUFBRTtZQUNsQyxLQUFLLEVBQUU7Z0JBQ0wsVUFBVSxFQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2dCQUM5QixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7Z0JBQzFDLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxVQUFVLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztnQkFDbkQsU0FBUyxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2dCQUM1QixDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLEVBQUUsUUFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7Z0JBQzlDLFdBQVcsRUFBRSxRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztnQkFDaEMsQ0FBQyxrQkFBa0IsR0FBRyxlQUFlLENBQUMsRUFBRSxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2dCQUNwRSxDQUFDLGFBQWEsR0FBRyxlQUFlLENBQUMsRUFBRSxZQUFZLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQzthQUMzRDtTQUNGLENBQUMsQ0FBQztRQUVILE1BQU0sU0FBUyxHQUFHO1lBQ2hCLGlCQUFpQjtZQUNqQixrQkFBa0I7WUFDbEIsVUFBVTtZQUNWLDhCQUE4QjtZQUM5Qix5REFBeUQ7WUFDekQsZ0ZBQWdGO1lBQ2hGLHFEQUFxRDtZQUNyRCxxRkFBcUY7WUFDckYsdUVBQXVFO1lBQ3ZFLFVBQVU7WUFDVixnRkFBZ0Y7WUFDaEYsNkdBQTZHO1lBQzdHLFNBQVM7WUFDVCxpRUFBaUU7WUFDakUsVUFBVTtZQUNWLDJEQUEyRDtZQUMzRCxnRkFBZ0Y7WUFDaEYsNkVBQTZFO1lBQzdFLEVBQUU7WUFDRiwrRUFBK0U7WUFDL0UsbUZBQW1GO1lBQ25GLCtFQUErRTtZQUMvRSxTQUFTO1lBQ1QsK0JBQStCO1lBQy9CLFdBQVc7WUFDWCxVQUFVO1lBQ1YseUVBQXlFO1lBQ3pFLDRCQUE0QjtZQUM1QixVQUFVO1lBQ1YscUNBQXFDO1lBQ3JDLDJFQUEyRTtZQUMzRSxtRUFBbUU7WUFDbkUsMEVBQTBFO1lBQzFFLEVBQUU7WUFDRixrRUFBa0U7WUFDbEUsMkVBQTJFO1lBQzNFLFNBQVM7WUFDVCxXQUFXO1lBQ1gsU0FBUztTQUNWLENBQUM7UUFFRixNQUFNLGNBQWMsR0FBRztZQUNyQixVQUFVLEVBQUUsV0FBVztZQUN2QixJQUFJLEVBQUUseUJBQXlCO1lBQy9CLEtBQUssRUFBRSxFQUFFO1lBQ1QsU0FBUyxFQUFFLEdBQUc7WUFDZCxPQUFPLEVBQUUsWUFBWTtZQUNyQixXQUFXLEVBQUUsU0FBUztZQUN0QixnQkFBZ0IsRUFBRSxTQUFTO1NBQzVCLENBQUM7UUFFRixNQUFNLFFBQVEsR0FBRztZQUNmLDRDQUE0QztZQUM1QyxlQUFlO1lBQ2YsV0FBVztTQUNaLENBQUM7UUFFRixJQUFJLHVCQUFTLENBQUMsT0FBTyxFQUFFLFFBQVEsRUFBRTtZQUMvQixLQUFLLEVBQUU7Z0JBQ0wsWUFBWSxFQUFFLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2dCQUNsQyxlQUFlLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxjQUFjLEVBQUUsU0FBUyxFQUFFLENBQUMsQ0FBQztnQkFDN0QsWUFBWSxFQUFFLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2FBQ2xDO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGOzs7O0FBSUQsTUFBYSxZQUFhLFNBQVEsZUFBUTs7OztJQUN4QyxZQUFZLE9BQStCLEVBQUUsUUFBZ0IsRUFBRSxVQUErQixFQUFFO1FBQzlGLEtBQUssQ0FBQyxPQUFPLEVBQUUsUUFBUSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ3BDLENBQUM7Ozs7OztJQUVTLGlCQUFpQixDQUFDLENBQVk7UUFDdEMsT0FBTztZQUNMLHlDQUF5QztTQUMxQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUNmLENBQUM7O0FBVEgsb0NBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tICcuLi9jb21wb25lbnQnO1xuaW1wb3J0IHsgRmlsZUJhc2UsIEZpbGVCYXNlT3B0aW9ucywgSVJlc29sdmVyIH0gZnJvbSAnLi4vZmlsZSc7XG5pbXBvcnQgeyBOb2RlUHJvamVjdCwgTm9kZVByb2plY3RPcHRpb25zIH0gZnJvbSAnLi4vbm9kZS1wcm9qZWN0JztcbmltcG9ydCB7IFNhbXBsZURpciB9IGZyb20gJy4uL3NhbXBsZS1maWxlJztcbmltcG9ydCB7IFRhc2tDYXRlZ29yeSB9IGZyb20gJy4uL3Rhc2tzJztcbmltcG9ydCB7IFR5cGVTY3JpcHRBcHBQcm9qZWN0LCBUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMgfSBmcm9tICcuLi90eXBlc2NyaXB0JztcbmltcG9ydCB7IFR5cGVTY3JpcHRKc3hNb2RlLCBUeXBlU2NyaXB0TW9kdWxlUmVzb2x1dGlvbiB9IGZyb20gJy4uL3R5cGVzY3JpcHQtY29uZmlnJztcbmltcG9ydCB7IGRlZXBNZXJnZSB9IGZyb20gJy4uL3V0aWwnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFJlYWN0VHlwZVNjcmlwdFByb2plY3RPcHRpb25zIGV4dGVuZHMgVHlwZVNjcmlwdFByb2plY3RPcHRpb25zIHsgfVxuXG5leHBvcnQgaW50ZXJmYWNlIFJlYWN0UHJvamVjdE9wdGlvbnMgZXh0ZW5kcyBOb2RlUHJvamVjdE9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3JjZGlyPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc2FtcGxlQ29kZT86IGJvb2xlYW47XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUmVhY3RQcm9qZWN0IGV4dGVuZHMgTm9kZVByb2plY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHNyY2Rpcjogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKG9wdGlvbnM6IFJlYWN0UHJvamVjdE9wdGlvbnMpIHtcbiAgICBzdXBlcih7XG4gICAgICBqZXN0OiBmYWxzZSxcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgfSk7XG5cbiAgICB0aGlzLnNyY2RpciA9IG9wdGlvbnMuc3JjZGlyID8/ICdzcmMnO1xuXG4gICAgbmV3IFJlYWN0Q29tcG9uZW50KHRoaXMsIHsgdHlwZXNjcmlwdDogZmFsc2UgfSk7XG5cbiAgICAvLyBnZW5lcmF0ZSBzYW1wbGUgY29kZSBpbiBgc3JjYCBhbmQgYHB1YmxpY2AgaWYgdGhlc2UgZGlyZWN0b3JpZXMgYXJlIGVtcHR5IG9yIG5vbi1leGlzdGVudC5cbiAgICBpZiAob3B0aW9ucy5zYW1wbGVDb2RlID8/IHRydWUpIHtcbiAgICAgIG5ldyBSZWFjdFNhbXBsZUNvZGUodGhpcywge1xuICAgICAgICBmaWxlRXh0OiAnanN4JyxcbiAgICAgICAgc3JjZGlyOiB0aGlzLnNyY2RpcixcbiAgICAgIH0pO1xuICAgIH1cbiAgfVxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFJlYWN0VHlwZVNjcmlwdFByb2plY3QgZXh0ZW5kcyBUeXBlU2NyaXB0QXBwUHJvamVjdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHNyY2Rpcjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHJlYWN0VHlwZURlZjogUmVhY3RUeXBlRGVmO1xuXG4gIGNvbnN0cnVjdG9yKG9wdGlvbnM6IFJlYWN0VHlwZVNjcmlwdFByb2plY3RPcHRpb25zKSB7XG4gICAgY29uc3QgZGVmYXVsdE9wdGlvbnMgPSB7XG4gICAgICBzcmNkaXI6ICdzcmMnLFxuICAgICAgZXNsaW50OiBmYWxzZSxcbiAgICAgIGplc3Q6IGZhbHNlLFxuICAgICAgdHNjb25maWc6IHtcbiAgICAgICAgaW5jbHVkZTogWydzcmMnXSxcbiAgICAgICAgY29tcGlsZXJPcHRpb25zOiB7XG4gICAgICAgICAgdGFyZ2V0OiAnZXM1JyxcbiAgICAgICAgICBsaWI6IFtcbiAgICAgICAgICAgICdkb20nLFxuICAgICAgICAgICAgJ2RvbS5pdGVyYWJsZScsXG4gICAgICAgICAgICAnZXNuZXh0JyxcbiAgICAgICAgICBdLFxuICAgICAgICAgIGFsbG93SnM6IHRydWUsXG4gICAgICAgICAgc2tpcExpYkNoZWNrOiB0cnVlLFxuICAgICAgICAgIGVzTW9kdWxlSW50ZXJvcDogdHJ1ZSxcbiAgICAgICAgICBhbGxvd1N5bnRoZXRpY0RlZmF1bHRJbXBvcnRzOiB0cnVlLFxuICAgICAgICAgIHN0cmljdDogdHJ1ZSxcbiAgICAgICAgICBmb3JjZUNvbnNpc3RlbnRDYXNpbmdJbkZpbGVOYW1lczogdHJ1ZSxcbiAgICAgICAgICBub0ZhbGx0aHJvdWdoQ2FzZXNJblN3aXRjaDogdHJ1ZSxcbiAgICAgICAgICBtb2R1bGU6ICdlc25leHQnLFxuICAgICAgICAgIG1vZHVsZVJlc29sdXRpb246IFR5cGVTY3JpcHRNb2R1bGVSZXNvbHV0aW9uLk5PREUsXG4gICAgICAgICAgcmVzb2x2ZUpzb25Nb2R1bGU6IHRydWUsXG4gICAgICAgICAgaXNvbGF0ZWRNb2R1bGVzOiB0cnVlLFxuICAgICAgICAgIG5vRW1pdDogdHJ1ZSxcbiAgICAgICAgICBqc3g6IFR5cGVTY3JpcHRKc3hNb2RlLlJFQUNUX0pTWCxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgICB0eXBlc2NyaXB0VmVyc2lvbjogb3B0aW9ucy50eXBlc2NyaXB0VmVyc2lvbiA/PyAnXjQuMC4zJyxcbiAgICB9O1xuXG4gICAgLy8gbmV2ZXIgZ2VuZXJhdGUgZGVmYXVsdCBUeXBlU2NyaXB0IHNhbXBsZSBjb2RlLCBzaW5jZSB0aGlzIGNsYXNzIHByb3ZpZGVzIGl0cyBvd25cbiAgICBzdXBlcihkZWVwTWVyZ2UoW2RlZmF1bHRPcHRpb25zLCBvcHRpb25zLCB7IHNhbXBsZUNvZGU6IGZhbHNlIH1dKSBhcyBUeXBlU2NyaXB0UHJvamVjdE9wdGlvbnMpO1xuXG4gICAgdGhpcy5zcmNkaXIgPSBvcHRpb25zLnNyY2RpciA/PyAnc3JjJztcblxuICAgIG5ldyBSZWFjdENvbXBvbmVudCh0aGlzLCB7IHR5cGVzY3JpcHQ6IHRydWUgfSk7XG5cbiAgICB0aGlzLnJlYWN0VHlwZURlZiA9IG5ldyBSZWFjdFR5cGVEZWYodGhpcywgJ3JlYWN0LWFwcC1lbnYuZC50cycpO1xuXG4gICAgLy8gZ2VuZXJhdGUgc2FtcGxlIGNvZGUgaW4gYHNyY2AgYW5kIGBwdWJsaWNgIGlmIHRoZXNlIGRpcmVjdG9yaWVzIGFyZSBlbXB0eSBvciBub24tZXhpc3RlbnQuXG4gICAgaWYgKG9wdGlvbnMuc2FtcGxlQ29kZSA/PyB0cnVlKSB7XG4gICAgICBuZXcgUmVhY3RTYW1wbGVDb2RlKHRoaXMsIHtcbiAgICAgICAgZmlsZUV4dDogJ3RzeCcsXG4gICAgICAgIHNyY2RpcjogdGhpcy5zcmNkaXIsXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBSZWFjdENvbXBvbmVudE9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0eXBlc2NyaXB0PzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNsYXNzIFJlYWN0Q29tcG9uZW50IGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgcHJpdmF0ZSByZWFkb25seSB0eXBlc2NyaXB0OiBib29sZWFuO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IE5vZGVQcm9qZWN0LCBvcHRpb25zOiBSZWFjdENvbXBvbmVudE9wdGlvbnMpIHtcbiAgICBzdXBlcihwcm9qZWN0KTtcblxuICAgIHRoaXMudHlwZXNjcmlwdCA9IG9wdGlvbnMudHlwZXNjcmlwdCA/PyBmYWxzZTtcblxuICAgIC8vIE5vIGNvbXBpbGUgZm9yIHJlYWN0IGFwcFxuICAgIHByb2plY3QuY29tcGlsZVRhc2sucmVzZXQoKTtcblxuICAgIHByb2plY3QuYWRkRGVwcygncmVhY3QnLCAncmVhY3QtZG9tJywgJ3JlYWN0LXNjcmlwdHNAXjQuMC4wJywgJ3dlYi12aXRhbHMnKTtcbiAgICBwcm9qZWN0LmFkZERldkRlcHMoJ0B0ZXN0aW5nLWxpYnJhcnkvamVzdC1kb20nLCAnQHRlc3RpbmctbGlicmFyeS9yZWFjdCcsICdAdGVzdGluZy1saWJyYXJ5L3VzZXItZXZlbnQnKTtcbiAgICBpZiAodGhpcy50eXBlc2NyaXB0KSB7XG4gICAgICBwcm9qZWN0LmFkZERldkRlcHMoJ0B0eXBlcy9qZXN0JywgJ0B0eXBlcy9ub2RlJywgJ0B0eXBlcy9yZWFjdCcsICdAdHlwZXMvcmVhY3QtZG9tJyk7XG4gICAgfVxuXG4gICAgLy8gQ3JlYXRlIFJlYWN0IEFwcCBDTEkgY29tbWFuZHMsIHNlZTogaHR0cHM6Ly9jcmVhdGUtcmVhY3QtYXBwLmRldi9kb2NzL2F2YWlsYWJsZS1zY3JpcHRzL1xuICAgIHByb2plY3QuYWRkVGFzaygnZGV2Jywge1xuICAgICAgZGVzY3JpcHRpb246ICdTdGFydHMgdGhlIHJlYWN0IGFwcGxpY2F0aW9uJyxcbiAgICAgIGNhdGVnb3J5OiBUYXNrQ2F0ZWdvcnkuQlVJTEQsXG4gICAgICBleGVjOiAncmVhY3Qtc2NyaXB0cyBzdGFydCcsXG4gICAgfSk7XG5cbiAgICBwcm9qZWN0LmFkZFRhc2soJ2J1aWxkJywge1xuICAgICAgZGVzY3JpcHRpb246ICdDcmVhdGVzIGFuIG9wdGltaXplZCBwcm9kdWN0aW9uIGJ1aWxkIG9mIHlvdXIgUmVhY3QgYXBwbGljYXRpb24nLFxuICAgICAgY2F0ZWdvcnk6IFRhc2tDYXRlZ29yeS5CVUlMRCxcbiAgICAgIGV4ZWM6ICdyZWFjdC1zY3JpcHRzIGJ1aWxkJyxcbiAgICB9KTtcblxuICAgIHByb2plY3QuYWRkVGFzaygnZWplY3QnLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ0VqZWN0cyB5b3VyIFJlYWN0IGFwcGxpY2F0aW9uIGZyb20gcmVhY3Qtc2NyaXB0cycsXG4gICAgICBjYXRlZ29yeTogVGFza0NhdGVnb3J5Lk1JU0MsXG4gICAgICBleGVjOiAncmVhY3Qtc2NyaXB0cyBlamVjdCcsXG4gICAgfSk7XG5cbiAgICBwcm9qZWN0LmFkZFRhc2soJ3Rlc3QnLCB7XG4gICAgICBkZXNjcmlwdGlvbjogJ1J1bnMgdGVzdHMnLFxuICAgICAgY2F0ZWdvcnk6IFRhc2tDYXRlZ29yeS5URVNULFxuICAgICAgZXhlYzogJ3JlYWN0LXNjcmlwdHMgdGVzdCcsXG4gICAgfSk7XG5cbiAgICBwcm9qZWN0Lm5wbWlnbm9yZT8uZXhjbHVkZSgnIyBCdWlsZCcsICcvYnVpbGQnKTtcbiAgICBwcm9qZWN0LmdpdGlnbm9yZS5leGNsdWRlKCcjIEJ1aWxkJywgJy9idWlsZCcpO1xuXG4gICAgcHJvamVjdC5wYWNrYWdlLmFkZEZpZWxkKCdlc2xpbnRDb25maWcnLCB7XG4gICAgICBleHRlbmRzOiBbXG4gICAgICAgICdyZWFjdC1hcHAnLFxuICAgICAgICAncmVhY3QtYXBwL2plc3QnLFxuICAgICAgXSxcbiAgICB9KTtcblxuICAgIHByb2plY3QucGFja2FnZS5hZGRGaWVsZCgnYnJvd3NlcnNsaXN0Jywge1xuICAgICAgcHJvZHVjdGlvbjogW1xuICAgICAgICAnPjAuMiUnLFxuICAgICAgICAnbm90IGRlYWQnLFxuICAgICAgICAnbm90IG9wX21pbmkgYWxsJyxcbiAgICAgIF0sXG4gICAgICBkZXZlbG9wbWVudDogW1xuICAgICAgICAnbGFzdCAxIGNocm9tZSB2ZXJzaW9uJyxcbiAgICAgICAgJ2xhc3QgMSBmaXJlZm94IHZlcnNpb24nLFxuICAgICAgICAnbGFzdCAxIHNhZmFyaSB2ZXJzaW9uJyxcbiAgICAgIF0sXG4gICAgfSk7XG4gIH1cbn1cblxuaW50ZXJmYWNlIFJlYWN0U2FtcGxlQ29kZU9wdGlvbnMge1xuICAvKipcbiAgICogRmlsZSBleHRlbnNpb24gZm9yIHNhbXBsZSBqYXZhc2NyaXB0IGNvZGUgdG8gYmUgc2F2ZWQgYXMuXG4gICAqXG4gICAqIEBkZWZhdWx0IFwianN4XCJcbiAgICovXG4gIHJlYWRvbmx5IGZpbGVFeHQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBkaXJlY3RvcnkgaW4gd2hpY2ggUmVhY3QganN4IGZpbGVzIGFyZSBkZWNsYXJlZC5cbiAgICovXG4gIHJlYWRvbmx5IHNyY2Rpcjogc3RyaW5nO1xufVxuXG5jbGFzcyBSZWFjdFNhbXBsZUNvZGUgZXh0ZW5kcyBDb21wb25lbnQge1xuICBwcml2YXRlIHJlYWRvbmx5IGZpbGVFeHQ6IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSBzcmNkaXI6IHN0cmluZztcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBOb2RlUHJvamVjdCwgb3B0aW9uczogUmVhY3RTYW1wbGVDb2RlT3B0aW9ucykge1xuICAgIHN1cGVyKHByb2plY3QpO1xuXG4gICAgdGhpcy5maWxlRXh0ID0gb3B0aW9ucy5maWxlRXh0ID8/ICdqc3gnO1xuICAgIHRoaXMuc3JjZGlyID0gb3B0aW9ucy5zcmNkaXI7XG5cbiAgICBjb25zdCBsb2dvU3ZnID0gW1xuICAgICAgJzxzdmcgeG1sbnM9XCJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2Z1wiIHZpZXdCb3g9XCIwIDAgODQxLjkgNTk1LjNcIj4nLFxuICAgICAgJyAgICA8ZyBmaWxsPVwiIzYxREFGQlwiPicsXG4gICAgICAnICAgICAgICA8cGF0aCBkPVwiTTY2Ni4zIDI5Ni41YzAtMzIuNS00MC43LTYzLjMtMTAzLjEtODIuNCAxNC40LTYzLjYgOC0xMTQuMi0yMC4yLTEzMC40LTYuNS0zLjgtMTQuMS01LjYtMjIuNC01LjZ2MjIuM2M0LjYgMCA4LjMuOSAxMS40IDIuNiAxMy42IDcuOCAxOS41IDM3LjUgMTQuOSA3NS43LTEuMSA5LjQtMi45IDE5LjMtNS4xIDI5LjQtMTkuNi00LjgtNDEtOC41LTYzLjUtMTAuOS0xMy41LTE4LjUtMjcuNS0zNS4zLTQxLjYtNTAgMzIuNi0zMC4zIDYzLjItNDYuOSA4NC00Ni45Vjc4Yy0yNy41IDAtNjMuNSAxOS42LTk5LjkgNTMuNi0zNi40LTMzLjgtNzIuNC01My4yLTk5LjktNTMuMnYyMi4zYzIwLjcgMCA1MS40IDE2LjUgODQgNDYuNi0xNCAxNC43LTI4IDMxLjQtNDEuMyA0OS45LTIyLjYgMi40LTQ0IDYuMS02My42IDExLTIuMy0xMC00LTE5LjctNS4yLTI5LTQuNy0zOC4yIDEuMS02Ny45IDE0LjYtNzUuOCAzLTEuOCA2LjktMi42IDExLjUtMi42Vjc4LjVjLTguNCAwLTE2IDEuOC0yMi42IDUuNi0yOC4xIDE2LjItMzQuNCA2Ni43LTE5LjkgMTMwLjEtNjIuMiAxOS4yLTEwMi43IDQ5LjktMTAyLjcgODIuMyAwIDMyLjUgNDAuNyA2My4zIDEwMy4xIDgyLjQtMTQuNCA2My42LTggMTE0LjIgMjAuMiAxMzAuNCA2LjUgMy44IDE0LjEgNS42IDIyLjUgNS42IDI3LjUgMCA2My41LTE5LjYgOTkuOS01My42IDM2LjQgMzMuOCA3Mi40IDUzLjIgOTkuOSA1My4yIDguNCAwIDE2LTEuOCAyMi42LTUuNiAyOC4xLTE2LjIgMzQuNC02Ni43IDE5LjktMTMwLjEgNjItMTkuMSAxMDIuNS00OS45IDEwMi41LTgyLjN6bS0xMzAuMi02Ni43Yy0zLjcgMTIuOS04LjMgMjYuMi0xMy41IDM5LjUtNC4xLTgtOC40LTE2LTEzLjEtMjQtNC42LTgtOS41LTE1LjgtMTQuNC0yMy40IDE0LjIgMi4xIDI3LjkgNC43IDQxIDcuOXptLTQ1LjggMTA2LjVjLTcuOCAxMy41LTE1LjggMjYuMy0yNC4xIDM4LjItMTQuOSAxLjMtMzAgMi00NS4yIDItMTUuMSAwLTMwLjItLjctNDUtMS45LTguMy0xMS45LTE2LjQtMjQuNi0yNC4yLTM4LTcuNi0xMy4xLTE0LjUtMjYuNC0yMC44LTM5LjggNi4yLTEzLjQgMTMuMi0yNi44IDIwLjctMzkuOSA3LjgtMTMuNSAxNS44LTI2LjMgMjQuMS0zOC4yIDE0LjktMS4zIDMwLTIgNDUuMi0yIDE1LjEgMCAzMC4yLjcgNDUgMS45IDguMyAxMS45IDE2LjQgMjQuNiAyNC4yIDM4IDcuNiAxMy4xIDE0LjUgMjYuNCAyMC44IDM5LjgtNi4zIDEzLjQtMTMuMiAyNi44LTIwLjcgMzkuOXptMzIuMy0xM2M1LjQgMTMuNCAxMCAyNi44IDEzLjggMzkuOC0xMy4xIDMuMi0yNi45IDUuOS00MS4yIDggNC45LTcuNyA5LjgtMTUuNiAxNC40LTIzLjcgNC42LTggOC45LTE2LjEgMTMtMjQuMXpNNDIxLjIgNDMwYy05LjMtOS42LTE4LjYtMjAuMy0yNy44LTMyIDkgLjQgMTguMi43IDI3LjUuNyA5LjQgMCAxOC43LS4yIDI3LjgtLjctOSAxMS43LTE4LjMgMjIuNC0yNy41IDMyem0tNzQuNC01OC45Yy0xNC4yLTIuMS0yNy45LTQuNy00MS03LjkgMy43LTEyLjkgOC4zLTI2LjIgMTMuNS0zOS41IDQuMSA4IDguNCAxNiAxMy4xIDI0IDQuNyA4IDkuNSAxNS44IDE0LjQgMjMuNHpNNDIwLjcgMTYzYzkuMyA5LjYgMTguNiAyMC4zIDI3LjggMzItOS0uNC0xOC4yLS43LTI3LjUtLjctOS40IDAtMTguNy4yLTI3LjguNyA5LTExLjcgMTguMy0yMi40IDI3LjUtMzJ6bS03NCA1OC45Yy00LjkgNy43LTkuOCAxNS42LTE0LjQgMjMuNy00LjYgOC04LjkgMTYtMTMgMjQtNS40LTEzLjQtMTAtMjYuOC0xMy44LTM5LjggMTMuMS0zLjEgMjYuOS01LjggNDEuMi03Ljl6bS05MC41IDEyNS4yYy0zNS40LTE1LjEtNTguMy0zNC45LTU4LjMtNTAuNiAwLTE1LjcgMjIuOS0zNS42IDU4LjMtNTAuNiA4LjYtMy43IDE4LTcgMjcuNy0xMC4xIDUuNyAxOS42IDEzLjIgNDAgMjIuNSA2MC45LTkuMiAyMC44LTE2LjYgNDEuMS0yMi4yIDYwLjYtOS45LTMuMS0xOS4zLTYuNS0yOC0xMC4yek0zMTAgNDkwYy0xMy42LTcuOC0xOS41LTM3LjUtMTQuOS03NS43IDEuMS05LjQgMi45LTE5LjMgNS4xLTI5LjQgMTkuNiA0LjggNDEgOC41IDYzLjUgMTAuOSAxMy41IDE4LjUgMjcuNSAzNS4zIDQxLjYgNTAtMzIuNiAzMC4zLTYzLjIgNDYuOS04NCA0Ni45LTQuNS0uMS04LjMtMS0xMS4zLTIuN3ptMjM3LjItNzYuMmM0LjcgMzguMi0xLjEgNjcuOS0xNC42IDc1LjgtMyAxLjgtNi45IDIuNi0xMS41IDIuNi0yMC43IDAtNTEuNC0xNi41LTg0LTQ2LjYgMTQtMTQuNyAyOC0zMS40IDQxLjMtNDkuOSAyMi42LTIuNCA0NC02LjEgNjMuNi0xMSAyLjMgMTAuMSA0LjEgMTkuOCA1LjIgMjkuMXptMzguNS02Ni43Yy04LjYgMy43LTE4IDctMjcuNyAxMC4xLTUuNy0xOS42LTEzLjItNDAtMjIuNS02MC45IDkuMi0yMC44IDE2LjYtNDEuMSAyMi4yLTYwLjYgOS45IDMuMSAxOS4zIDYuNSAyOC4xIDEwLjIgMzUuNCAxNS4xIDU4LjMgMzQuOSA1OC4zIDUwLjYtLjEgMTUuNy0yMyAzNS42LTU4LjQgNTAuNnpNMzIwLjggNzguNHpcIi8+JyxcbiAgICAgICcgICAgICAgIDxjaXJjbGUgY3g9XCI0MjAuOVwiIGN5PVwiMjk2LjVcIiByPVwiNDUuN1wiLz4nLFxuICAgICAgJyAgICAgICAgPHBhdGggZD1cIk01MjAuNSA3OC4xelwiLz4nLFxuICAgICAgJyAgICA8L2c+JyxcbiAgICAgICc8L3N2Zz4nLFxuICAgICAgJycsXG4gICAgXTtcblxuICAgIGNvbnN0IGFwcEpzeCA9IFtcbiAgICAgIFwiaW1wb3J0IGxvZ28gZnJvbSAnLi9sb2dvLnN2Zyc7XCIsXG4gICAgICBcImltcG9ydCAnLi9BcHAuY3NzJ1wiLFxuICAgICAgJycsXG4gICAgICAnZnVuY3Rpb24gQXBwKCkgeycsXG4gICAgICAnICByZXR1cm4gKCcsXG4gICAgICAnICAgPGRpdiBjbGFzc05hbWU9XCJBcHBcIj4nLFxuICAgICAgJyAgICAgIDxoZWFkZXIgY2xhc3NOYW1lPVwiQXBwLWhlYWRlclwiPicsXG4gICAgICAnICAgICAgICA8aW1nIHNyYz17bG9nb30gY2xhc3NOYW1lPVwiQXBwLWxvZ29cIiBhbHQ9XCJsb2dvXCIgLz4nLFxuICAgICAgJyAgICAgICAgPHA+JyxcbiAgICAgIGAgICAgICAgICAgRWRpdCA8Y29kZT5zcmMvQXBwLiR7dGhpcy5maWxlRXh0fTwvY29kZT4gYW5kIHNhdmUgdG8gcmVsb2FkLmAsXG4gICAgICAnICAgICAgICA8L3A+JyxcbiAgICAgICcgICAgICAgIDxhIGNsYXNzTmFtZT1cIkFwcC1saW5rXCInLFxuICAgICAgJyAgICAgICAgICBocmVmPVwiaHR0cHM6Ly9yZWFjdGpzLm9yZ1wiJyxcbiAgICAgICcgICAgICAgICAgdGFyZ2V0PVwiX2JsYW5rXCInLFxuICAgICAgJyAgICAgICAgICByZWw9XCJub29wZW5lciBub3JlZmVycmVyXCInLFxuICAgICAgJyAgICAgICAgPicsXG4gICAgICAnICAgICAgICAgIExlYXJuIFJlYWN0JyxcbiAgICAgICcgICAgICAgIDwvYT4nLFxuICAgICAgJyAgICAgIDwvaGVhZGVyPicsXG4gICAgICAnICAgIDwvZGl2PicsXG4gICAgICAnICApOycsXG4gICAgICAnfScsXG4gICAgICAnJyxcbiAgICAgICdleHBvcnQgZGVmYXVsdCBBcHA7JyxcbiAgICAgICcnLFxuICAgIF07XG5cbiAgICBjb25zdCBhcHBDc3MgPSBbXG4gICAgICAnLkFwcCB7JyxcbiAgICAgICcgIHRleHQtYWxpZ246IGNlbnRlcjsnLFxuICAgICAgJ30nLFxuICAgICAgJycsXG4gICAgICAnLkFwcC1sb2dvIHsnLFxuICAgICAgJyAgaGVpZ2h0OiA0MHZtaW47JyxcbiAgICAgICcgIHBvaW50ZXItZXZlbnRzOiBub25lOycsXG4gICAgICAnfScsXG4gICAgICAnJyxcbiAgICAgICdAbWVkaWEgKHByZWZlcnMtcmVkdWNlZC1tb3Rpb246IG5vLXByZWZlcmVuY2UpIHsnLFxuICAgICAgJyAgLkFwcC1sb2dvIHsnLFxuICAgICAgJyAgICBhbmltYXRpb246IEFwcC1sb2dvLXNwaW4gaW5maW5pdGUgMjBzIGxpbmVhcjsnLFxuICAgICAgJyAgfScsXG4gICAgICAnfScsXG4gICAgICAnJyxcbiAgICAgICcuQXBwLWhlYWRlciB7JyxcbiAgICAgICcgIGJhY2tncm91bmQtY29sb3I6ICMyODJjMzQ7JyxcbiAgICAgICcgIG1pbi1oZWlnaHQ6IDEwMHZoOycsXG4gICAgICAnICBkaXNwbGF5OiBmbGV4OycsXG4gICAgICAnICBmbGV4LWRpcmVjdGlvbjogY29sdW1uOycsXG4gICAgICAnICBhbGlnbi1pdGVtczogY2VudGVyOycsXG4gICAgICAnICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjsnLFxuICAgICAgJyAgZm9udC1zaXplOiBjYWxjKDEwcHggKyAydm1pbik7JyxcbiAgICAgICcgIGNvbG9yOiB3aGl0ZTsnLFxuICAgICAgJ30nLFxuICAgICAgJycsXG4gICAgICAnLkFwcC1saW5rIHsnLFxuICAgICAgJyAgY29sb3I6ICM2MWRhZmI7JyxcbiAgICAgICd9JyxcbiAgICAgICcnLFxuICAgICAgJ0BrZXlmcmFtZXMgQXBwLWxvZ28tc3BpbiB7JyxcbiAgICAgICcgIGZyb20geycsXG4gICAgICAnICAgIHRyYW5zZm9ybTogcm90YXRlKDBkZWcpOycsXG4gICAgICAnICB9JyxcbiAgICAgICcgIHRvIHsnLFxuICAgICAgJyAgICB0cmFuc2Zvcm06IHJvdGF0ZSgzNjBkZWcpOycsXG4gICAgICAnICB9JyxcbiAgICAgICd9JyxcbiAgICAgICcnLFxuICAgIF07XG5cbiAgICBjb25zdCBhcHBUZXN0SnN4ID0gW1xuICAgICAgXCJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1wiLFxuICAgICAgXCJpbXBvcnQgeyByZW5kZXIsIHNjcmVlbiB9IGZyb20gJ0B0ZXN0aW5nLWxpYnJhcnkvcmVhY3QnO1wiLFxuICAgICAgXCJpbXBvcnQgQXBwIGZyb20gJy4vQXBwJztcIixcbiAgICAgICcnLFxuICAgICAgXCJ0ZXN0KCdyZW5kZXJzIGxlYXJuIHJlYWN0IGxpbmsnLCAoKSA9PiB7XCIsXG4gICAgICAnICByZW5kZXIoPEFwcCAvPik7JyxcbiAgICAgICcgIGNvbnN0IGxpbmtFbGVtZW50ID0gc2NyZWVuLmdldEJ5VGV4dCgvbGVhcm4gcmVhY3QvaSk7JyxcbiAgICAgICcgIGV4cGVjdChsaW5rRWxlbWVudCkudG9CZUluVGhlRG9jdW1lbnQoKTsnLFxuICAgICAgJ30pOycsXG4gICAgICAnJyxcbiAgICBdO1xuXG4gICAgY29uc3QgaW5kZXhKc3ggPSBbXG4gICAgICBcImltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XCIsXG4gICAgICBcImltcG9ydCBSZWFjdERPTSBmcm9tICdyZWFjdC1kb20nO1wiLFxuICAgICAgXCJpbXBvcnQgJy4vaW5kZXguY3NzJztcIixcbiAgICAgIFwiaW1wb3J0IEFwcCBmcm9tICcuL0FwcCc7XCIsXG4gICAgICBcImltcG9ydCByZXBvcnRXZWJWaXRhbHMgZnJvbSAnLi9yZXBvcnRXZWJWaXRhbHMnO1wiLFxuICAgICAgJycsXG4gICAgICAnUmVhY3RET00ucmVuZGVyKCcsXG4gICAgICAnICA8UmVhY3QuU3RyaWN0TW9kZT4nLFxuICAgICAgJyAgICA8QXBwIC8+JyxcbiAgICAgICcgIDwvUmVhY3QuU3RyaWN0TW9kZT4sJyxcbiAgICAgIFwiICBkb2N1bWVudC5nZXRFbGVtZW50QnlJZCgncm9vdCcpXCIsXG4gICAgICAnKTsnLFxuICAgICAgJycsXG4gICAgICAnLy8gSWYgeW91IHdhbnQgdG8gc3RhcnQgbWVhc3VyaW5nIHBlcmZvcm1hbmNlIGluIHlvdXIgYXBwLCBwYXNzIGEgZnVuY3Rpb24nLFxuICAgICAgJy8vIHRvIGxvZyByZXN1bHRzIChmb3IgZXhhbXBsZTogcmVwb3J0V2ViVml0YWxzKGNvbnNvbGUubG9nKSknLFxuICAgICAgJy8vIG9yIHNlbmQgdG8gYW4gYW5hbHl0aWNzIGVuZHBvaW50LiBMZWFybiBtb3JlOiBodHRwczovL2JpdC5seS9DUkEtdml0YWxzJyxcbiAgICAgICdyZXBvcnRXZWJWaXRhbHMoKTsnLFxuICAgICAgJycsXG4gICAgXTtcblxuICAgIGNvbnN0IGluZGV4Q3NzID0gW1xuICAgICAgJ2JvZHkgeycsXG4gICAgICAnICBtYXJnaW46IDA7JyxcbiAgICAgIFwiICBmb250LWZhbWlseTogLWFwcGxlLXN5c3RlbSwgQmxpbmtNYWNTeXN0ZW1Gb250LCAnU2Vnb2UgVUknLCAnUm9ib3RvJywgJ094eWdlbicsXCIsXG4gICAgICBcIiAgICAnVWJ1bnR1JywgJ0NhbnRhcmVsbCcsICdGaXJhIFNhbnMnLCAnRHJvaWQgU2FucycsICdIZWx2ZXRpY2EgTmV1ZScsXCIsXG4gICAgICAnICAgIHNhbnMtc2VyaWY7JyxcbiAgICAgICcgIC13ZWJraXQtZm9udC1zbW9vdGhpbmc6IGFudGlhbGlhc2VkOycsXG4gICAgICAnICAtbW96LW9zeC1mb250LXNtb290aGluZzogZ3JheXNjYWxlOycsXG4gICAgICAnfScsXG4gICAgICAnJyxcbiAgICAgICdjb2RlIHsnLFxuICAgICAgXCIgIGZvbnQtZmFtaWx5OiBzb3VyY2UtY29kZS1wcm8sIE1lbmxvLCBNb25hY28sIENvbnNvbGFzLCAnQ291cmllciBOZXcnLFwiLFxuICAgICAgJyAgICBtb25vc3BhY2U7JyxcbiAgICAgICd9JyxcbiAgICAgICcnLFxuICAgIF07XG5cbiAgICBjb25zdCByZXBvcnRXZWJWaXRhbHNKcyA9IFtcbiAgICAgIFwiaW1wb3J0IHsgUmVwb3J0SGFuZGxlciB9IGZyb20gJ3dlYi12aXRhbHMnO1wiLFxuICAgICAgJycsXG4gICAgICAnY29uc3QgcmVwb3J0V2ViVml0YWxzID0gKG9uUGVyZkVudHJ5PzogUmVwb3J0SGFuZGxlcikgPT4geycsXG4gICAgICAnICBpZiAob25QZXJmRW50cnkgJiYgb25QZXJmRW50cnkgaW5zdGFuY2VvZiBGdW5jdGlvbikgeycsXG4gICAgICBcIiAgICBpbXBvcnQoJ3dlYi12aXRhbHMnKS50aGVuKCh7IGdldENMUywgZ2V0RklELCBnZXRGQ1AsIGdldExDUCwgZ2V0VFRGQiB9KSA9PiB7XCIsXG4gICAgICAnICAgICAgZ2V0Q0xTKG9uUGVyZkVudHJ5KTsnLFxuICAgICAgJyAgICAgIGdldEZJRChvblBlcmZFbnRyeSk7JyxcbiAgICAgICcgICAgICBnZXRGQ1Aob25QZXJmRW50cnkpOycsXG4gICAgICAnICAgICAgZ2V0TENQKG9uUGVyZkVudHJ5KTsnLFxuICAgICAgJyAgICAgIGdldFRURkIob25QZXJmRW50cnkpOycsXG4gICAgICAnICAgIH0pOycsXG4gICAgICAnICB9JyxcbiAgICAgICd9JyxcbiAgICAgICcnLFxuICAgICAgJ2V4cG9ydCBkZWZhdWx0IHJlcG9ydFdlYlZpdGFsczsnLFxuICAgIF07XG5cbiAgICBjb25zdCBzZXR1cFRlc3RzSnMgPSBbXG4gICAgICAnLy8gamVzdC1kb20gYWRkcyBjdXN0b20gamVzdCBtYXRjaGVycyBmb3IgYXNzZXJ0aW5nIG9uIERPTSBub2Rlcy4nLFxuICAgICAgJy8vIGFsbG93cyB5b3UgdG8gZG8gdGhpbmdzIGxpa2U6JyxcbiAgICAgICcvLyBleHBlY3QoZWxlbWVudCkudG9IYXZlVGV4dENvbnRlbnQoL3JlYWN0L2kpJyxcbiAgICAgICcvLyBsZWFybiBtb3JlOiBodHRwczovL2dpdGh1Yi5jb20vdGVzdGluZy1saWJyYXJ5L2plc3QtZG9tJyxcbiAgICAgIFwiaW1wb3J0ICdAdGVzdGluZy1saWJyYXJ5L2plc3QtZG9tJztcIixcbiAgICAgICcnLFxuICAgIF07XG5cbiAgICAvLyBqcy90cyBub3QganN4L3RzeFxuICAgIGNvbnN0IGZpbGVFeHRXaXRob3V0WCA9IHRoaXMuZmlsZUV4dC5yZXBsYWNlKCd4JywgJycpO1xuXG4gICAgbmV3IFNhbXBsZURpcihwcm9qZWN0LCB0aGlzLnNyY2Rpciwge1xuICAgICAgZmlsZXM6IHtcbiAgICAgICAgJ2xvZ28uc3ZnJzogbG9nb1N2Zy5qb2luKCdcXG4nKSxcbiAgICAgICAgWydBcHAuJyArIHRoaXMuZmlsZUV4dF06IGFwcEpzeC5qb2luKCdcXG4nKSxcbiAgICAgICAgWydBcHAudGVzdC4nICsgdGhpcy5maWxlRXh0XTogYXBwVGVzdEpzeC5qb2luKCdcXG4nKSxcbiAgICAgICAgJ0FwcC5jc3MnOiBhcHBDc3Muam9pbignXFxuJyksXG4gICAgICAgIFsnaW5kZXguJyArIHRoaXMuZmlsZUV4dF06IGluZGV4SnN4LmpvaW4oJ1xcbicpLFxuICAgICAgICAnaW5kZXguY3NzJzogaW5kZXhDc3Muam9pbignXFxuJyksXG4gICAgICAgIFsncmVwb3J0V2ViVml0YWxzLicgKyBmaWxlRXh0V2l0aG91dFhdOiByZXBvcnRXZWJWaXRhbHNKcy5qb2luKCdcXG4nKSxcbiAgICAgICAgWydzZXR1cFRlc3RzLicgKyBmaWxlRXh0V2l0aG91dFhdOiBzZXR1cFRlc3RzSnMuam9pbignXFxuJyksXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgY29uc3QgaW5kZXhIdG1sID0gW1xuICAgICAgJzwhRE9DVFlQRSBodG1sPicsXG4gICAgICAnPGh0bWwgbGFuZz1cImVuXCI+JyxcbiAgICAgICcgIDxoZWFkPicsXG4gICAgICAnICAgIDxtZXRhIGNoYXJzZXQ9XCJ1dGYtOFwiIC8+JyxcbiAgICAgICcgICAgPGxpbmsgcmVsPVwiaWNvblwiIGhyZWY9XCIlUFVCTElDX1VSTCUvZmF2aWNvbi5pY29cIiAvPicsXG4gICAgICAnICAgIDxtZXRhIG5hbWUgPSBcInZpZXdwb3J0XCIgY29udGVudCA9IFwid2lkdGg9ZGV2aWNlLXdpZHRoLCBpbml0aWFsLXNjYWxlPTFcIiAvPicsXG4gICAgICAnICAgIDxtZXRhIG5hbWU9XCJ0aGVtZS1jb2xvclwiIGNvbnRlbnQgPSBcIiMwMDAwMDBcIiAvPicsXG4gICAgICAnICAgIDxtZXRhIG5hbWU9XCJkZXNjcmlwdGlvblwiIGNvbnRlbnQgPSBcIldlYiBzaXRlIGNyZWF0ZWQgdXNpbmcgY3JlYXRlLXJlYWN0LWFwcFwiIC8+JyxcbiAgICAgICcgICAgPGxpbmsgcmVsPVwiYXBwbGUtdG91Y2gtaWNvblwiIGhyZWYgPSBcIiVQVUJMSUNfVVJMJS9sb2dvMTkyLnBuZ1wiIC8+JyxcbiAgICAgICcgICAgPCEtLScsXG4gICAgICAnICAgICAgbWFuaWZlc3QuanNvbiBwcm92aWRlcyBtZXRhZGF0YSB1c2VkIHdoZW4geW91ciB3ZWIgYXBwIGlzIGluc3RhbGxlZCBvbiBhJyxcbiAgICAgIFwiICAgICAgdXNlcidzIG1vYmlsZSBkZXZpY2Ugb3IgZGVza3RvcC4gU2VlIGh0dHBzOi8vZGV2ZWxvcGVycy5nb29nbGUuY29tL3dlYi9mdW5kYW1lbnRhbHMvd2ViLWFwcC1tYW5pZmVzdC9cIixcbiAgICAgICcgICAgLS0+JyxcbiAgICAgICcgICAgPGxpbmsgcmVsPVwibWFuaWZlc3RcIiBocmVmID0gXCIlUFVCTElDX1VSTCUvbWFuaWZlc3QuanNvblwiIC8+JyxcbiAgICAgICcgICAgPCEtLScsXG4gICAgICAnICAgICAgTm90aWNlIHRoZSB1c2Ugb2YgJSBQVUJMSUNfVVJMICUgaW4gdGhlIHRhZ3MgYWJvdmUuJyxcbiAgICAgICcgICAgICBJdCB3aWxsIGJlIHJlcGxhY2VkIHdpdGggdGhlIFVSTCBvZiB0aGVgcHVibGljYCBmb2xkZXIgZHVyaW5nIHRoZSBidWlsZC4nLFxuICAgICAgJyAgICAgIE9ubHkgZmlsZXMgaW5zaWRlIHRoZWBwdWJsaWNgIGZvbGRlciBjYW4gYmUgcmVmZXJlbmNlZCBmcm9tIHRoZSBIVE1MLicsXG4gICAgICAnJyxcbiAgICAgICcgICAgICBVbmxpa2UgXCIvZmF2aWNvbi5pY29cIiBvciBcImZhdmljb24uaWNvXCIsIFwiJVBVQkxJQ19VUkwlL2Zhdmljb24uaWNvXCIgd2lsbCcsXG4gICAgICAnICAgICAgd29yayBjb3JyZWN0bHkgYm90aCB3aXRoIGNsaWVudCAtIHNpZGUgcm91dGluZyBhbmQgYSBub24gLSByb290IHB1YmxpYyBVUkwuJyxcbiAgICAgICcgICAgICBMZWFybiBob3cgdG8gY29uZmlndXJlIGEgbm9uLXJvb3QgcHVibGljIFVSTCBieSBydW5uaW5nYG5wbSBydW4gYnVpbGRgLicsXG4gICAgICAnICAgIC0tPicsXG4gICAgICAnICAgIDx0aXRsZT5SZWFjdCBBcHAgPC90aXRsZT4nLFxuICAgICAgJyAgPC9oZWFkPicsXG4gICAgICAnICA8Ym9keT4nLFxuICAgICAgJyAgICA8bm9zY3JpcHQ+WW91IG5lZWQgdG8gZW5hYmxlIEphdmFTY3JpcHQgdG8gcnVuIHRoaXMgYXBwLjwvbm9zY3JpcHQ+JyxcbiAgICAgICcgICAgPGRpdiBpZD1cInJvb3RcIj4gPC9kaXY+JyxcbiAgICAgICcgICAgPCEtLScsXG4gICAgICAnICAgICAgVGhpcyBIVE1MIGZpbGUgaXMgYSB0ZW1wbGF0ZS4nLFxuICAgICAgJyAgICAgIElmIHlvdSBvcGVuIGl0IGRpcmVjdGx5IGluIHRoZSBicm93c2VyLCB5b3Ugd2lsbCBzZWUgYW4gZW1wdHkgcGFnZS4nLFxuICAgICAgJyAgICAgIFlvdSBjYW4gYWRkIHdlYmZvbnRzLCBtZXRhIHRhZ3MsIG9yIGFuYWx5dGljcyB0byB0aGlzIGZpbGUuJyxcbiAgICAgICcgICAgICBUaGUgYnVpbGQgc3RlcCB3aWxsIHBsYWNlIHRoZSBidW5kbGVkIHNjcmlwdHMgaW50byB0aGUgPGJvZHk+IHRhZy4nLFxuICAgICAgJycsXG4gICAgICAnICAgICAgVG8gYmVnaW4gdGhlIGRldmVsb3BtZW50LCBydW4gYG5wbSBzdGFydGAgb3IgYHlhcm4gc3RhcnRgLicsXG4gICAgICAnICAgICAgVG8gY3JlYXRlIGEgcHJvZHVjdGlvbiBidW5kbGUsIHVzZSBgbnBtIHJ1biBidWlsZGAgb3IgYHlhcm4gYnVpbGRgLicsXG4gICAgICAnICAgIC0tPicsXG4gICAgICAnICA8L2JvZHk+JyxcbiAgICAgICc8L2h0bWw+JyxcbiAgICBdO1xuXG4gICAgY29uc3QgcHVibGljTWFuaWZlc3QgPSB7XG4gICAgICBzaG9ydF9uYW1lOiAnUmVhY3QgQXBwJyxcbiAgICAgIG5hbWU6ICdDcmVhdGUgUmVhY3QgQXBwIFNhbXBsZScsXG4gICAgICBpY29uczogW10sXG4gICAgICBzdGFydF91cmw6ICcuJyxcbiAgICAgIGRpc3BsYXk6ICdzdGFuZGFsb25lJyxcbiAgICAgIHRoZW1lX2NvbG9yOiAnIzAwMDAwMCcsXG4gICAgICBiYWNrZ3JvdW5kX2NvbG9yOiAnI2ZmZmZmZicsXG4gICAgfTtcblxuICAgIGNvbnN0IHJvYm90VHh0ID0gW1xuICAgICAgJyMgaHR0cHM6Ly93d3cucm9ib3RzdHh0Lm9yZy9yb2JvdHN0eHQuaHRtbCcsXG4gICAgICAnVXNlci1hZ2VudDogKicsXG4gICAgICAnRGlzYWxsb3c6JyxcbiAgICBdO1xuXG4gICAgbmV3IFNhbXBsZURpcihwcm9qZWN0LCAncHVibGljJywge1xuICAgICAgZmlsZXM6IHtcbiAgICAgICAgJ2luZGV4Lmh0bWwnOiBpbmRleEh0bWwuam9pbignXFxuJyksXG4gICAgICAgICdtYW5pZmVzdC5qc29uJzogSlNPTi5zdHJpbmdpZnkocHVibGljTWFuaWZlc3QsIHVuZGVmaW5lZCwgMiksXG4gICAgICAgICdyb2JvdHMudHh0Jzogcm9ib3RUeHQuam9pbignXFxuJyksXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVhY3RUeXBlRGVmT3B0aW9ucyBleHRlbmRzIEZpbGVCYXNlT3B0aW9ucyB7IH1cblxuZXhwb3J0IGNsYXNzIFJlYWN0VHlwZURlZiBleHRlbmRzIEZpbGVCYXNlIHtcbiAgY29uc3RydWN0b3IocHJvamVjdDogUmVhY3RUeXBlU2NyaXB0UHJvamVjdCwgZmlsZVBhdGg6IHN0cmluZywgb3B0aW9uczogUmVhY3RUeXBlRGVmT3B0aW9ucyA9IHt9KSB7XG4gICAgc3VwZXIocHJvamVjdCwgZmlsZVBhdGgsIG9wdGlvbnMpO1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVDb250ZW50KF86IElSZXNvbHZlcik6IHN0cmluZyB8IHVuZGVmaW5lZCB7XG4gICAgcmV0dXJuIFtcbiAgICAgICcvLy8gPHJlZmVyZW5jZSB0eXBlcz1cInJlYWN0LXNjcmlwdHNcIiAvPicsXG4gICAgXS5qb2luKCdcXG4nKTtcbiAgfVxufVxuIl19