"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegSsmParameters = exports.IntegTesting = void 0;
const iam = require("@aws-cdk/aws-iam");
const ssm = require("@aws-cdk/aws-ssm");
const cdk = require("@aws-cdk/core");
const core_1 = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const envJP = {
            region: 'ap-northeast-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const envUS = {
            region: 'us-west-2',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        // first stack in JP
        const stackJP = new cdk.Stack(app, 'demo-stack-jp', { env: envJP });
        new cdk.CfnOutput(stackJP, 'TopicName', { value: 'foo' });
        // second stack in US
        const stackUS = new cdk.Stack(app, 'demo-stack-us', { env: envUS });
        // ensure the dependency
        stackUS.addDependency(stackJP);
        // get the stackJP stack outputs from stackUS
        const outputs = new _1.RemoteOutputs(stackUS, 'Outputs', {
            stack: stackJP,
            alwaysUpdate: false,
        });
        const remoteOutputValue = outputs.get('TopicName');
        // the value should be exactly the same with the output value of `TopicName`
        new cdk.CfnOutput(stackUS, 'RemoteTopicName', { value: remoteOutputValue });
        this.stack = [stackJP, stackUS];
    }
}
exports.IntegTesting = IntegTesting;
class IntegSsmParameters {
    constructor() {
        const app = new cdk.App();
        const envJP = {
            region: 'ap-northeast-1',
            account: '111111111111',
        };
        const envUS = {
            region: 'us-west-2',
            account: '222222222222',
        };
        // first stack in JP
        const producerStackName = 'demo-stack-jp';
        const stackJP = new cdk.Stack(app, producerStackName, { env: envJP });
        const parameterPath = `/${envJP.account}/${envJP.region}/${producerStackName}`;
        new ssm.StringParameter(stackJP, 'foo1', {
            parameterName: `${parameterPath}/foo1`,
            stringValue: 'bar1',
        });
        new ssm.StringParameter(stackJP, 'foo2', {
            parameterName: `${parameterPath}/foo2`,
            stringValue: 'bar2',
        });
        new ssm.StringParameter(stackJP, 'foo3', {
            parameterName: `${parameterPath}/foo3`,
            stringValue: 'bar3',
        });
        // allow US account to assume this readonly role to get parameters
        const cdkReadOnlyRole = new iam.Role(stackJP, 'readOnlyRole', {
            assumedBy: new iam.AccountPrincipal(envUS.account),
            roleName: core_1.PhysicalName.GENERATE_IF_NEEDED,
            managedPolicies: [iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMReadOnlyAccess')],
        });
        // second stack in US
        const stackUS = new cdk.Stack(app, 'demo-stack-us', { env: envUS });
        // ensure the dependency
        stackUS.addDependency(stackJP);
        // get remote parameters by path from SSM parameter store
        const parameters = new _1.RemoteParameters(stackUS, 'Parameters', {
            path: parameterPath,
            region: stackJP.region,
            // assume this role for cross-account parameters
            role: iam.Role.fromRoleArn(stackUS, 'readOnlyRole', cdkReadOnlyRole.roleArn),
        });
        const foo1 = parameters.get(`${parameterPath}/foo1`);
        const foo2 = parameters.get(`${parameterPath}/foo2`);
        const foo3 = parameters.get(`${parameterPath}/foo3`);
        new cdk.CfnOutput(stackUS, 'foo1Output', { value: foo1 });
        new cdk.CfnOutput(stackUS, 'foo2Output', { value: foo2 });
        new cdk.CfnOutput(stackUS, 'foo3Output', { value: foo3 });
        this.stack = [stackJP, stackUS];
    }
}
exports.IntegSsmParameters = IntegSsmParameters;
new IntegTesting();
new IntegSsmParameters();
//# sourceMappingURL=data:application/json;base64,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