""" Serves a game and waits for guest to play online """

import uuid
import logging
from flask import Flask, request, Response

CURRENT_SESSION = None

def serve(game_object, host='0.0.0.0', port=8799):
    """ Serve the server """
    app = Flask(__name__)

    log = logging.getLogger('werkzeug')
    log.setLevel(logging.ERROR)

    @app.route('/connect')
    def connect():
        global CURRENT_SESSION

        # check session already started
        if CURRENT_SESSION is not None:
            return Response('session currently started', status=401)

        # get user confirmation
        try:
            guess_name = request.args['name']
            if game_object.guess_color == 'white':
                game_object.white_player = guess_name
            else:
                game_object.black_player = guess_name
        except:
            guess_name = 'Unknow'
        if input('User `' + guess_name + '` wants to play. Do you accept? [y/n] ') not in ('y', 'Y'):
            print('Rejected.')
            return Response('Rejected', status=403)

        game_object.guess_connected = True

        # start the session
        CURRENT_SESSION = str(uuid.uuid4())
        return CURRENT_SESSION

    @app.route('/me')
    def me():
        # return name of guess
        if CURRENT_SESSION is None:
            return Response('Please start a session first', status=401)

        try:
            if request.args['session'] == CURRENT_SESSION:
                # render the game
                return game_object.guess_color
            else:
                raise
        except:
            return Response('invalid session', status=401)

    @app.route('/render')
    def render():
        if CURRENT_SESSION is None:
            return Response('Please start a session first', status=401)

        try:
            if request.args['session'] == CURRENT_SESSION:
                # render the game and turn
                return game_object.turn + '\n' + game_object.render()
            else:
                raise
        except:
            return Response('invalid session', status=401)

    @app.route('/command')
    def command():
        if CURRENT_SESSION is None:
            return Response('Please start a session first', status=401)

        try:
            if request.args['session'] == CURRENT_SESSION:
                # put the command on the game object
                game_object.guess_ran = game_object.run_command(request.args['cmd'])
                return game_object.guess_ran
            else:
                raise ValueError()
        except:
            raise
            return Response('invalid session', status=401)

    print('Serving on ' + host + ':' + str(port))
    print('Others can join this game by running `tchess --connect ' + host + ':' + str(port) + '`')

    app.run(host, port)
