# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['depdf', 'depdf.components']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4>=4.8.2,<5.0.0', 'pdfplumber>=0.5.16,<0.6.0']

setup_kwargs = {
    'name': 'depdf',
    'version': '0.2.1',
    'description': 'PDF table & paragraph extractor',
    'long_description': '# DePDF\n\n![](https://img.shields.io/pypi/pyversions/depdf)\n![](https://img.shields.io/github/stars/meldonization/depdf)\n![](https://img.shields.io/pypi/v/depdf)\n![](https://img.shields.io/github/license/meldonization/depdf)\n\nAn ultimate pdf file disintegration tool. DePDF is designed to extract tables and paragraphs into structured markup language [eg. html] from embedding pdf pages. You can also use it to convert pdf page or pdf to html.\n\nBuilt on top of [`pdfplumber`](https://github.com/jsvine/pdfplumber)\n\nCheckout automatically generated [documentation](https://depdf.readthedocs.io/en/latest/index.html) if you wish.\n\n\n# Table of Contents\n[toc]\n\n\n# Installation\n`pip install depdf`\n\n# Example\n```python\nfrom depdf import DePDF\nfrom depdf import DePage\n\n# general\nwith DePDF.load(\'test/test.pdf\') as pdf\n    pdf_html = pdf.to_html\n    print(pdf_html)\n\n# with dedicated configurations\nc = Config(\n    debug_flag=True,\n    verbose_flag=True,\n    add_line_flag=True\n)\npdf = DePDF.load(\'test/test.pdf\', config=c)\npage_index = 23  # start from zero\npage = pdf_file.pages[page_index]\npage_soup = page.soup\nprint(page_soup.text)\n```\n\n\n# APIs\n| **functions** | usage |\n|:---:|---|\n| `extract_page_paragraphs` | extract paragraphs from specific page |\n| `extract_page_tables` | extract tables from specific page |\n| `convert_pdf_to_html` | convert the entire pdf to html | \n| `convert_page_to_html` | convert specific page to html | \n\n\n# In-Depth\n\n## In-page elements\n* Paragraph\n    + Text\n    + Span\n* Table\n    + Cell\n* Image\n\n## Common properties\n| **property & method** | explanation |\n|:---:|---|\n| `html` | converted html string |\n| `soup` | converted beautiful soup |\n| `bbox` | bounding box region | \n| `save_html` | write html tag to local file| \n\n## DePDF HTML structure\n```html\n<div class="{pdf_class}">\n    %for <!--page-{pid}-->\n        <div id="page-{pid}" class="{page_class}">\n            %for {in_page_elements} endfor%\n        </div>\n    endfor%\n</div>\n```\n\n## DePage HTML element structure\n\n### Paragraph\n```html\n<p>\n    {text-content}\n    <span> {span-content} </span>\n    ... \n</p>\n```\n\n### Table\n```html\n<table>\n    <tr>\n        <td> {cell_0_0} </td>\n        <td> {cell_0_1} </td>\n        ...\n    </tr>\n    <tr colspan=2>\n        <td> {merged_cell_1_0} </td>\n        ...\n    </tr>\n    ...\n</table>\n```\n\n### Image\n```\n<img src="temp_depdf/$prefix.png"></img>\n```\n\n# Configuration encyclopedia\n\n## PDF 解析\n\n| **keyword** | detail | default |\n|:---|---|---|\n| logo_flag | 是否分析不同页面共有的水印信息 | `True` |\n| header_footer_flag | 是否分析不同页面共有的页眉页脚信息 | `True` |\n| temp_dir_prefix | 是否分析不同页面共有的页眉页脚信息 | temp_depdf |\n| unique_prefix | 生成临时文件图片的文件名称（一般会自动生成） | |\n\n## 页面解析\n\n| **keyword** | detail | default |\n|:---|---|---|\n| table_flag | 是否解析表格 | `True` |\n| paragraph_flag | 是否解析段落 | `True` |\n| image_flag | 是否解析图片 | `True` |\n| resolution | debug 模式下生成页面预览图的分辨率 | 300 |\n| main_frame_tolerance | 识别页面内主要文字区域的阈值 | |\n| x_tolerance | 识别页面内文本行的横向阈值 | |\n| y_tolerance | 识别页面内文本行的纵向阈值 | |\n| page_num_top_fraction | 识别页面内页码信息上边界距离和页面的高度比例 | |\n| page_num_left_fraction | 识别页面内页码信息 | |\n| page_num_right_fraction | 识别页面内页码信息 | |\n\n## 页面分栏识别\n\n| **keyword** | detail | default |\n|:---|---|---|\n| multiple_columns_flag | 是否识别多栏页面 | `True` |\n| max_columns | 识别多栏页面栏数上限 | 3 |\n| column_region_half_width | 识别多栏页面栏分界宽度 | |\n| min_column_region_objects | 识别多栏页面栏分界内的对象数目上限 | |\n\n## 字符提取\n\n| **keyword** | detail | default |\n|:---|---|---|\n| char_overlap_size | 判断字符是否重叠的阈值 | |\n| default_char_size | 默认的字符大小 | |\n| char_size_upper | 探测到字符大小的上限 | |\n| char_size_lower | 探测到字符大小的下限 | |\n\n## 表格提取\n\n| **keyword** | detail | default |\n|:---|---|---|\n| dotted_line_flag | 是否分析页面内的虚线 | |\n| curved_line_flag | 是否分析页面内的曲线 | |\n| snap_flag | 是否合并表格线段| |\n| add_line_flag | 是否为表格增加横竖线 | |\n| min_double_line_tolerance | 判断线段是否为临近双线的距离下限 | |\n| max_double_line_tolerance | 判断线段是否为临近双线的距离上限 | |\n| vertical_double_line_tolerance | 判断线段是否为垂直临近双线的距离上限 | |\n| table_cell_merge_tolerance | 合并单元格的宽度差别容错值 | |\n| skip_empty_table | 是否忽略空白表格 | |\n| add_vertical_lines_flag | 是否增加竖线 | |\n| add_horizontal_lines_flag | 是否增加横线 | |\n| add_horizontal_line_tolerance | 增加横线的阈值 | |\n \n ## 图片提取\n\n| **keyword** | detail | default |\n|:---|---|---|\n| min_image_size | 识别图片的边长最小像素值 | 80 |\n| image_resolution | 提取图片的分辨率 | 300 |\n\n## 页眉页脚识别\n\n| **keyword** | detail | default |\n|:---|---|---|\n| default_head_tail_page_offset_percent | 页眉页脚的错位比例 | |\n\n## 日志输出\n\n| **keyword** | detail | default |\n|:---|---|---|\n| log_level | 日志的级别 | `WARNING` |\n| verbose_flag | 是否输出运行中间过程信息 | `False` |\n| debug_flag | 是否打开调试（生成解析对象的边界信息）| `False` |\n\n## 生成的网页标签\n\n| **keyword** | detail | default |\n|:---|---|---|\n| span_class | 生成 HTML 的 span 节点的 class | pdf-span |\n| paragraph_class | 生成 HTML 的 p 节点的 class | pdf-paragraph |\n| table_class | 生成 HTML 的 table 节点的 class | pdf-table |\n| pdf_class | 生成 HTML 的最外层 pdf div 节点的 class | pdf-content |\n| image_class | 生成 HTML 的 img 节点的 class | pdf-image |\n| page_class | 生成 HTML 的 page div 的 class | pdf-page |\n| mini_page_class | 生成 HTML 的 mini-page div 的 class | pdf-mini-page |\n\n\n# Update log\n\n* `2020-03-18` add support for multiple-column PDFs\n* `2020-03-12` initial depdf release\n\n\n# Appendix\n\n## todo\n\n* [x] add support for multiple-column pdf page\n* [x] better table structure recognition\n* [x] recognize embedded objects inside page elements\n\n## Project overview\n\n```bash\n.\n├── depdf\n│\xa0\xa0 ├── components\n│\xa0\xa0 │\xa0\xa0 ├── image.py\n│\xa0\xa0 │\xa0\xa0 ├── paragraph.py\n│\xa0\xa0 │\xa0\xa0 ├── span.py\n│\xa0\xa0 │\xa0\xa0 ├── table.py\n│\xa0\xa0 │\xa0\xa0 └── text.py\n│\xa0\xa0 ├── api.py\n│\xa0\xa0 ├── base.py\n│\xa0\xa0 ├── config.py\n│\xa0\xa0 ├── error.py\n│\xa0\xa0 ├── log.py\n│\xa0\xa0 ├── page.py\n│\xa0\xa0 ├── page_tools.py\n│\xa0\xa0 ├── pdf.py\n│\xa0\xa0 ├── pdf_tools.py\n│\xa0\xa0 ├── settings.py\n│\xa0\xa0 ├── utils.py\n│\xa0\xa0 └── version.py\n├── test\n│\xa0\xa0 ├── test.html\n│\xa0\xa0 ├── test.pdf\n│\xa0\xa0 ├── test.py\n│\xa0\xa0 └── test_mc.pdf\n├── LICENSE\n├── README.md\n├── annotations.jpg\n└── pyproject.toml\n\n4 directories, 33 files\n\n```\n\n## DePage element denotations\n> Useful element properties within page\n\n![page element](annotations.jpg)\n\n',
    'author': 'Meltonization',
    'author_email': 'mengzy1989@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/meldonization',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
