# repo2rocrate

Generate a [Workflow Testing RO-Crate](https://crs4.github.io/life_monitor/workflow_testing_ro_crate) from a "best-practices" workflow repository. In this context, "best-practices" means the set of guidelines, especially regarding repository structure and metadata, put together by the workflow language community. Here is the list of currently supported workflow languages, together with the community resources used as a reference:

* Galaxy: [IWC's howto for adding workflows](https://github.com/galaxyproject/iwc/blob/main/workflows/README.md)
* Nextflow: nf-core [guidelines](https://nf-co.re/contributing/guidelines) and [info on pipeline structure](https://nf-co.re/developers/adding_pipelines#nf-core-pipeline-structure) (and ultimately the template generated by `nf-core create`)
* Snakemake: [snakemake-workflows](https://github.com/snakemake-workflows/docs) guidelines, Snakemake [distribution and reproducibility docs](https://snakemake.readthedocs.io/en/stable/snakefiles/deployment.html)

## Installation

```
pip install repo2rocrate
```

## Usage

The package consists of an API and a command line tool, also called `repo2rocrate`. It can generate RO-Crate metadata in-place or build an RO-Crate in a separate directory. The approach is to generate as many metadata as possible based on what can be extracted from known files and knowledge of the expected layout; the user can complement this by adding or overriding various bits via the available options.

Examples:

```
git clone https://github.com/crs4/fair-crcc-send-data
repo2rocrate -r fair-crcc-send-data --repo-url https://github.com/crs4/fair-crcc-send-data --license GPL-3.0
```

```
git clone https://github.com/nf-core/rnaseq
cd rnaseq/
repo2rocrate
```

The above commands add an `ro-crate-metadata.json` file to the repository directory. To generate an RO-Crate in a separate directory, use the `-o` option. Run `repo2rocrate --help` to get a description of all available options.
