# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['monet_pytorch', 'monet_pytorch.template']

package_data = \
{'': ['*'],
 'monet_pytorch': ['config/dataset/*',
                   'config/model/*',
                   'config/special_cases/*']}

install_requires = \
['hydra-core>=1.2.0,<2.0.0', 'path>=15.0,<=16.4.0', 'torch>=1.8,<=1.12.0']

setup_kwargs = {
    'name': 'monet-pytorch',
    'version': '1.1.0',
    'description': 'Pytorch implementation of Multi-Object Network(MONet)',
    'long_description': '# Pytorch MONet implementation\n\n[![Python build package and test](https://github.com/Michedev/MONet-pytorch/actions/workflows/build-and-test.yaml/badge.svg)](https://github.com/Michedev/MONet-pytorch/actions/workflows/build-and-test.yaml)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/monet-pytorch)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/monet-pytorch)\n![PyPI - Status](https://img.shields.io/pypi/status/monet-pytorch)\n\n\nPytorch implementation of [Multi-Object Network(MONet)](https://arxiv.org/abs/1901.11390)\n\n![monet_architecture](https://user-images.githubusercontent.com/12683228/179543891-11392837-a5a1-4f8d-b601-72525f208fe0.png)\n\n\n# How to install\n\nYou can install through pip with the following command\n\n    pip install monet-pytorch\n\nor clone this repository locally and install with [poetry](https://python-poetry.org/)\n\n    git clone https://github.com/Michedev/MONet-pytorch\n    cd MONet-pytorch\n    poetry install\n## How to use\n\nThe package comes with a set of predefined configurations based on paper specifications, namely _monet_ and _monet-iodine_ (MONet as defined in IODINE paper).\n\n    from monet_pytorch import Monet\n    \n    monet = Monet.from_config(model=\'monet\')\n\nThere is also another custom architecture _monet-lightweight_ which has less parameters than the original ones.\n\nFurthermore, the model architecture slightly changes based on the dataset (e.g. U-Net blocks) \npicked between the ones cited in MONet paper (_CLEVR 6, Multidsprites colored on colored, \nMultidsprited colored on grayscale, Tetrominoes_). \n\n    from monet_pytorch import Monet\n    \n    monet = Monet.from_config(model=\'monet\', dataset=\'tetrominoes\')\n\n\nIn alternative, you can set custom dataset parameters through the function arguments\n\n    from monet_pytorch import Monet\n    \n    monet = Monet.from_config(model=\'monet\', dataset_width=48, dataset_height=48, scene_max_objects=6)\n\nLastly, you can make your custom MONet by input your custom configuration as OmegaConf DictConfig\n\n    from monet_pytorch import Monet\n\n    custom_monet_config = OmegaConf.create("""\n    dataset:\n      width: 44\n      height: 44\n      max_num_objects: 10\n    model:  #this config file follows MONet implementation from IODINE paper\n      _target_: monet_pytorch.model.Monet\n      height: ${dataset.height}\n      width: ${dataset.width}\n      num_slots: ${dataset.max_num_objects}\n      name: monet-iodine\n      bg_sigma: 0.32\n      fg_sigma: 0.1\n      beta_kl: 0.43\n      gamma: 0.5\n      latent_size: 16\n      input_channels: 3\n      encoder:\n        _target_: torch.nn.Sequential\n        _args_:\n          - _target_: monet_pytorch.template.sequential_cnn.make_sequential_cnn_from_config\n            channels: [44, 44, 32, 14]\n            kernels: 3\n            strides: 2\n            paddings: 0\n            input_channels: 4\n            batchnorms: true\n            bn_affines: false\n            activations: relu\n          - _target_: torch.nn.Flatten\n            start_dim: 1\n          - _target_: torch.nn.Linear\n            in_features: 256\n            out_features: 256\n          - _target_: torch.nn.ReLU\n          - _target_: torch.nn.Linear\n            in_features: 256\n            out_features: ${prod:${model.latent_size},2}\n      decoder:\n        _target_: monet_pytorch.template.encoder_decoder.BroadcastDecoderNet\n        w_broadcast: ${sum:${dataset.width},8}\n        h_broadcast: ${sum:${dataset.height},8}\n        net:\n          _target_: monet_pytorch.template.sequential_cnn.make_sequential_cnn_from_config\n          input_channels: ${sum:${model.latent_size},2} # latent size + 2\n          channels: [32, 32, 64, 64, 4]  # last is 4 channels because rgb (3) + mask (1)\n          kernels: [3, 3, 3, 3, 1]\n          paddings: 0\n          activations: [relu, relu, relu, relu, null]  #null means no activation function no activation\n          batchnorms: [true, true, true, true, false]\n          bn_affines: [false, false, false, false, false]\n      unet:\n        _target_: monet_pytorch.unet.UNet\n        input_channels: ${model.input_channels}\n        num_blocks: 5\n        filter_start: 16\n        mlp_size: 128""")\n\n    custom_monet: Monet = Monet.from_custom_config(custom_monet_config)\n\n# Model performances\n\nThis implementation reproduce very closely ARI MONet\'s values\n\n## Special thanks\n\nI would like to thank @apra and @addtt for the help to fix code bugs and to improve model performances\n',
    'author': 'mikedev',
    'author_email': 'mik3dev@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Michedev/MONet-pytorch',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
