# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from banyanclient import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from banyanclient import schemas  # noqa: F401

from . import path

# query params
PolicyIDSchema = schemas.StrSchema
ServiceIDSchema = schemas.StrSchema
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'PolicyID': typing.Union[PolicyIDSchema, str, ],
        'ServiceID': typing.Union[ServiceIDSchema, str, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_policy_id = api_client.QueryParameter(
    name="PolicyID",
    style=api_client.ParameterStyle.FORM,
    schema=PolicyIDSchema,
    explode=True,
)
request_query_service_id = api_client.QueryParameter(
    name="ServiceID",
    style=api_client.ParameterStyle.FORM,
    schema=ServiceIDSchema,
    explode=True,
)
_auth = [
    'bearerAuthToken',
]


class SchemaFor200ResponseBodyApplicationJson(
    schemas.DictSchema
):


    class MetaOapg:
        
        class properties:
            PolicyID = schemas.StrSchema
            ServiceID = schemas.StrSchema
            AttachedBy = schemas.StrSchema
            AttachedAt = schemas.IntSchema
            Enabled = schemas.StrSchema
            DetachedBy = schemas.StrSchema
            DetachedAt = schemas.StrSchema
            __annotations__ = {
                "PolicyID": PolicyID,
                "ServiceID": ServiceID,
                "AttachedBy": AttachedBy,
                "AttachedAt": AttachedAt,
                "Enabled": Enabled,
                "DetachedBy": DetachedBy,
                "DetachedAt": DetachedAt,
            }
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["PolicyID"]) -> MetaOapg.properties.PolicyID: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["ServiceID"]) -> MetaOapg.properties.ServiceID: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["AttachedBy"]) -> MetaOapg.properties.AttachedBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["AttachedAt"]) -> MetaOapg.properties.AttachedAt: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Enabled"]) -> MetaOapg.properties.Enabled: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["DetachedBy"]) -> MetaOapg.properties.DetachedBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["DetachedAt"]) -> MetaOapg.properties.DetachedAt: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["PolicyID", "ServiceID", "AttachedBy", "AttachedAt", "Enabled", "DetachedBy", "DetachedAt", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["PolicyID"]) -> typing.Union[MetaOapg.properties.PolicyID, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["ServiceID"]) -> typing.Union[MetaOapg.properties.ServiceID, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["AttachedBy"]) -> typing.Union[MetaOapg.properties.AttachedBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["AttachedAt"]) -> typing.Union[MetaOapg.properties.AttachedAt, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Enabled"]) -> typing.Union[MetaOapg.properties.Enabled, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["DetachedBy"]) -> typing.Union[MetaOapg.properties.DetachedBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["DetachedAt"]) -> typing.Union[MetaOapg.properties.DetachedAt, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["PolicyID", "ServiceID", "AttachedBy", "AttachedAt", "Enabled", "DetachedBy", "DetachedAt", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        PolicyID: typing.Union[MetaOapg.properties.PolicyID, str, schemas.Unset] = schemas.unset,
        ServiceID: typing.Union[MetaOapg.properties.ServiceID, str, schemas.Unset] = schemas.unset,
        AttachedBy: typing.Union[MetaOapg.properties.AttachedBy, str, schemas.Unset] = schemas.unset,
        AttachedAt: typing.Union[MetaOapg.properties.AttachedAt, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        Enabled: typing.Union[MetaOapg.properties.Enabled, str, schemas.Unset] = schemas.unset,
        DetachedBy: typing.Union[MetaOapg.properties.DetachedBy, str, schemas.Unset] = schemas.unset,
        DetachedAt: typing.Union[MetaOapg.properties.DetachedAt, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SchemaFor200ResponseBodyApplicationJson':
        return super().__new__(
            cls,
            *args,
            PolicyID=PolicyID,
            ServiceID=ServiceID,
            AttachedBy=AttachedBy,
            AttachedAt=AttachedAt,
            Enabled=Enabled,
            DetachedBy=DetachedBy,
            DetachedAt=DetachedAt,
            _configuration=_configuration,
            **kwargs,
        )


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor200ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)
_status_code_to_response = {
    '200': _response_for_200,
}
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):

    def _v1_security_attach_policies_get_oapg(
        self: api_client.Api,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        """
         List policy attachments
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value

        prefix_separator_iterator = None
        for parameter in (
            request_query_policy_id,
            request_query_service_id,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)

        response = self.api_client.call_api(
            resource_path=used_path,
            method='get'.upper(),
            headers=_headers,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(response=response)
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(response, self.api_client.configuration)
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(response=response)

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)

        return api_response


class V1SecurityAttachPoliciesGet(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    def v1_security_attach_policies_get(
        self: BaseApi,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        return self._v1_security_attach_policies_get_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


class ApiForget(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    def get(
        self: BaseApi,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        return self._v1_security_attach_policies_get_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


