# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from banyanclient import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from banyanclient import schemas  # noqa: F401

from . import path

# query params
SerialNumberSchema = schemas.StrSchema
EmailSchema = schemas.StrSchema
NameSchema = schemas.StrSchema
ActiveSchema = schemas.BoolSchema
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'serial_number': typing.Union[SerialNumberSchema, str, ],
        'email': typing.Union[EmailSchema, str, ],
        'name': typing.Union[NameSchema, str, ],
        'active': typing.Union[ActiveSchema, bool, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_serial_number = api_client.QueryParameter(
    name="serial_number",
    style=api_client.ParameterStyle.FORM,
    schema=SerialNumberSchema,
    explode=True,
)
request_query_email = api_client.QueryParameter(
    name="email",
    style=api_client.ParameterStyle.FORM,
    schema=EmailSchema,
    explode=True,
)
request_query_name = api_client.QueryParameter(
    name="name",
    style=api_client.ParameterStyle.FORM,
    schema=NameSchema,
    explode=True,
)
request_query_active = api_client.QueryParameter(
    name="active",
    style=api_client.ParameterStyle.FORM,
    schema=ActiveSchema,
    explode=True,
)
_auth = [
    'bearerAuthToken',
]


class SchemaFor200ResponseBodyTextCsv(
    schemas.DictSchema
):


    class MetaOapg:
        
        class properties:
            Email = schemas.StrSchema
            created_at = schemas.StrSchema
            last_login = schemas.StrSchema
            login_count = schemas.IntSchema
            serial_numbers = schemas.StrSchema
            Roles = schemas.StrSchema
            Groups = schemas.StrSchema
            TrustData = schemas.IntSchema
            Status = schemas.StrSchema
            archived_at = schemas.StrSchema
            __annotations__ = {
                "Email": Email,
                "Created At": created_at,
                "Last Login": last_login,
                "Login Count": login_count,
                "Serial Numbers": serial_numbers,
                "Roles": Roles,
                "Groups": Groups,
                "TrustData": TrustData,
                "Status": Status,
                "Archived At": archived_at,
            }
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Email"]) -> MetaOapg.properties.Email: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Created At"]) -> MetaOapg.properties.created_at: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Last Login"]) -> MetaOapg.properties.last_login: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Login Count"]) -> MetaOapg.properties.login_count: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Serial Numbers"]) -> MetaOapg.properties.serial_numbers: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Roles"]) -> MetaOapg.properties.Roles: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Groups"]) -> MetaOapg.properties.Groups: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["TrustData"]) -> MetaOapg.properties.TrustData: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Status"]) -> MetaOapg.properties.Status: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Archived At"]) -> MetaOapg.properties.archived_at: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["Email", "Created At", "Last Login", "Login Count", "Serial Numbers", "Roles", "Groups", "TrustData", "Status", "Archived At", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Email"]) -> typing.Union[MetaOapg.properties.Email, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Created At"]) -> typing.Union[MetaOapg.properties.created_at, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Last Login"]) -> typing.Union[MetaOapg.properties.last_login, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Login Count"]) -> typing.Union[MetaOapg.properties.login_count, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Serial Numbers"]) -> typing.Union[MetaOapg.properties.serial_numbers, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Roles"]) -> typing.Union[MetaOapg.properties.Roles, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Groups"]) -> typing.Union[MetaOapg.properties.Groups, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["TrustData"]) -> typing.Union[MetaOapg.properties.TrustData, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Status"]) -> typing.Union[MetaOapg.properties.Status, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Archived At"]) -> typing.Union[MetaOapg.properties.archived_at, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["Email", "Created At", "Last Login", "Login Count", "Serial Numbers", "Roles", "Groups", "TrustData", "Status", "Archived At", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        Email: typing.Union[MetaOapg.properties.Email, str, schemas.Unset] = schemas.unset,
        Roles: typing.Union[MetaOapg.properties.Roles, str, schemas.Unset] = schemas.unset,
        Groups: typing.Union[MetaOapg.properties.Groups, str, schemas.Unset] = schemas.unset,
        TrustData: typing.Union[MetaOapg.properties.TrustData, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        Status: typing.Union[MetaOapg.properties.Status, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SchemaFor200ResponseBodyTextCsv':
        return super().__new__(
            cls,
            *args,
            Email=Email,
            Roles=Roles,
            Groups=Groups,
            TrustData=TrustData,
            Status=Status,
            _configuration=_configuration,
            **kwargs,
        )


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor200ResponseBodyTextCsv,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    content={
        'text/csv': api_client.MediaType(
            schema=SchemaFor200ResponseBodyTextCsv),
    },
)


@dataclass
class ApiResponseFor400(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: schemas.Unset = schemas.unset
    headers: schemas.Unset = schemas.unset


_response_for_400 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor400,
)


@dataclass
class ApiResponseFor500(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: schemas.Unset = schemas.unset
    headers: schemas.Unset = schemas.unset


_response_for_500 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor500,
)
_status_code_to_response = {
    '200': _response_for_200,
    '400': _response_for_400,
    '500': _response_for_500,
}
_all_accept_content_types = (
    'text/csv',
)


class BaseApi(api_client.Api):

    def _v1_endusers_csv_get_oapg(
        self: api_client.Api,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        """
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value

        prefix_separator_iterator = None
        for parameter in (
            request_query_serial_number,
            request_query_email,
            request_query_name,
            request_query_active,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)

        response = self.api_client.call_api(
            resource_path=used_path,
            method='get'.upper(),
            headers=_headers,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(response=response)
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(response, self.api_client.configuration)
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(response=response)

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)

        return api_response


class V1EndusersCsvGet(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    def v1_endusers_csv_get(
        self: BaseApi,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        return self._v1_endusers_csv_get_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


class ApiForget(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    def get(
        self: BaseApi,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        return self._v1_endusers_csv_get_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


