# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from banyanclient import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from banyanclient import schemas  # noqa: F401

from . import path

# query params
SerialNumberSchema = schemas.StrSchema
MaxPerPageSchema = schemas.IntSchema
PageNumberSchema = schemas.IntSchema
StartTimeEndTimeSchema = schemas.StrSchema
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'SerialNumber': typing.Union[SerialNumberSchema, str, ],
        'MaxPerPage': typing.Union[MaxPerPageSchema, decimal.Decimal, int, ],
        'PageNumber': typing.Union[PageNumberSchema, decimal.Decimal, int, ],
        'StartTime &amp; EndTime': typing.Union[StartTimeEndTimeSchema, str, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_serial_number = api_client.QueryParameter(
    name="SerialNumber",
    style=api_client.ParameterStyle.FORM,
    schema=SerialNumberSchema,
    explode=True,
)
request_query_max_per_page = api_client.QueryParameter(
    name="MaxPerPage",
    style=api_client.ParameterStyle.FORM,
    schema=MaxPerPageSchema,
    explode=True,
)
request_query_page_number = api_client.QueryParameter(
    name="PageNumber",
    style=api_client.ParameterStyle.FORM,
    schema=PageNumberSchema,
    explode=True,
)
request_query_start_time__end_time = api_client.QueryParameter(
    name="StartTime &amp; EndTime",
    style=api_client.ParameterStyle.FORM,
    schema=StartTimeEndTimeSchema,
    explode=True,
)
_auth = [
    'bearerAuthToken',
]


class SchemaFor200ResponseBodyApplicationJson(
    schemas.DictSchema
):


    class MetaOapg:
        
        class properties:
            Timezone = schemas.StrSchema
            Region = schemas.StrSchema
            Timestamp = schemas.IntSchema
            Locale = schemas.StrSchema
            Compromised = schemas.StrSchema
            OSVersion = schemas.StrSchema
            SerialNumber = schemas.StrSchema
            Model = schemas.StrSchema
            Latitude = schemas.StrSchema
            Longitude = schemas.StrSchema
            BatteryLevel = schemas.StrSchema
            Name = schemas.StrSchema
            __annotations__ = {
                "Timezone": Timezone,
                "Region": Region,
                "Timestamp": Timestamp,
                "Locale": Locale,
                "Compromised": Compromised,
                "OSVersion": OSVersion,
                "SerialNumber": SerialNumber,
                "Model": Model,
                "Latitude": Latitude,
                "Longitude": Longitude,
                "BatteryLevel": BatteryLevel,
                "Name": Name,
            }
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Timezone"]) -> MetaOapg.properties.Timezone: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Region"]) -> MetaOapg.properties.Region: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Timestamp"]) -> MetaOapg.properties.Timestamp: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Locale"]) -> MetaOapg.properties.Locale: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Compromised"]) -> MetaOapg.properties.Compromised: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["OSVersion"]) -> MetaOapg.properties.OSVersion: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["SerialNumber"]) -> MetaOapg.properties.SerialNumber: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Model"]) -> MetaOapg.properties.Model: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Latitude"]) -> MetaOapg.properties.Latitude: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Longitude"]) -> MetaOapg.properties.Longitude: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["BatteryLevel"]) -> MetaOapg.properties.BatteryLevel: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["Name"]) -> MetaOapg.properties.Name: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["Timezone", "Region", "Timestamp", "Locale", "Compromised", "OSVersion", "SerialNumber", "Model", "Latitude", "Longitude", "BatteryLevel", "Name", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Timezone"]) -> typing.Union[MetaOapg.properties.Timezone, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Region"]) -> typing.Union[MetaOapg.properties.Region, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Timestamp"]) -> typing.Union[MetaOapg.properties.Timestamp, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Locale"]) -> typing.Union[MetaOapg.properties.Locale, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Compromised"]) -> typing.Union[MetaOapg.properties.Compromised, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["OSVersion"]) -> typing.Union[MetaOapg.properties.OSVersion, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["SerialNumber"]) -> typing.Union[MetaOapg.properties.SerialNumber, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Model"]) -> typing.Union[MetaOapg.properties.Model, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Latitude"]) -> typing.Union[MetaOapg.properties.Latitude, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Longitude"]) -> typing.Union[MetaOapg.properties.Longitude, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["BatteryLevel"]) -> typing.Union[MetaOapg.properties.BatteryLevel, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["Name"]) -> typing.Union[MetaOapg.properties.Name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["Timezone", "Region", "Timestamp", "Locale", "Compromised", "OSVersion", "SerialNumber", "Model", "Latitude", "Longitude", "BatteryLevel", "Name", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        Timezone: typing.Union[MetaOapg.properties.Timezone, str, schemas.Unset] = schemas.unset,
        Region: typing.Union[MetaOapg.properties.Region, str, schemas.Unset] = schemas.unset,
        Timestamp: typing.Union[MetaOapg.properties.Timestamp, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        Locale: typing.Union[MetaOapg.properties.Locale, str, schemas.Unset] = schemas.unset,
        Compromised: typing.Union[MetaOapg.properties.Compromised, str, schemas.Unset] = schemas.unset,
        OSVersion: typing.Union[MetaOapg.properties.OSVersion, str, schemas.Unset] = schemas.unset,
        SerialNumber: typing.Union[MetaOapg.properties.SerialNumber, str, schemas.Unset] = schemas.unset,
        Model: typing.Union[MetaOapg.properties.Model, str, schemas.Unset] = schemas.unset,
        Latitude: typing.Union[MetaOapg.properties.Latitude, str, schemas.Unset] = schemas.unset,
        Longitude: typing.Union[MetaOapg.properties.Longitude, str, schemas.Unset] = schemas.unset,
        BatteryLevel: typing.Union[MetaOapg.properties.BatteryLevel, str, schemas.Unset] = schemas.unset,
        Name: typing.Union[MetaOapg.properties.Name, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'SchemaFor200ResponseBodyApplicationJson':
        return super().__new__(
            cls,
            *args,
            Timezone=Timezone,
            Region=Region,
            Timestamp=Timestamp,
            Locale=Locale,
            Compromised=Compromised,
            OSVersion=OSVersion,
            SerialNumber=SerialNumber,
            Model=Model,
            Latitude=Latitude,
            Longitude=Longitude,
            BatteryLevel=BatteryLevel,
            Name=Name,
            _configuration=_configuration,
            **kwargs,
        )


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor200ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)


@dataclass
class ApiResponseFor400(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: schemas.Unset = schemas.unset
    headers: schemas.Unset = schemas.unset


_response_for_400 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor400,
)


@dataclass
class ApiResponseFor500(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: schemas.Unset = schemas.unset
    headers: schemas.Unset = schemas.unset


_response_for_500 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor500,
)
_status_code_to_response = {
    '200': _response_for_200,
    '400': _response_for_400,
    '500': _response_for_500,
}
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):

    def _v1_enduser_devices_data_get_oapg(
        self: api_client.Api,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        """
         List End User Devices
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value

        prefix_separator_iterator = None
        for parameter in (
            request_query_serial_number,
            request_query_max_per_page,
            request_query_page_number,
            request_query_start_time__end_time,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)

        response = self.api_client.call_api(
            resource_path=used_path,
            method='get'.upper(),
            headers=_headers,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(response=response)
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(response, self.api_client.configuration)
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(response=response)

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)

        return api_response


class V1EnduserDevicesDataGet(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    def v1_enduser_devices_data_get(
        self: BaseApi,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        return self._v1_enduser_devices_data_get_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


class ApiForget(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    def get(
        self: BaseApi,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization
    ]:
        return self._v1_enduser_devices_data_get_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


