# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from banyanclient.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    V1_ENABLE_REGISTERED_SERVICE = "/v1/enable_registered_service"
    V1_SERVICES_STATS = "/v1/services/stats"
    V1_SERVICE_CONNECTION_TEST = "/v1/service_connection_test"
    V1_INSERT_REGISTERED_SERVICE = "/v1/insert_registered_service"
    V2_ACCESS_TIER_ID_REGISTERED_SERVICES = "/v2/access_tier/{id}/registered_services"
    V1_REGISTERED_SERVICES = "/v1/registered_services"
    V1_DELETE_REGISTERED_SERVICE = "/v1/delete_registered_service"
    V1_DISABLE_REGISTERED_SERVICE = "/v1/disable_registered_service"
    V2_BUNDLE_BUNDLE_ID = "/v2/bundle/{bundle_id}"
    V2_BUNDLE = "/v2/bundle"
    V2_BUNDLE_BUNDLE_ID_SERVICE = "/v2/bundle/{bundle_id}/service"
    V2_BUNDLE_BUNDLE_ID_SERVICE_SERVICE_ID = "/v2/bundle/{bundle_id}/service/{service_id}"
    V2_SERVICE_TUNNEL = "/v2/service_tunnel"
    SERVICE_TUNNEL_ID_SECURITY_POLICY_POLICY_ID = "/service_tunnel/{id}/security_policy/{policy_id}"
    SERVICE_TUNNEL_ID_SECURITY_POLICY = "/service_tunnel/{id}/security_policy"
    V2_SERVICE_TUNNEL_ID = "/v2/service_tunnel/{id}"
    V1_INSERT_SAASAPP = "/v1/insert_saasapp"
    V1_POLICY_POLICY_ID_ATTACHMENT = "/v1/policy/{policyID}/attachment"
    V1_SECURITY_POLICIES = "/v1/security_policies"
    V1_SECURITY_ATTACH_POLICIES = "/v1/security_attach_policies"
    V1_POLICIES_STATS = "/v1/policies/stats"
    V1_POLICY_ATTACHMENT_ATTACHED_TO_TYPE_ATTACHED_TO_ID = "/v1/policy/attachment/{attachedToType}/{attachedToID}"
    V1_POLICY_ATTACHMENT_ATTACHED_TO_TYPE = "/v1/policy/attachment/{attachedToType}"
    V1_DELETE_SECURITY_POLICY = "/v1/delete_security_policy"
    V1_INSERT_SECURITY_ATTACH_POLICY = "/v1/insert_security_attach_policy"
    V1_POLICY_ATTACHMENT = "/v1/policy/attachment"
    V1_DELETE_SECURITY_ATTACH_POLICY = "/v1/delete_security_attach_policy"
    V1_INSERT_SECURITY_POLICY = "/v1/insert_security_policy"
    V1_SECURITYROLES_STATS = "/v1/securityroles/stats"
    V1_DISABLE_SECURITY_ROLE = "/v1/disable_security_role"
    V1_INSERT_SECURITY_ROLE = "/v1/insert_security_role"
    V1_ENABLE_SECURITY_ROLE = "/v1/enable_security_role"
    V1_SECURITY_ROLES_ENDUSER_DEVICES = "/v1/security_roles/enduser_devices"
    V1_DELETE_SECURITY_ROLE = "/v1/delete_security_role"
    V1_SECURITY_ROLES = "/v1/security_roles"
    V1_UNREGISTERED_DEVICE_ENDUSERS_CSV = "/v1/unregistered_device/endusers/csv"
    V1_ENDUSERS_STATS = "/v1/endusers/stats"
    V2_ENDUSERS = "/v2/endusers"
    V1_MDM_INSERT_DEVICES = "/v1/mdm/insert_devices"
    V2_ENDUSER_GROUPS = "/v2/enduser_groups"
    V1_ENDUSERS = "/v1/endusers"
    V1_ENDUSER_DEVICES_DATA = "/v1/enduser_devices/data"
    V2_ENDUSER = "/v2/enduser"
    V1_ENDUSERS_CSV = "/v1/endusers/csv"
    V2_ENDUSER_ID = "/v2/enduser/{id}"
    V1_DELETE_DEVICE = "/v1/delete_device"
    V1_SEND_DEVICE_NOTIFICATION = "/v1/send_device_notification"
    V2_DEVICES_CSV = "/v2/devices/csv"
    V2_DEVICES = "/v2/devices"
    V1_ENDUSER_DEVICES = "/v1/enduser_devices"
    V1_MDM_DEVICE_INFO = "/v1/mdm/device_info"
    V1_DEVICE_ID_TOKEN = "/v1/device/id_token"
    V1_MDM_UPDATE_DEVICE = "/v1/mdm/update_device"
    V1_DEVICES_STATS = "/v1/devices/stats"
    V1_DEVICES = "/v1/devices"
    V1_EVENTS = "/v1/events"
    V2_EVENT_DAILY_COUNTS = "/v2/event/daily_counts"
    V1_EVENT_TYPES = "/v1/event_types"
    V1_EVENTS_FEED = "/v1/events/feed"
    V1_EVENTS_COUNT = "/v1/events/count"
    V1_AUDIT_LOGS = "/v1/audit_logs"
    V2_ACCESS_TIER_ID = "/v2/access_tier/{id}"
    V1_ACCESS_TIERS_STATS = "/v1/access_tiers/stats"
    V2_ACCESS_TIER = "/v2/access_tier"
    V1_ONE_CLICK_SUPPORT_BUNDLE = "/v1/one_click_support_bundle"
    V1_SERVICE_HOSTNAME_MAPPING = "/v1/service_hostname_mapping"
    V2_ACCESS_TIER_ACCESS_TIER_ID_TUNNEL_CONFIG_TUNNEL_CONFIG_ID = "/v2/access_tier/{access_tier_id}/tunnel_config/{tunnel_config_id}"
    V2_SATELLITE = "/v2/satellite"
    V2_SATELLITE_ID = "/v2/satellite/{id}"
    V2_CONNECTOR_STATS = "/v2/connector/stats"
    V2_CLOUD_RESOURCE_ID = "/v2/cloud_resource/{id}"
    V2_CLOUD_RESOURCE_SERVICE_ID = "/v2/cloud_resource_service/{id}"
    V2_CLOUD_RESOURCE_SERVICE = "/v2/cloud_resource_service"
    V2_API_KEY_ID = "/v2/api_key/{id}"
    V2_API_KEY_SCOPE = "/v2/api_key/scope"
    V2_API_KEY = "/v2/api_key"
