# banyanclient
This swagger spec contains list of all Banyan APIs.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import banyanclient
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import banyanclient
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import banyanclient
from pprint import pprint
from banyanclient.apis import access_tier_api
# Defining the host is optional and defaults to http://localhost:9002
# See configuration.py for a list of all supported configuration parameters.
configuration = banyanclient.Configuration(
    host = "http://localhost:9002"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuthToken
configuration = banyanclient.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with banyanclient.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = access_tier_api.AccessTierApi(api_client)
    
    try:
        #  Get the access_tiers statistics for an org
        api_response = api_instance.v1_access_tiers_stats_get()
        pprint(api_response)
    except banyanclient.ApiException as e:
        print("Exception when calling AccessTierApi->v1_access_tiers_stats_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:9002*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessTierApi* | [**v1_access_tiers_stats_get**](docs/apis/tags/AccessTierApi.md#v1_access_tiers_stats_get) | **get** /v1/access_tiers/stats |  Get the access_tiers statistics for an org
*AccessTierApi* | [**v1_one_click_support_bundle_post**](docs/apis/tags/AccessTierApi.md#v1_one_click_support_bundle_post) | **post** /v1/one_click_support_bundle |  POST /v1/one_click_support_bundle
*AccessTierApi* | [**v1_service_hostname_mapping_get**](docs/apis/tags/AccessTierApi.md#v1_service_hostname_mapping_get) | **get** /v1/service_hostname_mapping |  Get Service handling info
*AccessTierApi* | [**v2_access_tier_access_tier_id_tunnel_config_tunnel_config_id_delete**](docs/apis/tags/AccessTierApi.md#v2_access_tier_access_tier_id_tunnel_config_tunnel_config_id_delete) | **delete** /v2/access_tier/{access_tier_id}/tunnel_config/{tunnel_config_id} |  detach tunnel config to access tier.
*AccessTierApi* | [**v2_access_tier_access_tier_id_tunnel_config_tunnel_config_id_post**](docs/apis/tags/AccessTierApi.md#v2_access_tier_access_tier_id_tunnel_config_tunnel_config_id_post) | **post** /v2/access_tier/{access_tier_id}/tunnel_config/{tunnel_config_id} |  attach tunnel config to access tier.
*AccessTierApi* | [**v2_access_tier_get**](docs/apis/tags/AccessTierApi.md#v2_access_tier_get) | **get** /v2/access_tier |  List Access Tier(s) of an organization
*AccessTierApi* | [**v2_access_tier_id_delete**](docs/apis/tags/AccessTierApi.md#v2_access_tier_id_delete) | **delete** /v2/access_tier/{id} |  Delete Access Tier
*AccessTierApi* | [**v2_access_tier_id_get**](docs/apis/tags/AccessTierApi.md#v2_access_tier_id_get) | **get** /v2/access_tier/{id} |  Get details of Access Tier(s) of an organization
*AccessTierApi* | [**v2_access_tier_id_put**](docs/apis/tags/AccessTierApi.md#v2_access_tier_id_put) | **put** /v2/access_tier/{id} |  Update Access Tier information 
*AccessTierApi* | [**v2_access_tier_id_registered_services_get**](docs/apis/tags/AccessTierApi.md#v2_access_tier_id_registered_services_get) | **get** /v2/access_tier/{id}/registered_services |  List registered services attached to Access Tier for an organization
*AccessTierApi* | [**v2_access_tier_post**](docs/apis/tags/AccessTierApi.md#v2_access_tier_post) | **post** /v2/access_tier |  Create Access Tier for an organization
*ApiKeyApi* | [**v2_api_key_get**](docs/apis/tags/ApiKeyApi.md#v2_api_key_get) | **get** /v2/api_key |  Get details of api key 
*ApiKeyApi* | [**v2_api_key_id_delete**](docs/apis/tags/ApiKeyApi.md#v2_api_key_id_delete) | **delete** /v2/api_key/{id} |  Delete api key for an org 
*ApiKeyApi* | [**v2_api_key_id_get**](docs/apis/tags/ApiKeyApi.md#v2_api_key_id_get) | **get** /v2/api_key/{id} |  Get details of api key 
*ApiKeyApi* | [**v2_api_key_id_put**](docs/apis/tags/ApiKeyApi.md#v2_api_key_id_put) | **put** /v2/api_key/{id} |  To update api key for an org 
*ApiKeyApi* | [**v2_api_key_post**](docs/apis/tags/ApiKeyApi.md#v2_api_key_post) | **post** /v2/api_key |  To create api key for an org 
*ApiKeyApi* | [**v2_api_key_scope_get**](docs/apis/tags/ApiKeyApi.md#v2_api_key_scope_get) | **get** /v2/api_key/scope |  Get api key scopes 
*AuditLogApi* | [**v1_audit_logs_get**](docs/apis/tags/AuditLogApi.md#v1_audit_logs_get) | **get** /v1/audit_logs |  Get Audit Logs
*BundleApi* | [**v2_bundle_bundle_id_delete**](docs/apis/tags/BundleApi.md#v2_bundle_bundle_id_delete) | **delete** /v2/bundle/{bundle_id} | Delete a service bundle
*BundleApi* | [**v2_bundle_bundle_id_put**](docs/apis/tags/BundleApi.md#v2_bundle_bundle_id_put) | **put** /v2/bundle/{bundle_id} |  Update an existing service bundle
*BundleApi* | [**v2_bundle_bundle_id_service_post**](docs/apis/tags/BundleApi.md#v2_bundle_bundle_id_service_post) | **post** /v2/bundle/{bundle_id}/service | Create a service bundle
*BundleApi* | [**v2_bundle_bundle_id_service_service_id_delete**](docs/apis/tags/BundleApi.md#v2_bundle_bundle_id_service_service_id_delete) | **delete** /v2/bundle/{bundle_id}/service/{service_id} | Delete a service from a bundle
*BundleApi* | [**v2_bundle_get**](docs/apis/tags/BundleApi.md#v2_bundle_get) | **get** /v2/bundle |  GET service bundles
*BundleApi* | [**v2_bundle_post**](docs/apis/tags/BundleApi.md#v2_bundle_post) | **post** /v2/bundle | Create a service bundle
*CloudResourceApi* | [**v2_cloud_resource_id_delete**](docs/apis/tags/CloudResourceApi.md#v2_cloud_resource_id_delete) | **delete** /v2/cloud_resource/{id} |  Add new Cloud Resource
*CloudResourceApi* | [**v2_cloud_resource_id_get**](docs/apis/tags/CloudResourceApi.md#v2_cloud_resource_id_get) | **get** /v2/cloud_resource/{id} |  List Cloud Resources
*CloudResourceApi* | [**v2_cloud_resource_id_patch**](docs/apis/tags/CloudResourceApi.md#v2_cloud_resource_id_patch) | **patch** /v2/cloud_resource/{id} |  Add new Cloud Resource
*CloudResourceApi* | [**v2_cloud_resource_id_put**](docs/apis/tags/CloudResourceApi.md#v2_cloud_resource_id_put) | **put** /v2/cloud_resource/{id} |  Add new Cloud Resource
*CloudResourceServiceApi* | [**v2_cloud_resource_service_get**](docs/apis/tags/CloudResourceServiceApi.md#v2_cloud_resource_service_get) | **get** /v2/cloud_resource_service |  Add new Cloud Resource
*CloudResourceServiceApi* | [**v2_cloud_resource_service_id_delete**](docs/apis/tags/CloudResourceServiceApi.md#v2_cloud_resource_service_id_delete) | **delete** /v2/cloud_resource_service/{id} |  Add new Cloud Resource
*CloudResourceServiceApi* | [**v2_cloud_resource_service_id_get**](docs/apis/tags/CloudResourceServiceApi.md#v2_cloud_resource_service_id_get) | **get** /v2/cloud_resource_service/{id} |  Add new Cloud Resource
*CloudResourceServiceApi* | [**v2_cloud_resource_service_post**](docs/apis/tags/CloudResourceServiceApi.md#v2_cloud_resource_service_post) | **post** /v2/cloud_resource_service |  Add new Cloud Resource
*DeviceApi* | [**v1_delete_device_delete**](docs/apis/tags/DeviceApi.md#v1_delete_device_delete) | **delete** /v1/delete_device | Delete Enduser Device
*DeviceApi* | [**v1_device_id_token_get**](docs/apis/tags/DeviceApi.md#v1_device_id_token_get) | **get** /v1/device/id_token | Get id token
*DeviceApi* | [**v1_devices_get**](docs/apis/tags/DeviceApi.md#v1_devices_get) | **get** /v1/devices |  Get the devices in an organization
*DeviceApi* | [**v1_devices_stats_get**](docs/apis/tags/DeviceApi.md#v1_devices_stats_get) | **get** /v1/devices/stats |  Get the devices statistics for an org
*DeviceApi* | [**v1_enduser_devices_data_get**](docs/apis/tags/DeviceApi.md#v1_enduser_devices_data_get) | **get** /v1/enduser_devices/data |  List End User Devices
*DeviceApi* | [**v1_enduser_devices_get**](docs/apis/tags/DeviceApi.md#v1_enduser_devices_get) | **get** /v1/enduser_devices |  List End User Devices
*DeviceApi* | [**v1_mdm_device_info_get**](docs/apis/tags/DeviceApi.md#v1_mdm_device_info_get) | **get** /v1/mdm/device_info |  Get Device Info
*DeviceApi* | [**v1_mdm_insert_devices_post**](docs/apis/tags/DeviceApi.md#v1_mdm_insert_devices_post) | **post** /v1/mdm/insert_devices |  Insert End User Devices
*DeviceApi* | [**v1_mdm_update_device_post**](docs/apis/tags/DeviceApi.md#v1_mdm_update_device_post) | **post** /v1/mdm/update_device | Ban &amp; Unban Devices
*DeviceApi* | [**v1_security_roles_enduser_devices_get**](docs/apis/tags/DeviceApi.md#v1_security_roles_enduser_devices_get) | **get** /v1/security_roles/enduser_devices |  List Enduser and Device pairs for given role id
*DeviceApi* | [**v1_send_device_notification_post**](docs/apis/tags/DeviceApi.md#v1_send_device_notification_post) | **post** /v1/send_device_notification |  Sends push notification to iOS enduser device
*DeviceApi* | [**v2_devices_csv_get**](docs/apis/tags/DeviceApi.md#v2_devices_csv_get) | **get** /v2/devices/csv | Get the Devices from an Organization in CSV format
*DeviceApi* | [**v2_devices_delete**](docs/apis/tags/DeviceApi.md#v2_devices_delete) | **delete** /v2/devices |  DELETE devices
*DeviceApi* | [**v2_devices_get**](docs/apis/tags/DeviceApi.md#v2_devices_get) | **get** /v2/devices |  Get the Devices in an Organization
*EnduserApi* | [**v1_enduser_devices_data_get**](docs/apis/tags/EnduserApi.md#v1_enduser_devices_data_get) | **get** /v1/enduser_devices/data |  List End User Devices
*EnduserApi* | [**v1_endusers_csv_get**](docs/apis/tags/EnduserApi.md#v1_endusers_csv_get) | **get** /v1/endusers/csv | 
*EnduserApi* | [**v1_endusers_get**](docs/apis/tags/EnduserApi.md#v1_endusers_get) | **get** /v1/endusers | Get the End Users in an Organization
*EnduserApi* | [**v1_endusers_stats_get**](docs/apis/tags/EnduserApi.md#v1_endusers_stats_get) | **get** /v1/endusers/stats |  Get the users statistics for an org
*EnduserApi* | [**v1_mdm_insert_devices_post**](docs/apis/tags/EnduserApi.md#v1_mdm_insert_devices_post) | **post** /v1/mdm/insert_devices |  Insert End User Devices
*EnduserApi* | [**v1_security_roles_enduser_devices_get**](docs/apis/tags/EnduserApi.md#v1_security_roles_enduser_devices_get) | **get** /v1/security_roles/enduser_devices |  List Enduser and Device pairs for given role id
*EnduserApi* | [**v1_unregistered_device_endusers_csv_get**](docs/apis/tags/EnduserApi.md#v1_unregistered_device_endusers_csv_get) | **get** /v1/unregistered_device/endusers/csv |  Get the Unregistered Device&#x27;s Endusers from an Organization in CSV format
*EnduserApi* | [**v2_enduser_get**](docs/apis/tags/EnduserApi.md#v2_enduser_get) | **get** /v2/enduser |  GET endusers
*EnduserApi* | [**v2_enduser_groups_get**](docs/apis/tags/EnduserApi.md#v2_enduser_groups_get) | **get** /v2/enduser_groups |  GET enduser groups
*EnduserApi* | [**v2_enduser_id_get**](docs/apis/tags/EnduserApi.md#v2_enduser_id_get) | **get** /v2/enduser/{id} |  GET enduser
*EnduserApi* | [**v2_endusers_delete**](docs/apis/tags/EnduserApi.md#v2_endusers_delete) | **delete** /v2/endusers |  DELETE enduser
*EventApi* | [**v1_event_types_get**](docs/apis/tags/EventApi.md#v1_event_types_get) | **get** /v1/event_types | 
*EventApi* | [**v1_events_count_get**](docs/apis/tags/EventApi.md#v1_events_count_get) | **get** /v1/events/count |  Get Events Count
*EventApi* | [**v1_events_feed_get**](docs/apis/tags/EventApi.md#v1_events_feed_get) | **get** /v1/events/feed |  Get Events Feed
*EventApi* | [**v1_events_get**](docs/apis/tags/EventApi.md#v1_events_get) | **get** /v1/events |  Get Events
*EventApi* | [**v1_events_post**](docs/apis/tags/EventApi.md#v1_events_post) | **post** /v1/events |  Insert Events
*EventApi* | [**v2_event_daily_counts_get**](docs/apis/tags/EventApi.md#v2_event_daily_counts_get) | **get** /v2/event/daily_counts |  Get the events aggregated data of organization
*RegisteredServiceApi* | [**v1_delete_registered_service_delete**](docs/apis/tags/RegisteredServiceApi.md#v1_delete_registered_service_delete) | **delete** /v1/delete_registered_service |  Delete a service
*RegisteredServiceApi* | [**v1_disable_registered_service_post**](docs/apis/tags/RegisteredServiceApi.md#v1_disable_registered_service_post) | **post** /v1/disable_registered_service | Disable a registered service
*RegisteredServiceApi* | [**v1_enable_registered_service_post**](docs/apis/tags/RegisteredServiceApi.md#v1_enable_registered_service_post) | **post** /v1/enable_registered_service | Enable a registered service
*RegisteredServiceApi* | [**v1_insert_registered_service_post**](docs/apis/tags/RegisteredServiceApi.md#v1_insert_registered_service_post) | **post** /v1/insert_registered_service |  Create a new service or update an existing service
*RegisteredServiceApi* | [**v1_registered_services_get**](docs/apis/tags/RegisteredServiceApi.md#v1_registered_services_get) | **get** /v1/registered_services |  List services
*RegisteredServiceApi* | [**v1_service_connection_test_post**](docs/apis/tags/RegisteredServiceApi.md#v1_service_connection_test_post) | **post** /v1/service_connection_test |  POST to start the service connection test
*RegisteredServiceApi* | [**v1_services_stats_get**](docs/apis/tags/RegisteredServiceApi.md#v1_services_stats_get) | **get** /v1/services/stats |  Get the services statistics for an org
*RegisteredServiceApi* | [**v2_access_tier_id_registered_services_get**](docs/apis/tags/RegisteredServiceApi.md#v2_access_tier_id_registered_services_get) | **get** /v2/access_tier/{id}/registered_services |  List registered services attached to Access Tier for an organization
*SaasappApi* | [**v1_insert_saasapp_post**](docs/apis/tags/SaasappApi.md#v1_insert_saasapp_post) | **post** /v1/insert_saasapp |  Create a new or update an existing saas app service
*SatelliteApi* | [**v2_connector_stats_get**](docs/apis/tags/SatelliteApi.md#v2_connector_stats_get) | **get** /v2/connector/stats | Get the connector statistics for an org
*SatelliteApi* | [**v2_satellite_get**](docs/apis/tags/SatelliteApi.md#v2_satellite_get) | **get** /v2/satellite |  Get list of all satellite tunnel config for an org 
*SatelliteApi* | [**v2_satellite_id_delete**](docs/apis/tags/SatelliteApi.md#v2_satellite_id_delete) | **delete** /v2/satellite/{id} |  Delete satellite tunnel config 
*SatelliteApi* | [**v2_satellite_id_get**](docs/apis/tags/SatelliteApi.md#v2_satellite_id_get) | **get** /v2/satellite/{id} |  Get details of satellite tunnel config 
*SatelliteApi* | [**v2_satellite_id_put**](docs/apis/tags/SatelliteApi.md#v2_satellite_id_put) | **put** /v2/satellite/{id} |  To update satellite tunnel config for an org 
*SatelliteApi* | [**v2_satellite_post**](docs/apis/tags/SatelliteApi.md#v2_satellite_post) | **post** /v2/satellite |  To create satellite tunnel config for an org 
*SecurityPolicyApi* | [**service_tunnel_id_security_policy_get**](docs/apis/tags/SecurityPolicyApi.md#service_tunnel_id_security_policy_get) | **get** /service_tunnel/{id}/security_policy |  GET attached security policy for a service tunnel
*SecurityPolicyApi* | [**service_tunnel_id_security_policy_policy_id_delete**](docs/apis/tags/SecurityPolicyApi.md#service_tunnel_id_security_policy_policy_id_delete) | **delete** /service_tunnel/{id}/security_policy/{policy_id} |  Delete a policy attachment
*SecurityPolicyApi* | [**service_tunnel_id_security_policy_post**](docs/apis/tags/SecurityPolicyApi.md#service_tunnel_id_security_policy_post) | **post** /service_tunnel/{id}/security_policy | Attach a policy to a service tunnel
*SecurityPolicyApi* | [**v1_delete_security_attach_policy_delete**](docs/apis/tags/SecurityPolicyApi.md#v1_delete_security_attach_policy_delete) | **delete** /v1/delete_security_attach_policy |  Delete a policy attachment
*SecurityPolicyApi* | [**v1_delete_security_policy_delete**](docs/apis/tags/SecurityPolicyApi.md#v1_delete_security_policy_delete) | **delete** /v1/delete_security_policy |  Delete a policy
*SecurityPolicyApi* | [**v1_insert_security_attach_policy_post**](docs/apis/tags/SecurityPolicyApi.md#v1_insert_security_attach_policy_post) | **post** /v1/insert_security_attach_policy |  Attach a policy to a service
*SecurityPolicyApi* | [**v1_insert_security_policy_post**](docs/apis/tags/SecurityPolicyApi.md#v1_insert_security_policy_post) | **post** /v1/insert_security_policy |  Create a new policy or update an existing policy
*SecurityPolicyApi* | [**v1_policies_stats_get**](docs/apis/tags/SecurityPolicyApi.md#v1_policies_stats_get) | **get** /v1/policies/stats |  Get the polices statistics for an org
*SecurityPolicyApi* | [**v1_policy_attachment_attached_to_type_attached_to_id_get**](docs/apis/tags/SecurityPolicyApi.md#v1_policy_attachment_attached_to_type_attached_to_id_get) | **get** /v1/policy/attachment/{attachedToType}/{attachedToID} | Gets all attachments for an org by type and id
*SecurityPolicyApi* | [**v1_policy_attachment_attached_to_type_get**](docs/apis/tags/SecurityPolicyApi.md#v1_policy_attachment_attached_to_type_get) | **get** /v1/policy/attachment/{attachedToType} |  Gets all attachments for an org by type
*SecurityPolicyApi* | [**v1_policy_attachment_get**](docs/apis/tags/SecurityPolicyApi.md#v1_policy_attachment_get) | **get** /v1/policy/attachment |  Gets all attachments for an org
*SecurityPolicyApi* | [**v1_policy_policy_id_attachment_get**](docs/apis/tags/SecurityPolicyApi.md#v1_policy_policy_id_attachment_get) | **get** /v1/policy/{policyID}/attachment |  Gets all attachments for policy of an org
*SecurityPolicyApi* | [**v1_security_attach_policies_get**](docs/apis/tags/SecurityPolicyApi.md#v1_security_attach_policies_get) | **get** /v1/security_attach_policies |  List policy attachments
*SecurityPolicyApi* | [**v1_security_policies_get**](docs/apis/tags/SecurityPolicyApi.md#v1_security_policies_get) | **get** /v1/security_policies | List policies
*SecurityRoleApi* | [**v1_delete_security_role_delete**](docs/apis/tags/SecurityRoleApi.md#v1_delete_security_role_delete) | **delete** /v1/delete_security_role |  Delete a role
*SecurityRoleApi* | [**v1_disable_security_role_post**](docs/apis/tags/SecurityRoleApi.md#v1_disable_security_role_post) | **post** /v1/disable_security_role |  Disables a security role
*SecurityRoleApi* | [**v1_enable_security_role_post**](docs/apis/tags/SecurityRoleApi.md#v1_enable_security_role_post) | **post** /v1/enable_security_role |  Enables a security role
*SecurityRoleApi* | [**v1_insert_security_role_post**](docs/apis/tags/SecurityRoleApi.md#v1_insert_security_role_post) | **post** /v1/insert_security_role |  Create a new role or update an existing role
*SecurityRoleApi* | [**v1_security_roles_enduser_devices_get**](docs/apis/tags/SecurityRoleApi.md#v1_security_roles_enduser_devices_get) | **get** /v1/security_roles/enduser_devices |  List Enduser and Device pairs for given role id
*SecurityRoleApi* | [**v1_security_roles_get**](docs/apis/tags/SecurityRoleApi.md#v1_security_roles_get) | **get** /v1/security_roles |  List roles
*SecurityRoleApi* | [**v1_securityroles_stats_get**](docs/apis/tags/SecurityRoleApi.md#v1_securityroles_stats_get) | **get** /v1/securityroles/stats |  Get the security roles statistics for an org
*ServiceTunnelApi* | [**service_tunnel_id_security_policy_get**](docs/apis/tags/ServiceTunnelApi.md#service_tunnel_id_security_policy_get) | **get** /service_tunnel/{id}/security_policy |  GET attached security policy for a service tunnel
*ServiceTunnelApi* | [**service_tunnel_id_security_policy_policy_id_delete**](docs/apis/tags/ServiceTunnelApi.md#service_tunnel_id_security_policy_policy_id_delete) | **delete** /service_tunnel/{id}/security_policy/{policy_id} |  Delete a policy attachment
*ServiceTunnelApi* | [**service_tunnel_id_security_policy_post**](docs/apis/tags/ServiceTunnelApi.md#service_tunnel_id_security_policy_post) | **post** /service_tunnel/{id}/security_policy | Attach a policy to a service tunnel
*ServiceTunnelApi* | [**v2_service_tunnel_get**](docs/apis/tags/ServiceTunnelApi.md#v2_service_tunnel_get) | **get** /v2/service_tunnel | List service tunnel
*ServiceTunnelApi* | [**v2_service_tunnel_id_delete**](docs/apis/tags/ServiceTunnelApi.md#v2_service_tunnel_id_delete) | **delete** /v2/service_tunnel/{id} | Delete a service tunnel
*ServiceTunnelApi* | [**v2_service_tunnel_id_get**](docs/apis/tags/ServiceTunnelApi.md#v2_service_tunnel_id_get) | **get** /v2/service_tunnel/{id} |  List service tunnel
*ServiceTunnelApi* | [**v2_service_tunnel_id_put**](docs/apis/tags/ServiceTunnelApi.md#v2_service_tunnel_id_put) | **put** /v2/service_tunnel/{id} | 
*ServiceTunnelApi* | [**v2_service_tunnel_post**](docs/apis/tags/ServiceTunnelApi.md#v2_service_tunnel_post) | **post** /v2/service_tunnel | Creates a new service tunnel

## Documentation For Models


## Documentation For Authorization

 Authentication schemes defined for the API:
## bearerAuthToken

- **Type**: Bearer authentication (JWT)


## Author

















## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in banyanclient.apis and banyanclient.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from banyanclient.apis.default_api import DefaultApi`
- `from banyanclient.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import banyanclient
from banyanclient.apis import *
from banyanclient.models import *
```
